/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.command;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.classes.PACheck;
import net.slipcor.pvparena.command.BanRunnable;
import net.slipcor.pvparena.commands.AbstractArenaCommand;
import net.slipcor.pvparena.core.Config;
import net.slipcor.pvparena.core.Language;
import net.slipcor.pvparena.loadables.ArenaModule;
import net.slipcor.pvparena.ncloader.NCBLoadable;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BanKick
extends ArenaModule {
    static HashSet<String> commands = new HashSet();
    public List<String> banList = null;

    static {
        commands.add("ban");
        commands.add("kick");
        commands.add("tempban");
        commands.add("unban");
        commands.add("tempunban");
    }

    public BanKick() {
        super("BanKick");
    }

    public String version() {
        return "v1.0.0.25";
    }

    public boolean checkCommand(String s) {
        return commands.contains(s.toLowerCase());
    }

    public PACheck checkJoin(CommandSender sender, PACheck res, boolean b) {
        if (res.hasError()) {
            return res;
        }
        if (this.getBans().contains(sender.getName())) {
            res.setError((NCBLoadable)this, Language.parse((Language.MSG)Language.MSG.MODULE_BANVOTE_YOUBANNED, (String)this.arena.getName()));
        }
        return res;
    }

    public void commitCommand(CommandSender sender, String[] args) {
        if (!commands.contains(args[0].toLowerCase())) {
            return;
        }
        if (!PVPArena.hasAdminPerms((CommandSender)sender) && !PVPArena.hasCreatePerms((CommandSender)sender, (Arena)this.arena)) {
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM, (String)Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM_X_ADMIN)));
            return;
        }
        String cmd = args[0].toLowerCase();
        Player p = Bukkit.getPlayer((String)args[1]);
        if (p != null) {
            args[1] = p.getName();
        }
        if (cmd.equals("kick")) {
            if (!AbstractArenaCommand.argCountValid((CommandSender)sender, (Arena)this.arena, (String[])args, (Integer[])new Integer[]{2})) {
                return;
            }
            this.tryKick(sender, args[1]);
        } else if (cmd.equals("tempban")) {
            if (!AbstractArenaCommand.argCountValid((CommandSender)sender, (Arena)this.arena, (String[])args, (Integer[])new Integer[]{3})) {
                return;
            }
            this.tryKick(sender, args[1]);
            long time = this.parseStringToSeconds(args[2]);
            BanRunnable run = new BanRunnable(this, sender, args[1], false);
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)PVPArena.instance, (Runnable)run, 20L * time);
            this.doBan(sender, args[1]);
        } else if (cmd.equals("ban")) {
            if (!AbstractArenaCommand.argCountValid((CommandSender)sender, (Arena)this.arena, (String[])args, (Integer[])new Integer[]{2})) {
                return;
            }
            this.tryKick(sender, args[1]);
            this.doBan(sender, args[1]);
        } else if (cmd.equals("unban")) {
            if (!AbstractArenaCommand.argCountValid((CommandSender)sender, (Arena)this.arena, (String[])args, (Integer[])new Integer[]{2})) {
                return;
            }
            this.doUnBan(sender, args[1]);
        } else if (cmd.equals("tempunban")) {
            if (!AbstractArenaCommand.argCountValid((CommandSender)sender, (Arena)this.arena, (String[])args, (Integer[])new Integer[]{3})) {
                return;
            }
            long time = this.parseStringToSeconds(args[2]);
            BanRunnable run = new BanRunnable(this, sender, args[1], true);
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)PVPArena.instance, (Runnable)run, 20L * time);
            this.doUnBan(sender, args[1]);
        }
    }

    public void configParse(YamlConfiguration config) {
        List lBans = config.getStringList("bans");
        HashSet<String> hsBans = new HashSet<String>();
        for (String s : lBans) {
            hsBans.add(s);
        }
        this.getBans().clear();
        for (String s : hsBans) {
            this.getBans().add(s);
        }
    }

    private List<String> getBans() {
        if (this.banList == null) {
            this.banList = new ArrayList<String>();
        }
        return this.banList;
    }

    protected void doBan(CommandSender admin, String player) {
        this.getBans().add(player);
        if (admin != null) {
            this.arena.msg(admin, Language.parse((Language.MSG)Language.MSG.MODULE_BANVOTE_BANNED, (String)player));
        }
        this.tryNotify(admin, player, Language.parse((Language.MSG)Language.MSG.MODULE_BANVOTE_YOUBANNED, (String)this.arena.getName()));
        this.arena.getArenaConfig().setManually("bans", this.getBans());
        this.arena.getArenaConfig().save();
    }

    protected void doUnBan(CommandSender admin, String player) {
        this.getBans().remove(player);
        if (admin != null) {
            this.arena.msg(admin, Language.parse((Language.MSG)Language.MSG.MODULE_BANVOTE_UNBANNED, (String)player));
        }
        this.tryNotify(admin, player, Language.parse((Language.MSG)Language.MSG.MODULE_BANVOTE_YOUBANNED, (String)this.arena.getName()));
        this.arena.getArenaConfig().setManually("bans", this.getBans());
        this.arena.getArenaConfig().save();
    }

    private long parseStringToSeconds(String string) {
        String input = "";
        int pos = 0;
        int type = 115;
        while (pos < string.length()) {
            Character c = Character.valueOf(string.charAt(pos));
            try {
                int i = Integer.parseInt("" + c);
                input = String.valueOf(input) + String.valueOf(i);
            }
            catch (Exception e) {
                if (c.charValue() != '.' && c.charValue() != ',') {
                    type = c.charValue();
                    break;
                }
                input = String.valueOf(input) + ".";
            }
            ++pos;
        }
        float time = Float.parseFloat(input);
        if (type == 100) {
            time *= 24.0f;
            type = 104;
        }
        if (type == 104) {
            time *= 60.0f;
            type = 109;
        }
        if (type == 109) {
            time *= 60.0f;
            type = 115;
        }
        return (long)time;
    }

    private void tryKick(CommandSender sender, String string) {
        Player p = Bukkit.getPlayer((String)string);
        if (p == null) {
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.MODULE_BANVOTE_NOTKICKED, (String)string));
            return;
        }
        this.arena.playerLeave(p, Config.CFG.TP_EXIT, true);
        this.arena.msg((CommandSender)p, Language.parse((Language.MSG)Language.MSG.MODULE_BANVOTE_YOUKICKED, (String)this.arena.getName()));
        this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.MODULE_BANVOTE_KICKED, (String)string));
    }

    private void tryNotify(CommandSender sender, String player, String string) {
        Player p = Bukkit.getPlayer((String)string);
        if (p == null) {
            return;
        }
        this.arena.msg((CommandSender)p, string);
    }
}

