/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.chestfiller;

import java.util.ArrayList;
import java.util.Random;
import net.slipcor.pvparena.core.StringParser;
import net.slipcor.pvparena.loadables.ArenaModule;
import net.slipcor.pvparena.loadables.ArenaRegionShape;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Chest;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;

public class ChestFiller
extends ArenaModule {
    boolean setup = false;

    public ChestFiller() {
        super("ChestFiller");
    }

    public String version() {
        return "v1.0.1.76";
    }

    public void displayInfo(CommandSender sender) {
        sender.sendMessage("items: " + (String)this.arena.getArenaConfig().getUnsafe("modules.chestfiller.cfitems"));
        sender.sendMessage("max: " + (Integer)this.arena.getArenaConfig().getUnsafe("modules.chestfiller.cfmaxitems") + " | " + "min: " + (Integer)this.arena.getArenaConfig().getUnsafe("modules.chestfiller.cfminitems"));
    }

    public void parseStart() {
        if (!this.setup) {
            if (this.arena.getArenaConfig().getUnsafe("modules.chestfiller") == null) {
                this.arena.getArenaConfig().setManually("modules.chestfiller.cfitems", (Object)"1");
                this.arena.getArenaConfig().setManually("modules.chestfiller.cfmaxitems", (Object)5);
                this.arena.getArenaConfig().setManually("modules.chestfiller.cfminitems", (Object)0);
                this.arena.getArenaConfig().save();
            }
            if (this.arena.getArenaConfig().getUnsafe("modules.chestfiller.clear") == null) {
                this.arena.getArenaConfig().setManually("modules.chestfiller.clear", (Object)false);
                this.arena.getArenaConfig().save();
            }
        }
        String items = null;
        try {
            items = (String)this.arena.getArenaConfig().getUnsafe("modules.chestfiller.cfitems");
        }
        catch (Exception e) {
            return;
        }
        boolean clear = false;
        try {
            clear = (Boolean)this.arena.getArenaConfig().getUnsafe("modules.chestfiller.clear");
        }
        catch (Exception e) {
            return;
        }
        int max = Integer.parseInt(String.valueOf(this.arena.getArenaConfig().getUnsafe("modules.chestfiller.cfmaxitems")));
        int min = Integer.parseInt(String.valueOf(this.arena.getArenaConfig().getUnsafe("modules.chestfiller.cfminitems")));
        ItemStack[] stacks = StringParser.getItemStacksFromString((String)items);
        if (stacks.length < 1) {
            return;
        }
        for (ArenaRegionShape bf : this.arena.getRegionsByType(ArenaRegionShape.RegionType.BATTLE)) {
            World w = bf.getWorld();
            int x = bf.getMinimumLocation().getX();
            while (x <= bf.getMaximumLocation().getX()) {
                int y = bf.getMinimumLocation().getY();
                while (y <= bf.getMaximumLocation().getY()) {
                    int z = bf.getMinimumLocation().getZ();
                    while (z <= bf.getMaximumLocation().getZ()) {
                        if (w.getBlockAt(x, y, z).getType() == Material.CHEST) {
                            Chest c = (Chest)w.getBlockAt(x, y, z).getState();
                            if (clear) {
                                c.getBlockInventory().clear();
                            }
                            ArrayList<ItemStack> adding = new ArrayList<ItemStack>();
                            Random r = new Random();
                            int count = r.nextInt(max - min) + min;
                            int i = 0;
                            while (i++ < count) {
                                int d = r.nextInt();
                                adding.add(stacks[d % stacks.length].clone());
                            }
                            for (ItemStack it : adding) {
                                c.getInventory().addItem(new ItemStack[]{it});
                            }
                            c.update();
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
    }
}

