/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.latelounge;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.slipcor.pvparena.classes.PACheck;
import net.slipcor.pvparena.commands.PAG_Join;
import net.slipcor.pvparena.core.Config;
import net.slipcor.pvparena.core.Language;
import net.slipcor.pvparena.loadables.ArenaModule;
import net.slipcor.pvparena.ncloader.NCBLoadable;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LateLounge
extends ArenaModule {
    int priority = 3;
    private List<String> playerList = null;

    public LateLounge() {
        super("LateLounge");
    }

    public String version() {
        return "v1.0.1.58";
    }

    public PACheck checkJoin(CommandSender sender, PACheck res, boolean b) {
        if (!b || res.hasError() || res.getPriority() > this.priority) {
            return res;
        }
        Player player = (Player)sender;
        if (this.getPlayerList().contains(player.getName()) && this.getPlayerList().size() < this.arena.getArenaConfig().getInt(Config.CFG.READY_MINPLAYERS)) {
            res.setError((NCBLoadable)this, Language.parse((Language.MSG)Language.MSG.MODULE_LATELOUNGE_WAIT));
            int pos = 1;
            for (String name : this.getPlayerList()) {
                if (name.equals(player.getName())) break;
                ++pos;
            }
            this.arena.msg((CommandSender)player, Language.parse((Language.MSG)Language.MSG.MODULE_LATELOUNGE_POSITION, (String)String.valueOf(pos)));
            return res;
        }
        if (this.arena.getArenaConfig().getInt(Config.CFG.READY_MINPLAYERS) > this.getPlayerList().size() + 1) {
            Player[] aPlayers;
            this.getPlayerList().add(player.getName());
            int pos = this.getPlayerList().size();
            Player[] playerArray = aPlayers = Bukkit.getOnlinePlayers();
            int n = aPlayers.length;
            int n2 = 0;
            while (n2 < n) {
                Player p = playerArray[n2];
                if (!p.equals(player)) {
                    try {
                        this.arena.msg((CommandSender)p, Language.parse((Language.MSG)Language.MSG.MODULE_LATELOUNGE_ANNOUNCE, (String)this.arena.getName(), (String)player.getName()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            this.arena.msg((CommandSender)player, Language.parse((Language.MSG)Language.MSG.MODULE_LATELOUNGE_POSITION, (String)String.valueOf(pos)));
            res.setError((NCBLoadable)this, Language.parse((Language.MSG)Language.MSG.MODULE_LATELOUNGE_WAIT));
            return res;
        }
        if (this.arena.getArenaConfig().getInt(Config.CFG.READY_MINPLAYERS) == this.getPlayerList().size() + 1) {
            Player p;
            this.getPlayerList().add(player.getName());
            HashSet<String> removals = new HashSet<String>();
            for (String s : this.getPlayerList()) {
                p = Bukkit.getPlayerExact((String)s);
                boolean removeMe = false;
                if (p != null) {
                    for (ArenaModule mod : this.arena.getMods()) {
                        if (mod.getName().equals(this.getName()) || !mod.checkJoin((CommandSender)p, new PACheck(), true).hasError()) continue;
                        removeMe = true;
                        break;
                    }
                }
                if (p != null && !removeMe) continue;
                removals.add(s);
                if (p == null) continue;
                res.setError((NCBLoadable)this, Language.parse((Language.MSG)Language.MSG.MODULE_LATELOUNGE_REJOIN));
            }
            if (removals.size() > 0) {
                for (String s : removals) {
                    this.getPlayerList().remove(s);
                }
            } else {
                for (String s : this.getPlayerList()) {
                    if (s.equals(sender.getName())) continue;
                    p = Bukkit.getPlayerExact((String)s);
                    PAG_Join command = new PAG_Join();
                    command.commit(this.arena, (CommandSender)p, new String[0]);
                }
                return res;
            }
            res.setError((NCBLoadable)this, Language.parse((Language.MSG)Language.MSG.MODULE_LATELOUNGE_WAIT));
        }
        return res;
    }

    private List<String> getPlayerList() {
        if (this.playerList == null) {
            this.playerList = new ArrayList<String>();
        }
        return this.playerList;
    }

    public void reset(boolean force) {
        this.getPlayerList().clear();
    }
}

