/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.eventactions;

import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.events.PADeathEvent;
import net.slipcor.pvparena.events.PAEndEvent;
import net.slipcor.pvparena.events.PAExitEvent;
import net.slipcor.pvparena.events.PAJoinEvent;
import net.slipcor.pvparena.events.PAKillEvent;
import net.slipcor.pvparena.events.PALeaveEvent;
import net.slipcor.pvparena.events.PALoseEvent;
import net.slipcor.pvparena.events.PAStartEvent;
import net.slipcor.pvparena.events.PAWinEvent;
import net.slipcor.pvparena.modules.eventactions.EventActions;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class PAListener
implements Listener {
    private final EventActions ea;

    public PAListener(EventActions ea) {
        this.ea = ea;
    }

    @EventHandler
    public void onDeath(PADeathEvent event) {
        Arena a = event.getArena();
        Player p = event.getPlayer();
        this.ea.catchEvent("death", p, a);
    }

    @EventHandler
    public void onEnd(PAEndEvent event) {
        Arena a = event.getArena();
        this.ea.catchEvent("end", null, a);
    }

    @EventHandler
    public void onExit(PAExitEvent event) {
        Arena a = event.getArena();
        Player p = event.getPlayer();
        this.ea.catchEvent("exit", p, a);
    }

    @EventHandler
    public void onJoin(PAJoinEvent event) {
        Arena a = event.getArena();
        Player p = event.getPlayer();
        if (event.isSpectator()) {
            this.ea.catchEvent("spectate", p, a);
        } else {
            this.ea.catchEvent("join", p, a);
        }
    }

    @EventHandler
    public void onKill(PAKillEvent event) {
        Arena a = event.getArena();
        Player p = event.getPlayer();
        this.ea.catchEvent("kill", p, a);
    }

    @EventHandler
    public void onLeave(PALeaveEvent event) {
        Arena a = event.getArena();
        Player p = event.getPlayer();
        this.ea.catchEvent("leave", p, a);
    }

    @EventHandler
    public void onLose(PALoseEvent event) {
        Arena a = event.getArena();
        Player p = event.getPlayer();
        this.ea.catchEvent("lose", p, a);
    }

    @EventHandler
    public void onStart(PAStartEvent event) {
        Arena a = event.getArena();
        this.ea.catchEvent("start", null, a);
    }

    @EventHandler
    public void onWin(PAWinEvent event) {
        Arena a = event.getArena();
        Player p = event.getPlayer();
        this.ea.catchEvent("win", p, a);
    }
}

