/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.fixes;

import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.classes.PACheck;
import net.slipcor.pvparena.commands.AbstractArenaCommand;
import net.slipcor.pvparena.core.Config;
import net.slipcor.pvparena.core.Language;
import net.slipcor.pvparena.core.StringParser;
import net.slipcor.pvparena.loadables.ArenaModule;
import net.slipcor.pvparena.ncloader.NCBLoadable;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class InventoryLoss
extends ArenaModule {
    public InventoryLoss() {
        super("FixInventoryLoss");
    }

    public String version() {
        return "v1.0.1.59";
    }

    public boolean checkCommand(String s) {
        return s.equals("!fil") || s.equals("fixinventoryloss");
    }

    public PACheck checkJoin(CommandSender sender, PACheck res, boolean b) {
        Player player = (Player)sender;
        int priority = 5;
        if (res.hasError() || res.getPriority() > priority) {
            return res;
        }
        if (this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_FIXINVENTORYLOSS_GAMEMODE) && !player.getGameMode().equals((Object)GameMode.SURVIVAL)) {
            res.setError((NCBLoadable)this, Language.parse((Language.MSG)Language.MSG.MODULE_FIXINVENTORYLOSS_GAMEMODE));
            return res;
        }
        if (this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_FIXINVENTORYLOSS_INVENTORY)) {
            ItemStack item;
            ItemStack[] itemStackArray = player.getInventory().getContents();
            int n = itemStackArray.length;
            int n2 = 0;
            while (n2 < n) {
                item = itemStackArray[n2];
                if (item != null && !item.getType().equals((Object)Material.AIR)) {
                    res.setError((NCBLoadable)this, Language.parse((Language.MSG)Language.MSG.MODULE_FIXINVENTORYLOSS_INVENTORY));
                    return res;
                }
                ++n2;
            }
            itemStackArray = player.getInventory().getArmorContents();
            n = itemStackArray.length;
            n2 = 0;
            while (n2 < n) {
                item = itemStackArray[n2];
                if (item != null && !item.getType().equals((Object)Material.AIR)) {
                    res.setError((NCBLoadable)this, Language.parse((Language.MSG)Language.MSG.MODULE_FIXINVENTORYLOSS_INVENTORY));
                    return res;
                }
                ++n2;
            }
        }
        return res;
    }

    public void commitCommand(CommandSender sender, String[] args) {
        if (!PVPArena.hasAdminPerms((CommandSender)sender) && !PVPArena.hasCreatePerms((CommandSender)sender, (Arena)this.arena)) {
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM, (String)Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM_X_ADMIN)));
            return;
        }
        if (!AbstractArenaCommand.argCountValid((CommandSender)sender, (Arena)this.arena, (String[])args, (Integer[])new Integer[]{2})) {
            return;
        }
        Config.CFG c = null;
        if (args[1].equals("gamemode")) {
            c = Config.CFG.MODULES_FIXINVENTORYLOSS_GAMEMODE;
        } else if (args[1].equals("inventory")) {
            c = Config.CFG.MODULES_FIXINVENTORYLOSS_INVENTORY;
        }
        if (c == null) {
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_ARGUMENT, (String)args[1], (String)"gamemode | inventory"));
            return;
        }
        boolean b = this.arena.getArenaConfig().getBoolean(c);
        this.arena.getArenaConfig().set(c, (Object)(!b ? 1 : 0));
        this.arena.getArenaConfig().save();
        this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.SET_DONE, (String)c.getNode(), (String)String.valueOf(!b)));
    }

    public void displayInfo(CommandSender player) {
        player.sendMessage(String.valueOf(StringParser.colorVar((String)"gamemode", (boolean)this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_FIXINVENTORYLOSS_GAMEMODE))) + " || " + StringParser.colorVar((String)"inventory", (boolean)this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_FIXINVENTORYLOSS_INVENTORY)));
    }
}

