/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.betterclasses;

import java.util.HashMap;
import java.util.HashSet;
import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.arena.ArenaClass;
import net.slipcor.pvparena.arena.ArenaPlayer;
import net.slipcor.pvparena.arena.ArenaTeam;
import net.slipcor.pvparena.commands.AbstractArenaCommand;
import net.slipcor.pvparena.core.Language;
import net.slipcor.pvparena.core.StringParser;
import net.slipcor.pvparena.loadables.ArenaModule;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitTask;

public class BetterClasses
extends ArenaModule {
    HashMap<Arena, HashMap<ArenaClass, HashSet<PotionEffect>>> superMap = new HashMap();
    private static final int DURATION = 2400;
    private BukkitTask potionRunner = null;

    public BetterClasses() {
        super("BetterClasses");
    }

    public String version() {
        return "v1.0.1.61";
    }

    public boolean cannotSelectClass(Player player, String className) {
        if (this.notEnoughEXP(player, className)) {
            this.arena.msg((CommandSender)player, Language.parse((Language.MSG)Language.MSG.ERROR_CLASS_NOTENOUGHEXP, (String)className));
            return true;
        }
        int max = 0;
        try {
            max = (Integer)this.arena.getArenaConfig().getUnsafe("modules.betterclasses.maxPlayers." + className);
        }
        catch (Exception e) {
            return false;
        }
        if (max < 1) {
            return false;
        }
        int sum = 0;
        ArenaTeam team = ArenaPlayer.parsePlayer((String)player.getName()).getArenaTeam();
        if (team == null) {
            return true;
        }
        for (ArenaPlayer ap : team.getTeamMembers()) {
            if (ap.getArenaClass() == null || !ap.getArenaClass().getName().equals(className)) continue;
            ++sum;
        }
        if (sum >= max) {
            this.arena.msg((CommandSender)player, Language.parse((Language.MSG)Language.MSG.ERROR_CLASS_FULL, (String)className));
            return true;
        }
        return false;
    }

    public boolean checkCommand(String s) {
        return s.equals("!bc") || s.startsWith("betterclass");
    }

    /*
     * WARNING - void declaration
     */
    public void commitCommand(CommandSender sender, String[] args) {
        if (!PVPArena.hasAdminPerms((CommandSender)sender) && !PVPArena.hasCreatePerms((CommandSender)sender, (Arena)this.arena)) {
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM, (String)Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM_X_ADMIN)));
            return;
        }
        if (!AbstractArenaCommand.argCountValid((CommandSender)sender, (Arena)this.arena, (String[])args, (Integer[])new Integer[]{2, 3, 4, 5})) {
            return;
        }
        ArenaClass c = this.arena.getClass(args[1]);
        if (c == null) {
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_CLASS_NOT_FOUND, (String)args[1]));
            return;
        }
        if (args.length == 5 && args[2].equals("set")) {
            int value = 0;
            try {
                value = Integer.parseInt(args[4]);
            }
            catch (Exception e) {
                this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_NOT_NUMERIC, (String)args[4]));
                return;
            }
            if (args[3].equalsIgnoreCase("exp")) {
                String node = "modules.betterclasses.neededEXPLevel." + c.getName();
                this.arena.getArenaConfig().setManually(node, (Object)value);
                this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.SET_DONE, (String)node, (String)String.valueOf(value)));
            } else if (args[3].equalsIgnoreCase("max")) {
                String node = "modules.betterclasses.maxPlayers." + c.getName();
                this.arena.getArenaConfig().setManually(node, (Object)value);
                this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.SET_DONE, (String)node, (String)String.valueOf(value)));
            }
            return;
        }
        HashSet<Object> ape = new HashSet();
        String s = (String)this.arena.getArenaConfig().getUnsafe("modules.betterclasses.permEffects." + c.getName());
        if (s != null) {
            ape = this.parseStringToPotionEffects(s);
        }
        if (args.length < 3) {
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.MODULE_BETTERCLASSES_LISTHEAD, (String)c.getName()));
            if (ape.size() >= 1) {
                for (PotionEffect potionEffect : ape) {
                    this.arena.msg(sender, String.valueOf(potionEffect.getType().getName()) + "x" + potionEffect.getAmplifier());
                }
            } else {
                this.arena.msg(sender, "---");
            }
            return;
        }
        if (args.length < 4) {
            if (!args[2].equals("clear")) {
                this.printHelp(this.arena, sender);
                return;
            }
            this.arena.getArenaConfig().setManually("modules.betterclasses.permEffects." + c.getName(), (Object)"none");
            this.arena.getArenaConfig().save();
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.MODULE_BETTERCLASSES_CLEAR, (String)c.getName()));
            return;
        }
        if (args[2].equals("add")) {
            void var6_17;
            void var8_27;
            Object var6_15 = null;
            PotionEffectType[] potionEffectTypeArray = PotionEffectType.values();
            int n = potionEffectTypeArray.length;
            boolean bl = false;
            while (var8_27 < n) {
                PotionEffectType x = potionEffectTypeArray[var8_27];
                if (x != null && x.getName().equalsIgnoreCase(args[3])) {
                    PotionEffectType potionEffectType = x;
                    break;
                }
                ++var8_27;
            }
            if (var6_17 == null) {
                this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_POTIONEFFECTTYPE_NOTFOUND, (String)args[3]));
                return;
            }
            int amp = 1;
            if (args.length == 5) {
                try {
                    amp = Integer.parseInt(args[4]);
                }
                catch (Exception exception) {
                    this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_NOT_NUMERIC, (String)args[4]));
                    return;
                }
            }
            ape.add(new PotionEffect((PotionEffectType)var6_17, 2400, amp));
            this.arena.getArenaConfig().setManually("modules.betterclasses.permEffects." + c.getName(), (Object)this.parsePotionEffectsToString(ape));
            this.arena.getArenaConfig().save();
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.MODULE_BETTERCLASSES_ADD, (String)c.getName(), (String)var6_17.getName()));
            return;
        }
        if (args[2].equals("remove")) {
            void var6_20;
            void var8_30;
            Object var6_18 = null;
            PotionEffectType[] potionEffectTypeArray = PotionEffectType.values();
            int n = potionEffectTypeArray.length;
            boolean bl = false;
            while (var8_30 < n) {
                PotionEffectType x = potionEffectTypeArray[var8_30];
                if (x != null && x.getName().equalsIgnoreCase(args[3])) {
                    PotionEffectType potionEffectType = x;
                    break;
                }
                ++var8_30;
            }
            if (var6_20 == null) {
                this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_POTIONEFFECTTYPE_NOTFOUND, (String)args[3]));
                return;
            }
            PotionEffect remove = null;
            for (PotionEffect potionEffect : ape) {
                if (!potionEffect.getType().equals((Object)var6_20)) continue;
                remove = potionEffect;
                break;
            }
            ape.remove(remove);
            this.arena.getArenaConfig().setManually("modules.betterclasses.permEffects." + c.getName(), (Object)this.parsePotionEffectsToString(ape));
            this.arena.getArenaConfig().save();
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.MODULE_BETTERCLASSES_REMOVE, (String)c.getName(), (String)remove.getType().getName()));
            return;
        }
        this.printHelp(this.arena, sender);
    }

    public void configParse(YamlConfiguration cfg) {
        for (ArenaClass c : this.arena.getClasses()) {
            cfg.addDefault("modules.betterclasses.permEffects." + c.getName(), (Object)"none");
            cfg.addDefault("modules.betterclasses.maxPlayers." + c.getName(), (Object)0);
            cfg.addDefault("modules.betterclasses.neededEXPLevel." + c.getName(), (Object)0);
        }
    }

    public void displayInfo(CommandSender sender) {
        if (this.superMap == null || !this.superMap.containsKey(this.arena)) {
            return;
        }
        HashMap<ArenaClass, HashSet<PotionEffect>> map = this.superMap.get(this.arena);
        for (ArenaClass aClass : map.keySet()) {
            HashSet<String> set = new HashSet<String>();
            for (PotionEffect pef : map.get(aClass)) {
                set.add(String.valueOf(pef.getType().getName()) + "x" + pef.getAmplifier() + 1);
            }
            sender.sendMessage(String.valueOf(aClass.getName()) + ": " + StringParser.joinSet(set, (String)"; "));
        }
    }

    public void lateJoin(Player player) {
        if (!this.superMap.containsKey(this.arena)) {
            this.init_map();
        }
        ArenaPlayer ap = ArenaPlayer.parsePlayer((String)player.getName());
        debug.i("respawning player " + String.valueOf(ap), (CommandSender)player);
        HashMap<ArenaClass, HashSet<PotionEffect>> map = this.superMap.get(this.arena);
        if (map == null) {
            PVPArena.instance.getLogger().warning("No superMap entry for arena " + this.arena.toString());
            return;
        }
        ArenaClass c = ap.getArenaClass();
        HashSet<PotionEffect> ape = map.get(c);
        if (ape == null) {
            debug.i("no effects for team " + String.valueOf(c), (CommandSender)player);
            return;
        }
        for (PotionEffect pe : ape) {
            debug.i("adding " + pe.getType(), (CommandSender)player);
            player.addPotionEffect(pe);
        }
    }

    private void init_map() {
        HashMap<ArenaClass, HashSet<PotionEffect>> map = new HashMap<ArenaClass, HashSet<PotionEffect>>();
        this.superMap.put(this.arena, map);
        for (ArenaClass c : this.arena.getClasses()) {
            HashSet<PotionEffect> ape;
            String s = (String)this.arena.getArenaConfig().getUnsafe("modules.betterclasses.permEffects." + c.getName());
            if (s == null || (ape = this.parseStringToPotionEffects(s)) == null || ape.size() < 1) continue;
            map.put(c, ape);
        }
        for (ArenaPlayer ap : this.arena.getFighters()) {
            HashSet ape = (HashSet)map.get(ap.getArenaClass());
            if (ape == null) continue;
            for (PotionEffect pe : ape) {
                ap.get().addPotionEffect(pe);
            }
        }
    }

    private boolean notEnoughEXP(Player player, String className) {
        int needed = 0;
        try {
            needed = (Integer)this.arena.getArenaConfig().getUnsafe("modules.betterclasses.neededEXPLevel." + className);
        }
        catch (Exception e) {
            return false;
        }
        return player.getLevel() < needed;
    }

    private String parsePotionEffectsToString(HashSet<PotionEffect> ape) {
        HashSet<String> result = new HashSet<String>();
        for (PotionEffect pe : ape) {
            result.add(String.valueOf(pe.getType().getName()) + ":" + pe.getAmplifier());
        }
        return StringParser.joinSet(result, (String)",");
    }

    public void reset(boolean force) {
        if (this.potionRunner != null) {
            this.potionRunner.cancel();
            this.potionRunner = null;
        }
    }

    public void parseRespawn(Player player, ArenaTeam team, EntityDamageEvent.DamageCause cause, Entity damager) {
        ArenaClass c;
        HashSet<PotionEffect> ape;
        if (!this.superMap.containsKey(this.arena)) {
            this.init_map();
        }
        ArenaPlayer ap = ArenaPlayer.parsePlayer((String)player.getName());
        debug.i("respawning player " + String.valueOf(ap), (CommandSender)player);
        HashMap<ArenaClass, HashSet<PotionEffect>> map = this.superMap.get(this.arena);
        if (map == null) {
            PVPArena.instance.getLogger().warning("No superMap entry for arena " + this.arena.toString());
            return;
        }
        if (player.getActivePotionEffects() != null && player.getActivePotionEffects().size() > 0) {
            for (PotionEffect eff : player.getActivePotionEffects()) {
                player.removePotionEffect(eff.getType());
            }
        }
        if ((ape = map.get(c = ap.getArenaClass())) == null) {
            debug.i("no effects for class " + String.valueOf(c), (CommandSender)player);
            return;
        }
        for (PotionEffect pe : ape) {
            debug.i("adding " + pe.getType(), (CommandSender)player);
            player.addPotionEffect(pe);
        }
    }

    public void parseStart() {
        if (!this.superMap.containsKey(this.arena)) {
            this.init_map();
        }
        for (ArenaPlayer ap : this.arena.getFighters()) {
            this.parseRespawn(ap.get(), null, null, null);
        }
        class RunLater
        implements Runnable {
            RunLater() {
            }

            @Override
            public void run() {
                for (ArenaPlayer ap : BetterClasses.this.arena.getFighters()) {
                    BetterClasses.this.parseRespawn(ap.get(), null, null, null);
                }
            }
        }
        this.potionRunner = Bukkit.getScheduler().runTaskTimer((Plugin)PVPArena.instance, (Runnable)new RunLater(), 1200L, 1200L);
    }

    private HashSet<PotionEffect> parseStringToPotionEffects(String s) {
        HashSet<PotionEffect> spe = new HashSet<PotionEffect>();
        if (s == null || s.equals("none") || s.equals("")) {
            return spe;
        }
        String current = null;
        try {
            String[] ss;
            String[] stringArray = ss = s.split(",");
            int n = ss.length;
            int n2 = 0;
            while (n2 < n) {
                String sss;
                current = sss = stringArray[n2];
                String[] values = sss.split(":");
                PotionEffectType type = PotionEffectType.getByName((String)values[0].toUpperCase());
                int amp = values.length < 2 ? 1 : Integer.parseInt(values[1]);
                PotionEffect pe = new PotionEffect(type, 2400, amp - 1);
                spe.add(pe);
                ++n2;
            }
        }
        catch (Exception e) {
            PVPArena.instance.getLogger().warning("error while parsing POTION EFFECT DEFINITION \"" + s + "\" : " + current);
        }
        return spe;
    }

    private void printHelp(Arena arena, CommandSender sender) {
        arena.msg(sender, "/pa [arenaname] !bc [classname] | list potion effects");
        arena.msg(sender, "/pa [arenaname] !bc [classname] clear | clear potion effects");
        arena.msg(sender, "/pa [arenaname] !bc [classname] add [type] [amp] | add potion effect");
        arena.msg(sender, "/pa [arenaname] !bc [classname] remove [type] | remove potion effect");
    }
}

