/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.flyspectate;

import java.util.HashSet;
import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.ArenaPlayer;
import net.slipcor.pvparena.core.Debug;
import net.slipcor.pvparena.modules.flyspectate.FlySpectate;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class RealSpectateListener
implements Listener {
    final FlySpectate rs;
    HashSet<Player> spectators = new HashSet();
    Debug debug = new Debug(456);

    public RealSpectateListener(FlySpectate realSpectate) {
        this.rs = realSpectate;
    }

    void initiate(ArenaPlayer ap) {
        for (ArenaPlayer a : this.rs.getArena().getEveryone()) {
            a.get().hidePlayer(ap.get());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getEntityType() != EntityType.PLAYER) {
            return;
        }
        Player subject = (Player)event.getEntity();
        if (!this.spectators.contains(subject)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player subject = event.getPlayer();
        if (!this.spectators.contains(subject)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        Player subject = event.getPlayer();
        if (!this.spectators.contains(subject)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player subject = event.getPlayer();
        if (!this.spectators.contains(subject)) {
            return;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryOpen(InventoryOpenEvent event) {
        Player subject = (Player)event.getPlayer();
        if (!this.spectators.contains(subject)) {
            return;
        }
        event.setCancelled(true);
        event.getPlayer().closeInventory();
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        Player subject = (Player)event.getWhoClicked();
        if (!this.spectators.contains(subject)) {
            return;
        }
        event.setCancelled(true);
        event.getWhoClicked().closeInventory();
    }

    @EventHandler(ignoreCancelled=true)
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        if (event == null || event.getEntity() == null || event.getEntity().getShooter() == null || !event.getEntity().getShooter().getType().equals((Object)EntityType.PLAYER)) {
            return;
        }
        Player subject = (Player)event.getEntity().getShooter();
        if (!this.spectators.contains(subject)) {
            return;
        }
        event.setCancelled(true);
    }

    public void hidePlayerLater(Player s) {
        if (!this.spectators.contains(s)) {
            this.spectators.add(s);
            class LaterRun
            implements Runnable {
                private final /* synthetic */ Player val$s;

                LaterRun(Player player) {
                    this.val$s = player;
                }

                @Override
                public void run() {
                    for (ArenaPlayer ap : RealSpectateListener.this.rs.getArena().getEveryone()) {
                        ap.get().hidePlayer(this.val$s);
                    }
                }
            }
            Bukkit.getScheduler().runTaskLater((Plugin)PVPArena.instance, (Runnable)new LaterRun(s), 5L);
        }
    }

    public void hideAllSpectatorsLater() {
        for (Player s : this.spectators) {
            class LaterRun
            implements Runnable {
                private final Player s;

                LaterRun(Player p) {
                    this.s = p;
                }

                @Override
                public void run() {
                    for (ArenaPlayer ap : RealSpectateListener.this.rs.getArena().getEveryone()) {
                        ap.get().hidePlayer(this.s);
                    }
                }
            }
            Bukkit.getScheduler().runTaskLater((Plugin)PVPArena.instance, (Runnable)new LaterRun(s), 5L);
        }
    }

    public void removeSpectator(Player spectator) {
        this.spectators.remove(spectator);
    }

    public void stop() {
        HashSet<Player> removals = new HashSet<Player>();
        removals.addAll(this.spectators);
        for (Player p : removals) {
            Bukkit.getServer().dispatchCommand((CommandSender)p, "pa leave");
        }
        this.spectators.clear();
    }
}

