/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.announcements;

import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.arena.ArenaPlayer;
import net.slipcor.pvparena.arena.ArenaTeam;
import net.slipcor.pvparena.commands.AbstractArenaCommand;
import net.slipcor.pvparena.core.Config;
import net.slipcor.pvparena.core.Debug;
import net.slipcor.pvparena.core.Language;
import net.slipcor.pvparena.core.StringParser;
import net.slipcor.pvparena.loadables.ArenaModule;
import net.slipcor.pvparena.managers.TeamManager;
import net.slipcor.pvparena.modules.announcements.Announcement;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;

public class AnnouncementManager
extends ArenaModule {
    public AnnouncementManager() {
        super("Announcements");
        debug = new Debug(400);
    }

    public String version() {
        return "v1.0.1.59";
    }

    public void announce(String message, String type2) {
        Announcement.announce(this.arena, Announcement.type.valueOf(type2), message);
    }

    public boolean checkCommand(String s) {
        return s.equals("!aa") || s.startsWith("announce");
    }

    public void commitCommand(CommandSender sender, String[] args) {
        if (!PVPArena.hasAdminPerms((CommandSender)sender) && !PVPArena.hasCreatePerms((CommandSender)sender, (Arena)this.arena)) {
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM, (String)Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM_X_ADMIN)));
            return;
        }
        if (!AbstractArenaCommand.argCountValid((CommandSender)sender, (Arena)this.arena, (String[])args, (Integer[])new Integer[]{2})) {
            return;
        }
        if (args[0].equals("!aa") || args[0].startsWith("announce")) {
            Announcement.type[] typeArray = Announcement.type.values();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Announcement.type t = typeArray[n2];
                if (t.name().equalsIgnoreCase(args[1])) {
                    boolean b = this.arena.getArenaConfig().getBoolean(Config.CFG.getByNode((String)("MODULES_ANNOUNCEMENTS_" + t.name())));
                    this.arena.getArenaConfig().set(Config.CFG.getByNode((String)("MODULES_ANNOUNCEMENTS_" + t.name())), (Object)(!b ? 1 : 0));
                    this.arena.getArenaConfig().save();
                    this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.SET_DONE, (String)t.name(), (String)String.valueOf(!b)));
                    return;
                }
                ++n2;
            }
            String list = StringParser.joinArray((Object[])Announcement.type.values(), (String)", ");
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_ARGUMENT, (String)args[1], (String)list));
            return;
        }
    }

    public void parsePlayerDeath(Player player, EntityDamageEvent cause) {
        Announcement.announce(this.arena, Announcement.type.LOSER, Language.parse((Language.MSG)Language.MSG.FIGHT_KILLED_BY, (String)player.getName(), (String)this.arena.parseDeathCause(player, cause.getCause(), (Entity)ArenaPlayer.getLastDamagingPlayer((Event)cause))));
    }

    public void displayInfo(CommandSender player) {
        player.sendMessage("");
        player.sendMessage("radius: " + StringParser.colorVar((int)this.arena.getArenaConfig().getInt(Config.CFG.MODULES_ANNOUNCEMENTS_RADIUS, 0)) + " || color: " + StringParser.colorVar((String)this.arena.getArenaConfig().getString(Config.CFG.MODULES_ANNOUNCEMENTS_COLOR)));
        player.sendMessage(String.valueOf(StringParser.colorVar((String)"advert", (boolean)this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_ANNOUNCEMENTS_ADVERT))) + " || " + StringParser.colorVar((String)"custom", (boolean)this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_ANNOUNCEMENTS_CUSTOM)) + " || " + StringParser.colorVar((String)"end", (boolean)this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_ANNOUNCEMENTS_END)) + " || " + StringParser.colorVar((String)"join", (boolean)this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_ANNOUNCEMENTS_JOIN)) + " || " + StringParser.colorVar((String)"loser", (boolean)this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_ANNOUNCEMENTS_LOSER)) + " || " + StringParser.colorVar((String)"prize", (boolean)this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_ANNOUNCEMENTS_PRIZE)) + " || " + StringParser.colorVar((String)"start", (boolean)this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_ANNOUNCEMENTS_START)) + " || " + StringParser.colorVar((String)"winner", (boolean)this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_ANNOUNCEMENTS_WINNER)));
    }

    public void parseJoin(CommandSender sender, ArenaTeam team) {
        debug.i("parseJoin ... ", sender);
        if (TeamManager.countPlayersInTeams((Arena)this.arena) < 2) {
            Announcement.announce(this.arena, Announcement.type.ADVERT, Language.parse((Language.MSG)Language.MSG.ANNOUNCE_ARENA_STARTING, (String)this.arena.getName()));
        }
        if (this.arena.isFreeForAll()) {
            Announcement.announce(this.arena, Announcement.type.JOIN, this.arena.getArenaConfig().getString(Config.CFG.MSG_PLAYERJOINED).replace("%1%", sender.getName()));
        } else {
            Announcement.announce(this.arena, Announcement.type.JOIN, this.arena.getArenaConfig().getString(Config.CFG.MSG_PLAYERJOINEDTEAM).replace("%1%", sender.getName()).replace("%2%", team.getColoredName()));
        }
    }

    public void parsePlayerLeave(Player player, ArenaTeam team) {
        if (team == null) {
            Announcement.announce(this.arena, Announcement.type.LOSER, Language.parse((Language.MSG)Language.MSG.FIGHT_PLAYER_LEFT, (String)player.getName()));
        } else {
            Announcement.announce(this.arena, Announcement.type.LOSER, Language.parse((Language.MSG)Language.MSG.FIGHT_PLAYER_LEFT, (String)team.colorizePlayer(player)));
        }
    }

    public void parseStart() {
        Announcement.announce(this.arena, Announcement.type.START, Language.parse((Language.MSG)Language.MSG.FIGHT_BEGINS));
    }
}

