/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.blockrestore;

import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.classes.PABlockLocation;
import net.slipcor.pvparena.core.Debug;
import net.slipcor.pvparena.managers.ArenaManager;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;

public class ArenaBlock {
    private Debug debug = new Debug(9);
    public String arena;
    private final PABlockLocation location;
    public final Material material;
    private final byte data;
    private final String[] lines;

    public ArenaBlock(Block block) {
        this.location = new PABlockLocation(block.getLocation());
        this.material = block.getType();
        this.data = block.getData();
        this.debug.i("creating arena block:");
        this.debug.i("loc: " + this.location.toString() + "; mat: " + this.material.toString() + "; data " + String.valueOf(this.data));
        try {
            this.arena = ArenaManager.getArenaByRegionLocation((PABlockLocation)this.location).getName();
        }
        catch (Exception e) {
            this.arena = "";
        }
        this.lines = block.getState() instanceof Sign ? ((Sign)block.getState()).getLines() : null;
    }

    public ArenaBlock(Block block, Material type) {
        this.location = new PABlockLocation(block.getLocation());
        try {
            this.arena = ArenaManager.getArenaByRegionLocation((PABlockLocation)this.location).getName();
        }
        catch (Exception e) {
            this.arena = "";
        }
        this.material = type;
        this.data = block.getData();
        this.lines = null;
        this.debug.i("creating arena block:");
        this.debug.i("loc: " + this.location.toString() + "; mat: " + this.material.toString() + "; data " + String.valueOf(this.data));
    }

    public void reset() {
        Block b = this.location.toLocation().getBlock();
        b.setType(this.material);
        b.setData(this.data);
        if (this.lines != null) {
            int i = 0;
            String[] stringArray = this.lines;
            int n = this.lines.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s != null) {
                    try {
                        ((Sign)b.getState()).setLine(i, s);
                    }
                    catch (Exception e) {
                        PVPArena.instance.getLogger().warning("tried to reset sign at location " + this.location.toString());
                    }
                }
                ++i;
                ++n2;
            }
        }
    }
}

