/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.blockrestore;

import java.util.HashMap;
import java.util.Iterator;
import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.commands.PAA_Edit;
import net.slipcor.pvparena.core.Config;
import net.slipcor.pvparena.core.Debug;
import net.slipcor.pvparena.modules.blockrestore.ArenaBlock;
import net.slipcor.pvparena.modules.blockrestore.Blocks;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public class BlockRestoreRunnable
implements Runnable {
    private HashMap<Location, ArenaBlock> removals;
    private Arena arena;
    private Debug debug = new Debug(67);

    public BlockRestoreRunnable(Arena arena, HashMap<Location, ArenaBlock> blocks) {
        this.arena = arena;
        this.removals = this.getBlocks();
    }

    @Override
    public void run() {
        PAA_Edit.activeEdits.put("server", this.arena);
        Iterator<Location> iterator = this.removals.keySet().iterator();
        if (iterator.hasNext()) {
            Location l = iterator.next();
            this.debug.i("location: " + l.toString());
            this.removals.get(l).reset();
            this.removals.remove(l);
            Blocks.blocks.remove(l);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)PVPArena.instance, (Runnable)this, (long)this.arena.getArenaConfig().getInt(Config.CFG.MODULES_BLOCKRESTORE_OFFSET) * 1L);
            return;
        }
        PAA_Edit.activeEdits.remove("server");
    }

    private HashMap<Location, ArenaBlock> getBlocks() {
        HashMap<Location, ArenaBlock> result = new HashMap<Location, ArenaBlock>();
        this.debug.i("reading all arenablocks");
        for (Location l : Blocks.blocks.keySet()) {
            if (!Blocks.blocks.get((Object)l).arena.equals(this.arena.getName()) && !Blocks.blocks.get((Object)l).arena.equals("")) continue;
            result.put(l, Blocks.blocks.get(l));
            this.debug.i(" - " + l.toString());
        }
        return result;
    }
}

