/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.blockrestore;

import java.util.HashMap;
import java.util.Set;
import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.classes.PABlockLocation;
import net.slipcor.pvparena.commands.AbstractArenaCommand;
import net.slipcor.pvparena.core.Config;
import net.slipcor.pvparena.core.Debug;
import net.slipcor.pvparena.core.Language;
import net.slipcor.pvparena.core.StringParser;
import net.slipcor.pvparena.loadables.ArenaModule;
import net.slipcor.pvparena.loadables.ArenaRegionShape;
import net.slipcor.pvparena.modules.blockrestore.ArenaBlock;
import net.slipcor.pvparena.modules.blockrestore.BlockRestoreRunnable;
import net.slipcor.pvparena.modules.blockrestore.RestoreContainer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.material.Attachable;
import org.bukkit.plugin.Plugin;

public class Blocks
extends ArenaModule {
    public static HashMap<Location, ArenaBlock> blocks = new HashMap();
    public static HashMap<Location, String[]> signs = new HashMap();
    private static HashMap<ArenaRegionShape, RestoreContainer> containers = new HashMap();
    private static Debug debug = new Debug(24);

    public Blocks() {
        super("BlockRestore");
    }

    public String version() {
        return "v1.0.1.59";
    }

    private void checkBlock(Block b, BlockFace bf) {
        Attachable a;
        if ((b.getType().equals((Object)Material.LADDER) || b.getType().equals((Object)Material.STONE_BUTTON) || b.getType().equals((Object)Material.LEVER) || b.getType().equals((Object)Material.WALL_SIGN)) && (a = (Attachable)b.getState().getData()).getAttachedFace().equals((Object)bf)) {
            this.saveBlock(b);
        }
    }

    public boolean checkCommand(String s) {
        return s.equals("blockrestore") || s.equals("!br");
    }

    public void commitCommand(CommandSender sender, String[] args) {
        if (!PVPArena.hasAdminPerms((CommandSender)sender) && !PVPArena.hasCreatePerms((CommandSender)sender, (Arena)this.arena)) {
            Arena.pmsg((CommandSender)sender, (String)Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM, (String)Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM_X_ADMIN)));
            return;
        }
        if (!AbstractArenaCommand.argCountValid((CommandSender)sender, (Arena)this.arena, (String[])args, (Integer[])new Integer[]{2, 3})) {
            return;
        }
        if (args[1].startsWith("clearinv")) {
            this.arena.getArenaConfig().setManually("inventories", null);
            this.arena.getArenaConfig().save();
            Arena.pmsg((CommandSender)sender, (String)Language.parse((Language.MSG)Language.MSG.MODULE_BLOCKRESTORE_CLEARINVDONE));
            return;
        }
        if (args[1].equals("hard") || args[1].equals("restorechests")) {
            Config.CFG c = null;
            c = args[1].equals("hard") ? Config.CFG.MODULES_BLOCKRESTORE_HARD : Config.CFG.MODULES_BLOCKRESTORE_RESTORECHESTS;
            boolean b = this.arena.getArenaConfig().getBoolean(c);
            this.arena.getArenaConfig().set(c, (Object)(!b ? 1 : 0));
            this.arena.getArenaConfig().save();
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.SET_DONE, (String)c.getNode(), (String)String.valueOf(!b)));
            return;
        }
        if (args[1].equals("offset")) {
            if (!AbstractArenaCommand.argCountValid((CommandSender)sender, (Arena)this.arena, (String[])args, (Integer[])new Integer[]{3})) {
                return;
            }
            int i = 0;
            try {
                i = Integer.parseInt(args[2]);
            }
            catch (Exception e) {
                this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_NOT_NUMERIC, (String)args[2]));
                return;
            }
            this.arena.getArenaConfig().set(Config.CFG.MODULES_BLOCKRESTORE_OFFSET, (Object)i);
            this.arena.getArenaConfig().save();
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.SET_DONE, (String)Config.CFG.MODULES_BLOCKRESTORE_OFFSET.getNode(), (String)String.valueOf(i)));
        }
    }

    public void displayInfo(CommandSender player) {
        player.sendMessage(String.valueOf(StringParser.colorVar((String)"hard", (boolean)this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_BLOCKRESTORE_HARD))) + " | " + StringParser.colorVar((String)"chests", (boolean)this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_BLOCKRESTORE_RESTORECHESTS)) + " | offset " + this.arena.getArenaConfig().getInt(Config.CFG.MODULES_BLOCKRESTORE_OFFSET));
    }

    public void onEntityExplode(EntityExplodeEvent event) {
        if (!this.arena.isLocked() && !this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_BLOCKRESTORE_HARD)) {
            for (Block b : event.blockList()) {
                this.saveBlock(b);
            }
        }
    }

    public void onBlockBreak(Block block) {
        debug.i("block break in blockRestore");
        if (this.arena == null || this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_BLOCKRESTORE_HARD)) {
            debug.i(this.arena + " || blockRestore.hard: " + this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_BLOCKRESTORE_HARD));
            return;
        }
        if (!this.arena.isLocked()) {
            this.checkBlock(block.getRelative(BlockFace.NORTH), BlockFace.SOUTH);
            this.checkBlock(block.getRelative(BlockFace.SOUTH), BlockFace.NORTH);
            this.checkBlock(block.getRelative(BlockFace.EAST), BlockFace.WEST);
            this.checkBlock(block.getRelative(BlockFace.WEST), BlockFace.EAST);
            this.saveBlock(block);
        }
        debug.i("!arena.isLocked() " + !this.arena.isLocked());
    }

    public void onBlockPiston(Block block) {
        if (!this.arena.isLocked() && !this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_BLOCKRESTORE_HARD)) {
            this.saveBlock(block);
        }
    }

    public void onBlockPlace(Block block, Material mat) {
        if (!this.arena.isLocked() && !this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_BLOCKRESTORE_HARD)) {
            this.saveBlock(block, mat);
        }
    }

    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        if (!this.arena.isLocked()) {
            event.setCancelled(true);
        }
    }

    public void reset(boolean force) {
        this.resetBlocks();
        this.restoreChests();
    }

    private void resetBlocks() {
        debug.i("resetting blocks");
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)PVPArena.instance, (Runnable)new BlockRestoreRunnable(this.arena, blocks));
    }

    public void restoreChests() {
        debug.i("resetting chests");
        Set bfs = this.arena.getRegionsByType(ArenaRegionShape.RegionType.BATTLE);
        if (bfs.size() < 1) {
            debug.i("no battlefield region, skipping restoreChests");
            return;
        }
        if (!this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_BLOCKRESTORE_RESTORECHESTS)) {
            debug.i("not restoring chests, skipping restoreChests");
            return;
        }
        for (ArenaRegionShape bfRegion : bfs) {
            debug.i("resetting arena: " + bfRegion.getName());
            if (containers.get(bfRegion) == null) continue;
            debug.i("container not null!");
            containers.get(bfRegion).restoreChests();
        }
    }

    private void saveBlock(Block block) {
        debug.i("save block at " + block.getLocation().toString());
        if (!blocks.containsKey(block.getLocation())) {
            blocks.put(block.getLocation(), new ArenaBlock(block));
        }
    }

    private void saveBlock(Block block, Material type) {
        debug.i("save block at " + block.getLocation().toString());
        debug.i(" - type: " + type.toString());
        if (!blocks.containsKey(block.getLocation())) {
            blocks.put(block.getLocation(), new ArenaBlock(block, type));
        }
    }

    public void saveChests() {
        Set bfs = this.arena.getRegionsByType(ArenaRegionShape.RegionType.BATTLE);
        if (bfs.size() < 1) {
            debug.i("no battlefield region, skipping saveChests");
            return;
        }
        if (!this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_BLOCKRESTORE_RESTORECHESTS)) {
            debug.i("not restoring chests, skipping saveChests");
            return;
        }
        for (ArenaRegionShape bfRegion : bfs) {
            containers.get(bfRegion).saveChests();
        }
    }

    public void parseStart() {
        Set bfs = this.arena.getRegionsByType(ArenaRegionShape.RegionType.BATTLE);
        if (bfs.size() < 1) {
            debug.i("no battlefield region, skipping restoreChests");
            return;
        }
        for (ArenaRegionShape region : bfs) {
            this.saveRegion(region);
        }
        for (ArenaRegionShape r : this.arena.getRegions()) {
            if (!r.getName().startsWith("restore")) continue;
            this.saveRegion(r);
        }
    }

    private void saveRegion(ArenaRegionShape region) {
        if (region == null) {
            return;
        }
        containers.put(region, new RestoreContainer(this, region));
        this.saveChests();
        if (!this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_BLOCKRESTORE_HARD) && !region.getName().startsWith("restore")) {
            return;
        }
        PABlockLocation min = region.getMinimumLocation();
        PABlockLocation max = region.getMaximumLocation();
        World world = Bukkit.getWorld((String)min.getWorldName());
        int x = min.getX();
        while (x <= max.getX()) {
            int y = min.getY();
            while (y <= max.getY()) {
                int z = min.getZ();
                while (z <= max.getZ()) {
                    this.saveBlock(world.getBlockAt(x, y, z));
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }
}

