/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.realspectate;

import java.util.HashSet;
import net.minecraft.server.v1_4_6.EntityPlayer;
import net.minecraft.server.v1_4_6.Packet;
import net.minecraft.server.v1_4_6.Packet16BlockItemSwitch;
import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.ArenaPlayer;
import net.slipcor.pvparena.managers.InventoryManager;
import net.slipcor.pvparena.modules.realspectate.RealSpectateListener;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_4_6.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;

public class SpectateWrapper {
    private final Player suspect;
    private final HashSet<Player> spectators = new HashSet();
    private final RealSpectateListener listener;

    public SpectateWrapper(Player spectator, Player fighter, RealSpectateListener listener) {
        this.suspect = fighter;
        this.spectators.add(spectator);
        ArenaPlayer.parsePlayer((String)spectator.getName()).setTelePass(true);
        this.listener = listener;
    }

    public void update(Player s) {
        if (!this.spectators.contains(s)) {
            this.spectators.add(s);
            class LaterRun
            implements Runnable {
                private final /* synthetic */ Player val$s;

                LaterRun(Player player) {
                    this.val$s = player;
                }

                @Override
                public void run() {
                    this.val$s.setHealth(SpectateWrapper.this.suspect.getHealth() > 0 ? SpectateWrapper.this.suspect.getHealth() : 1);
                    InventoryManager.clearInventory((Player)this.val$s);
                    this.val$s.getInventory().setArmorContents(SpectateWrapper.this.suspect.getInventory().getArmorContents());
                    this.val$s.getInventory().setContents(SpectateWrapper.this.suspect.getInventory().getContents());
                    this.val$s.updateInventory();
                    this.val$s.teleport(SpectateWrapper.this.suspect.getLocation());
                    for (ArenaPlayer ap : ((SpectateWrapper)SpectateWrapper.this).listener.rs.getArena().getEveryone()) {
                        ap.get().hidePlayer(this.val$s);
                    }
                    this.val$s.hidePlayer(SpectateWrapper.this.suspect);
                }
            }
            Bukkit.getScheduler().runTaskLater((Plugin)PVPArena.instance, (Runnable)new LaterRun(s), 5L);
        }
    }

    public void update() {
        for (Player s : this.spectators) {
            class LaterRun
            implements Runnable {
                private final Player s;

                LaterRun(Player p) {
                    this.s = p;
                }

                @Override
                public void run() {
                    this.s.setHealth(SpectateWrapper.this.suspect.getHealth() > 0 ? SpectateWrapper.this.suspect.getHealth() : 1);
                    InventoryManager.clearInventory((Player)this.s);
                    this.s.getInventory().setArmorContents(SpectateWrapper.this.suspect.getInventory().getArmorContents());
                    this.s.getInventory().setContents(SpectateWrapper.this.suspect.getInventory().getContents());
                    this.s.updateInventory();
                    this.s.teleport(SpectateWrapper.this.suspect.getLocation());
                    for (ArenaPlayer ap : ((SpectateWrapper)SpectateWrapper.this).listener.rs.getArena().getEveryone()) {
                        ap.get().hidePlayer(this.s);
                    }
                    this.s.hidePlayer(SpectateWrapper.this.suspect);
                }
            }
            Bukkit.getScheduler().runTaskLater((Plugin)PVPArena.instance, (Runnable)new LaterRun(s), 5L);
        }
    }

    public Player getSuspect() {
        return this.suspect;
    }

    public boolean hasSpectator(Player p) {
        return this.spectators.contains(p);
    }

    public void closeInventory(Inventory inventory) {
        for (Player p : this.spectators) {
            p.closeInventory();
        }
    }

    public void openInventory(Inventory inventory) {
        for (Player p : this.spectators) {
            p.openInventory(inventory);
        }
    }

    public void removeSpectator(Player spectator) {
        this.spectators.remove(spectator);
        if (this.spectators.size() < 1) {
            this.listener.spectated_players.remove(this.suspect);
        }
    }

    public void selectItem(int newSlot) {
        for (Player p : this.spectators) {
            CraftPlayer cp = (CraftPlayer)p;
            EntityPlayer player = cp.getHandle();
            player.playerConnection.sendPacket((Packet)new Packet16BlockItemSwitch(newSlot));
        }
    }

    public void stopSpectating() {
        for (Player p : this.spectators) {
            if (this.listener.spectated_players.size() < 1) {
                Bukkit.getServer().dispatchCommand((CommandSender)p, "pa leave");
                continue;
            }
            this.listener.switchPlayer(p, this.suspect, true);
        }
        this.spectators.clear();
    }

    public void updateHealth() {
        class LaterRun
        implements Runnable {
            LaterRun() {
            }

            @Override
            public void run() {
                for (Player p : SpectateWrapper.this.spectators) {
                    p.setHealth(SpectateWrapper.this.suspect.getHealth() > 0 ? SpectateWrapper.this.suspect.getHealth() : 1);
                }
            }
        }
        Bukkit.getScheduler().runTaskLater((Plugin)PVPArena.instance, (Runnable)new LaterRun(), 5L);
    }

    public void updateInventory() {
        class LaterRun
        implements Runnable {
            LaterRun() {
            }

            @Override
            public void run() {
                for (Player p : SpectateWrapper.this.spectators) {
                    InventoryManager.clearInventory((Player)p);
                    p.getInventory().setArmorContents(SpectateWrapper.this.suspect.getInventory().getArmorContents());
                    p.getInventory().setContents(SpectateWrapper.this.suspect.getInventory().getContents());
                    p.updateInventory();
                }
            }
        }
        Bukkit.getScheduler().runTaskLater((Plugin)PVPArena.instance, (Runnable)new LaterRun(), 5L);
    }

    public void updateLocation() {
        class LaterRun
        implements Runnable {
            LaterRun() {
            }

            @Override
            public void run() {
                for (Player p : SpectateWrapper.this.spectators) {
                    p.teleport(SpectateWrapper.this.suspect.getLocation());
                }
            }
        }
        Bukkit.getScheduler().runTaskLater((Plugin)PVPArena.instance, (Runnable)new LaterRun(), 5L);
    }

    public void stopHard() {
        for (Player p : this.spectators) {
            Bukkit.getServer().dispatchCommand((CommandSender)p, "pa leave");
        }
    }
}

