/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.arenaboards;

import java.util.HashMap;
import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.arena.ArenaPlayer;
import net.slipcor.pvparena.classes.PABlockLocation;
import net.slipcor.pvparena.core.Debug;
import net.slipcor.pvparena.core.Language;
import net.slipcor.pvparena.managers.StatisticsManager;
import net.slipcor.pvparena.modules.arenaboards.ArenaBoardColumn;
import net.slipcor.pvparena.modules.arenaboards.ArenaBoardManager;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class ArenaBoard {
    public static final Debug debug = new Debug(10);
    private PABlockLocation location;
    protected ArenaBoardManager abm;
    public boolean global;
    public StatisticsManager.type sortBy = StatisticsManager.type.KILLS;
    private HashMap<StatisticsManager.type, ArenaBoardColumn> columns = new HashMap();

    public ArenaBoard(ArenaBoardManager m, PABlockLocation loc, Arena a) {
        this.abm = m;
        this.location = loc;
        this.global = a == null;
        debug.i("constructing arena board");
        this.construct();
    }

    private void construct() {
        PABlockLocation l = this.location;
        int border = 10;
        try {
            Sign s = (Sign)l.toLocation().getBlock().getState();
            BlockFace bf = this.getRightDirection(s);
            debug.i("parsing signs: ");
            do {
                StatisticsManager.type t = null;
                try {
                    t = StatisticsManager.getTypeBySignLine((String)s.getLine(0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.columns.put(t, new ArenaBoardColumn(this, l));
                debug.i("putting column type " + this.toString());
                l = new PABlockLocation(l.toLocation().getBlock().getRelative(bf).getLocation());
                s = (Sign)l.toLocation().getBlock().getState();
            } while (border-- > 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PABlockLocation getLocation() {
        return this.location;
    }

    private BlockFace getRightDirection(Sign s) {
        Block block = s.getBlock();
        org.bukkit.material.Sign sign = (org.bukkit.material.Sign)block.getState().getData();
        if (sign.getFacing() == BlockFace.EAST) {
            return BlockFace.NORTH;
        }
        if (sign.getFacing() == BlockFace.WEST) {
            return BlockFace.SOUTH;
        }
        if (sign.getFacing() == BlockFace.NORTH) {
            return BlockFace.WEST;
        }
        if (sign.getFacing() == BlockFace.SOUTH) {
            return BlockFace.EAST;
        }
        return null;
    }

    public void update() {
        debug.i("ArenaBoard update()");
        StatisticsManager.type[] typeArray = StatisticsManager.type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            StatisticsManager.type t = typeArray[n2];
            debug.i("checking stat: " + t.name());
            if (this.columns.containsKey(t)) {
                debug.i("found! reading!");
                String[] s = StatisticsManager.read((ArenaPlayer[])StatisticsManager.getStats((Arena)(this.global ? null : this.abm.getArena()), (StatisticsManager.type)this.sortBy), (StatisticsManager.type)t, (boolean)this.global);
                this.columns.get(t).write(s);
            }
            ++n2;
        }
    }

    public static boolean checkInteract(ArenaBoardManager abm, PlayerInteractEvent event) {
        Player player = event.getPlayer();
        debug.i("checking ArenaBoard interact", (CommandSender)player);
        if (event.getClickedBlock() == null) {
            return false;
        }
        debug.i("block is not null", (CommandSender)player);
        if (!abm.boards.containsKey(event.getClickedBlock().getLocation()) && ArenaBoardManager.globalBoard == null || !ArenaBoardManager.globalBoard.getLocation().equals((Object)event.getClickedBlock().getLocation())) {
            return false;
        }
        debug.i("arenaboard exists", (CommandSender)player);
        ArenaBoard ab = abm.boards.get(event.getClickedBlock().getLocation());
        if (ab == null) {
            ab = ArenaBoardManager.globalBoard;
        }
        if (ab.global) {
            debug.i("global!", (CommandSender)player);
            if (event.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) {
                ab.sortBy = StatisticsManager.type.next((StatisticsManager.type)ab.sortBy);
                Arena.pmsg((CommandSender)player, (String)Language.parse((Language.MSG)Language.MSG.MODULE_ARENABOARDS_SORTINGBY, (String)ab.sortBy.toString()));
                return true;
            }
            if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
                ab.sortBy = StatisticsManager.type.last((StatisticsManager.type)ab.sortBy);
                Arena.pmsg((CommandSender)player, (String)Language.parse((Language.MSG)Language.MSG.MODULE_ARENABOARDS_SORTINGBY, (String)ab.sortBy.toString()));
                return true;
            }
        } else {
            debug.i("not global!", (CommandSender)player);
            if (event.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) {
                ab.sortBy = StatisticsManager.type.next((StatisticsManager.type)ab.sortBy);
                ab.abm.getArena().msg((CommandSender)player, Language.parse((Language.MSG)Language.MSG.MODULE_ARENABOARDS_SORTINGBY, (String)ab.sortBy.toString()));
                return true;
            }
            if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
                ab.sortBy = StatisticsManager.type.last((StatisticsManager.type)ab.sortBy);
                ab.abm.getArena().msg((CommandSender)player, Language.parse((Language.MSG)Language.MSG.MODULE_ARENABOARDS_SORTINGBY, (String)ab.sortBy.toString()));
                return true;
            }
        }
        return false;
    }

    public void destroy() {
        if (this.global) {
            PVPArena.instance.getConfig().set("leaderboard", null);
            PVPArena.instance.saveConfig();
        } else {
            this.abm.getArena().getArenaConfig().setManually("spawns.leaderboard", null);
            this.abm.getArena().getArenaConfig().save();
        }
    }
}

