/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.arenaboards;

import java.util.HashMap;
import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.classes.PABlockLocation;
import net.slipcor.pvparena.core.Config;
import net.slipcor.pvparena.core.Language;
import net.slipcor.pvparena.loadables.ArenaModule;
import net.slipcor.pvparena.managers.ArenaManager;
import net.slipcor.pvparena.managers.SpawnManager;
import net.slipcor.pvparena.modules.arenaboards.ArenaBoard;
import net.slipcor.pvparena.modules.arenaboards.BoardRunnable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class ArenaBoardManager
extends ArenaModule
implements Listener {
    protected HashMap<PABlockLocation, ArenaBoard> boards = new HashMap();
    protected int BOARD_ID = -1;
    protected int GLOBAL_ID = -1;
    protected static ArenaBoard globalBoard = null;
    protected int THIS_ID = -1;

    public ArenaBoardManager() {
        super("ArenaBoards");
    }

    public String version() {
        return "v1.0.1.60";
    }

    public void configParse(YamlConfiguration config) {
        String leaderboard;
        if (config.get("spawns") != null) {
            debug.i("checking for leaderboard");
            if (config.get("spawns.leaderboard") != null) {
                debug.i("leaderboard exists");
                PABlockLocation loc = Config.parseBlockLocation((String)config.getString("spawns.leaderboard"));
                this.boards.put(loc, new ArenaBoard(this, loc, this.arena));
            }
        }
        if ((leaderboard = PVPArena.instance.getConfig().getString("leaderboard")) != null && this.GLOBAL_ID < 0 && globalBoard == null) {
            PABlockLocation lbLoc = Config.parseBlockLocation((String)leaderboard);
            globalBoard = new ArenaBoard(this, lbLoc, null);
            this.GLOBAL_ID = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)PVPArena.instance, (Runnable)new BoardRunnable(null), 100L, 100L);
        }
        this.THIS_ID = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)PVPArena.instance, (Runnable)new BoardRunnable(this), 100L, 100L);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)PVPArena.instance);
    }

    public void onBlockBreak(Block block) {
        if (globalBoard != null && globalBoard.getLocation().equals((Object)block.getLocation())) {
            globalBoard.destroy();
            globalBoard = null;
            Bukkit.getScheduler().cancelTask(this.GLOBAL_ID);
            this.GLOBAL_ID = -1;
        } else if (this.boards.containsKey(block.getLocation())) {
            this.boards.get(block.getLocation()).destroy();
            this.boards.remove(block.getLocation());
        } else {
            return;
        }
        String msg = Language.parse((Language.MSG)Language.MSG.MODULE_ARENABOARDS_DESTROYED);
        for (Entity e : Bukkit.getWorld((String)this.arena.getWorld()).getEntities()) {
            Player player;
            if (!(e instanceof Player) || (player = (Player)e).getLocation().distance(block.getLocation()) > 5.0) continue;
            this.arena.msg((CommandSender)player, msg);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onSignChange(SignChangeEvent event) {
        String headline = event.getLine(0);
        if (headline == null || headline.equals("")) {
            return;
        }
        if (!headline.startsWith("[PAA]")) {
            return;
        }
        Arena a = ArenaManager.getArenaByName((String)(headline = headline.replace("[PAA]", "")));
        if (this.arena == a && this.arena != null && this.boards.containsKey(event.getBlock().getLocation())) {
            Arena.pmsg((CommandSender)event.getPlayer(), (String)Language.parse((Language.MSG)Language.MSG.MODULE_ARENABOARDS_EXISTS));
            return;
        }
        if (!PVPArena.hasAdminPerms((CommandSender)event.getPlayer()) && a != null && !PVPArena.hasCreatePerms((CommandSender)event.getPlayer(), (Arena)a)) {
            a.msg((CommandSender)event.getPlayer(), Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM, (String)Language.parse((Language.MSG)Language.MSG.MODULE_ARENABOARDS_CREATE)));
            return;
        }
        event.setLine(0, headline);
        if (a == null) {
            debug.i("creating global leaderboard", (CommandSender)event.getPlayer());
            globalBoard = new ArenaBoard(this, new PABlockLocation(event.getBlock().getLocation()), null);
            Location loc = event.getBlock().getLocation();
            Integer x = loc.getBlockX();
            Integer y = loc.getBlockY();
            Integer z = loc.getBlockZ();
            Float yaw = Float.valueOf(loc.getYaw());
            Float pitch = Float.valueOf(loc.getPitch());
            String s = String.valueOf(loc.getWorld().getName()) + "," + x.toString() + "," + y.toString() + "," + z.toString() + "," + yaw.toString() + "," + pitch.toString();
            PVPArena.instance.getConfig().set("leaderboard", (Object)s);
            PVPArena.instance.saveConfig();
            this.GLOBAL_ID = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)PVPArena.instance, (Runnable)new BoardRunnable(null), 100L, 100L);
        } else {
            PABlockLocation loc = new PABlockLocation(event.getBlock().getLocation());
            this.boards.put(loc, new ArenaBoard(this, loc, a));
            SpawnManager.setBlock((Arena)a, (PABlockLocation)new PABlockLocation(event.getBlock().getLocation()), (String)"leaderboard");
        }
    }

    public boolean onPlayerInteract(PlayerInteractEvent event) {
        return ArenaBoard.checkInteract(this, event);
    }

    public void reset(boolean force) {
        if (this.BOARD_ID > -1) {
            Bukkit.getScheduler().cancelTask(this.BOARD_ID);
        }
        this.BOARD_ID = -1;
    }

    public void parseStart() {
        if (this.BOARD_ID == -1) {
            this.BOARD_ID = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)PVPArena.instance, (Runnable)new BoardRunnable(this), 100L, 100L);
        }
    }
}

