/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.announcements;

import java.util.Set;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.core.Config;
import net.slipcor.pvparena.core.Debug;
import net.slipcor.pvparena.loadables.ArenaRegionShape;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Announcement {
    private static Debug debug = new Debug(7);

    protected static void announce(Arena a, type t, String message) {
        if (!Announcement.sendCheck(a, t)) {
            return;
        }
        debug.i("announce [" + a.getName() + "] type: " + t.name() + " : " + message);
        Player[] playerArray = Bukkit.getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            if (!a.hasPlayer(p)) {
                Announcement.send(a, p, message.replace(ChatColor.WHITE.toString(), ChatColor.valueOf((String)a.getArenaConfig().getString(Config.CFG.MODULES_ANNOUNCEMENTS_COLOR)).toString()));
            }
            ++n2;
        }
    }

    protected static void announce(Arena a, String sType, String message) {
        type t = type.valueOf(sType);
        debug.i("announce?");
        if (!Announcement.sendCheck(a, t)) {
            return;
        }
        debug.i("announce [" + a.getName() + "] type: " + t.name() + " : " + message);
        Bukkit.getServer().getWorld(a.getWorld()).getPlayers();
        message = message.replace(ChatColor.WHITE.toString(), ChatColor.valueOf((String)a.getArenaConfig().getString(Config.CFG.MODULES_ANNOUNCEMENTS_COLOR)).toString());
        Player[] playerArray = Bukkit.getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            if (!a.hasPlayer(p)) {
                Announcement.send(a, p, message);
            }
            ++n2;
        }
    }

    private static boolean sendCheck(Arena a, type t) {
        Config.CFG cfg = Config.CFG.valueOf((String)("MODULES_ANNOUNCEMENTS_" + t.name()));
        return a.getArenaConfig().getBoolean(cfg);
    }

    private static void send(Arena a, Player p, String message) {
        if (a.getArenaConfig().getInt(Config.CFG.MODULES_ANNOUNCEMENTS_RADIUS) > 0) {
            Set bfs = a.getRegionsByType(ArenaRegionShape.RegionType.BATTLE);
            for (ArenaRegionShape ars : bfs) {
                if (!ars.tooFarAway(a.getArenaConfig().getInt(Config.CFG.MODULES_ANNOUNCEMENTS_RADIUS), p.getLocation())) continue;
                return;
            }
        }
        a.msg((CommandSender)p, "\u00a7f[\u00a7a" + a.getName() + "\u00a7f] " + ChatColor.valueOf((String)a.getArenaConfig().getString(Config.CFG.MODULES_ANNOUNCEMENTS_COLOR)) + message);
    }

    public static enum type {
        JOIN,
        ADVERT,
        START,
        END,
        WINNER,
        LOSER,
        PRIZE,
        CUSTOM;

    }
}

