/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.goals.pillars;

import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.ArenaPlayer;
import net.slipcor.pvparena.arena.ArenaTeam;
import net.slipcor.pvparena.classes.PABlockLocation;
import net.slipcor.pvparena.core.StringParser;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Pillar {
    private final PABlockLocation baseLocation;
    private final int maxHeight;
    private final int maxClicks;
    private final int initialHeight;
    private final ArenaTeam defaultTeam;
    private int clicks = 0;
    private int height = 0;
    private ArenaTeam owner = null;
    private ArenaTeam claiming = null;

    public Pillar(PABlockLocation location, int iHeight, int mHeight, int mClicks, ArenaTeam teamOwner) {
        this.baseLocation = location;
        this.maxHeight = mHeight;
        this.maxClicks = mClicks;
        this.owner = teamOwner;
        this.initialHeight = this.height = iHeight;
        this.defaultTeam = teamOwner;
    }

    public PillarResult blockBreak(ArenaPlayer player) {
        if (player == null || player.get() == null || player.getArenaTeam() == null) {
            PVPArena.instance.getLogger().warning(String.valueOf(player));
            return PillarResult.NONE;
        }
        ArenaTeam claiming = player.getArenaTeam();
        if (claiming.equals(this.owner)) {
            return PillarResult.NONE;
        }
        return this.decreaseHeight(true);
    }

    public PillarResult blockClick(ArenaPlayer player) {
        if (player == null || player.get() == null || player.getArenaTeam() == null) {
            PVPArena.instance.getLogger().warning(String.valueOf(player));
            return PillarResult.NONE;
        }
        ArenaTeam playerTeam = player.getArenaTeam();
        if (!playerTeam.equals(this.claiming)) {
            this.clicks = 0;
        }
        this.claiming = playerTeam;
        if (this.maxClicks < 1 || ++this.clicks < this.maxClicks) {
            return PillarResult.NONE;
        }
        if (this.height >= this.maxHeight && this.claiming.equals(this.owner)) {
            return PillarResult.NONE;
        }
        this.clicks = 0;
        if (this.owner == null) {
            this.owner = this.claiming;
            this.baseLocation.toLocation().getBlock().setTypeIdAndData(Material.WOOL.getId(), StringParser.getColorDataFromENUM((String)this.claiming.getColor().name()), true);
            return PillarResult.CLAIMED;
        }
        return this.claiming.equals(this.owner) ? this.increaseHeight(false) : this.decreaseHeight(false);
    }

    public PillarResult blockPlace(ArenaPlayer player) {
        if (this.maxClicks > 0) {
            return this.blockClick(player);
        }
        if (player == null || player.get() == null || player.getArenaTeam() == null) {
            PVPArena.instance.getLogger().warning(String.valueOf(player));
            return PillarResult.NONE;
        }
        ArenaTeam playerTeam = player.getArenaTeam();
        if (this.owner != null && !playerTeam.equals(this.owner)) {
            return PillarResult.NONE;
        }
        if (this.owner == null) {
            this.owner = this.claiming;
            this.baseLocation.toLocation().getBlock().setTypeIdAndData(Material.WOOL.getId(), StringParser.getColorDataFromENUM((String)this.claiming.getColor().name()), true);
            this.height = 1;
            return PillarResult.CLAIMED;
        }
        PillarResult result = this.increaseHeight(true);
        if (result == PillarResult.BLOCK_PLACED) {
            class RunLater
            implements Runnable {
                private final Player player;

                RunLater(Player player) {
                    this.player = player;
                }

                @Override
                public void run() {
                    ItemStack removal = this.player.getItemInHand().clone();
                    removal.setAmount(1);
                    this.player.getInventory().remove(removal);
                    this.player.updateInventory();
                }
            }
            Bukkit.getScheduler().runTaskLater((Plugin)PVPArena.instance, (Runnable)new RunLater(player.get()), 5L);
        }
        return result;
    }

    public boolean containsLocation(PABlockLocation location) {
        PABlockLocation loc = new PABlockLocation(this.baseLocation.toLocation());
        int pos = 0;
        while (pos < this.maxHeight) {
            loc.setY(this.baseLocation.getY() + pos);
            if (loc.equals((Object)location)) {
                return true;
            }
            ++pos;
        }
        return false;
    }

    private PillarResult decreaseHeight(boolean breaking) {
        --this.height;
        Block removing = this.baseLocation.toLocation().getBlock().getRelative(BlockFace.UP, this.height);
        removing.setType(Material.AIR);
        if (this.height < 1) {
            removing = this.baseLocation.toLocation().getBlock().getRelative(BlockFace.UP, this.height);
            this.owner = null;
            this.height = 1;
            if (breaking) {
                removing.breakNaturally();
                class RunLater
                implements Runnable {
                    RunLater() {
                    }

                    @Override
                    public void run() {
                        Pillar.this.baseLocation.toLocation().getBlock().setTypeIdAndData(Material.WOOL.getId(), (byte)0, true);
                    }
                }
                Bukkit.getScheduler().runTaskLater((Plugin)PVPArena.instance, (Runnable)new RunLater(), 1L);
                return PillarResult.BLOCK_BROKEN;
            }
            removing.setTypeIdAndData(Material.WOOL.getId(), StringParser.getColorDataFromENUM((String)"WHITE"), true);
            return PillarResult.UNCLAIMED;
        }
        class RunLater
        implements Runnable {
            RunLater() {
            }

            @Override
            public void run() {
                Pillar.this.baseLocation.toLocation().getBlock().setTypeIdAndData(Material.WOOL.getId(), StringParser.getColorDataFromENUM((String)Pillar.this.owner.getColor().name()), true);
            }
        }
        Bukkit.getScheduler().runTaskLater((Plugin)PVPArena.instance, (Runnable)new RunLater(), 1L);
        return PillarResult.LOWER;
    }

    public double getClaimStatus() {
        double sum = 0.0;
        double oneBlock = this.maxHeight > 0 ? 1.0 / (double)this.maxHeight : 1.0;
        return sum += this.maxHeight > 0 ? (double)this.height * oneBlock : 1.0;
    }

    public ArenaTeam getDefaultTeam() {
        return this.defaultTeam;
    }

    public PABlockLocation getLocation() {
        return this.baseLocation;
    }

    public ArenaTeam getOwner() {
        return this.owner;
    }

    private PillarResult increaseHeight(boolean place) {
        if (this.height >= this.maxHeight) {
            return PillarResult.NONE;
        }
        Block newBlock = this.baseLocation.toLocation().getBlock().getRelative(BlockFace.UP, this.height);
        class RunLater
        implements Runnable {
            private final /* synthetic */ Block val$newBlock;

            RunLater(Block block) {
                this.val$newBlock = block;
            }

            @Override
            public void run() {
                this.val$newBlock.setTypeIdAndData(Material.WOOL.getId(), StringParser.getColorDataFromENUM((String)Pillar.this.claiming.getColor().name()), true);
            }
        }
        Bukkit.getScheduler().runTaskLater((Plugin)PVPArena.instance, (Runnable)new RunLater(newBlock), 5L);
        ++this.height;
        return place ? PillarResult.BLOCK_PLACED : PillarResult.HIGHER;
    }

    public void reset() {
        this.owner = this.defaultTeam;
        this.height = this.owner == null ? 1 : this.initialHeight;
        Location loc = this.baseLocation.toLocation();
        int pos = 0;
        String color = this.owner == null ? "WHITE" : this.owner.getColor().name();
        byte bColor = StringParser.getColorDataFromENUM((String)color);
        while (pos < this.maxHeight) {
            if (pos < this.height) {
                loc.getBlock().getRelative(BlockFace.UP, pos).setTypeIdAndData(Material.WOOL.getId(), bColor, false);
            } else {
                loc.getBlock().getRelative(BlockFace.UP, pos).setType(Material.AIR);
            }
            ++pos;
        }
    }

    protected static enum PillarResult {
        NONE,
        BLOCK_BROKEN,
        BLOCK_PLACED,
        LOWER,
        HIGHER,
        CLAIMED,
        UNCLAIMED;

    }
}

