/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.bettergears;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.arena.ArenaClass;
import net.slipcor.pvparena.arena.ArenaPlayer;
import net.slipcor.pvparena.arena.ArenaTeam;
import net.slipcor.pvparena.commands.AbstractArenaCommand;
import net.slipcor.pvparena.core.Config;
import net.slipcor.pvparena.core.Debug;
import net.slipcor.pvparena.core.Language;
import net.slipcor.pvparena.core.StringParser;
import net.slipcor.pvparena.loadables.ArenaModule;
import net.slipcor.pvparena.modules.bettergears.EquipRunnable;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public class BetterGears
extends ArenaModule {
    static HashMap<String, String> defaultColors;
    Debug debug = new Debug(401);
    private Map<ArenaTeam, Short[]> colorMap = null;
    private Map<ArenaClass, Short> levelMap = null;

    public BetterGears() {
        super("BetterGears");
    }

    public String version() {
        return "v1.0.1.59";
    }

    public boolean checkCommand(String s) {
        return s.equals("!bg") || s.startsWith("bettergear");
    }

    public void commitCommand(CommandSender sender, String[] args) {
        if (!PVPArena.hasAdminPerms((CommandSender)sender) && !PVPArena.hasCreatePerms((CommandSender)sender, (Arena)this.arena)) {
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM, (String)Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM_X_ADMIN)));
            return;
        }
        if (!AbstractArenaCommand.argCountValid((CommandSender)sender, (Arena)this.arena, (String[])args, (Integer[])new Integer[]{2, 4, 6})) {
            return;
        }
        ArenaClass c = this.arena.getClass(args[1]);
        if (c == null) {
            ArenaTeam team = this.arena.getTeam(args[1]);
            if (team != null) {
                if (args.length == 2) {
                    this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.MODULE_BETTERGEARS_SHOWTEAM, (String)team.getColoredName(), (String)String.valueOf(this.getLevelMap().get(team))));
                    return;
                }
                if (args.length != 6 || !args[2].equalsIgnoreCase("color")) {
                    this.printHelp(sender);
                    return;
                }
                try {
                    Object[] rgb = new Short[]{Short.parseShort(args[3]), Short.parseShort(args[4]), Short.parseShort(args[5])};
                    this.arena.getArenaConfig().setManually("modules.bettergears.colors." + team.getName(), (Object)StringParser.joinArray((Object[])rgb, (String)","));
                    this.arena.getArenaConfig().save();
                    this.getColorMap().put(team, (Short[])rgb);
                    this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.MODULE_BETTERGEARS_TEAMDONE, (String)team.getColoredName(), (String)args[3]));
                }
                catch (Exception e) {
                    this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_NOT_NUMERIC, (String)args[3]));
                }
                return;
            }
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_CLASS_NOT_FOUND, (String)args[1]));
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_TEAMNOTFOUND, (String)args[1]));
            this.printHelp(sender);
            return;
        }
        if (args.length == 2) {
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.MODULE_BETTERGEARS_SHOWCLASS, (String)c.getName(), (String)String.valueOf(this.getLevelMap().get(c))));
            return;
        }
        if (args.length != 4 || !args[2].equalsIgnoreCase("level")) {
            this.printHelp(sender);
            return;
        }
        try {
            short l = Short.parseShort(args[3]);
            this.arena.getArenaConfig().setManually("modules.bettergears.levels." + c.getName(), (Object)l);
            this.arena.getArenaConfig().save();
            this.getLevelMap().put(c, l);
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.MODULE_BETTERGEARS_CLASSDONE, (String)c.getName(), (String)args[3]));
        }
        catch (Exception e) {
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_NOT_NUMERIC, (String)args[3]));
        }
    }

    public void configParse(YamlConfiguration cfg) {
        for (ArenaClass c : this.arena.getClasses()) {
            if (cfg.get("modules.bettergears.levels." + c.getName()) != null) continue;
            cfg.set("modules.bettergears.levels." + c.getName(), (Object)this.parseClassNameToDefaultProtection(c.getName()));
        }
        for (ArenaTeam t : this.arena.getTeams()) {
            if (cfg.get("modules.bettergears.colors." + t.getName()) != null) continue;
            cfg.set("modules.bettergears.colors." + t.getName(), (Object)this.parseTeamColorStringToRGB(t.getColor().name()));
        }
        if (this.getColorMap().isEmpty()) {
            this.setup();
        }
    }

    public void displayInfo(CommandSender sender) {
        for (ArenaTeam team : this.colorMap.keySet()) {
            Object[] colors = this.colorMap.get(team);
            sender.sendMessage(String.valueOf(team.getName()) + ": " + StringParser.joinArray((Object[])colors, (String)""));
        }
        for (ArenaClass aClass : this.levelMap.keySet()) {
            sender.sendMessage(String.valueOf(aClass.getName()) + ": " + this.levelMap.get(aClass));
        }
    }

    void equip(ArenaPlayer ap) {
        short r = 0;
        short g = 0;
        short b = 0;
        if (this.getArena().isFreeForAll()) {
            r = (short)new Random().nextInt(256);
            g = (short)new Random().nextInt(256);
            b = (short)new Random().nextInt(256);
        } else {
            r = this.getColorMap().get(ap.getArenaTeam())[0];
            g = this.getColorMap().get(ap.getArenaTeam())[1];
            b = this.getColorMap().get(ap.getArenaTeam())[2];
        }
        ItemStack[] isArmor = new ItemStack[]{new ItemStack(Material.LEATHER_HELMET, 1), new ItemStack(Material.LEATHER_CHESTPLATE, 1), new ItemStack(Material.LEATHER_LEGGINGS, 1), new ItemStack(Material.LEATHER_BOOTS, 1)};
        Color c = Color.fromBGR((int)b, (int)g, (int)r);
        int i = 0;
        while (i < 4) {
            LeatherArmorMeta lam = (LeatherArmorMeta)isArmor[i].getItemMeta();
            lam.setColor(c);
            isArmor[i].setItemMeta((ItemMeta)lam);
            ++i;
        }
        Short s = this.getLevelMap().get(ap.getArenaClass());
        if (s == null) {
            String autoClass = this.getArena().getArenaConfig().getString(Config.CFG.READY_AUTOCLASS);
            ArenaClass ac = this.getArena().getClass(autoClass);
            s = this.getLevelMap().get(ac);
        }
        isArmor[0].addUnsafeEnchantment(Enchantment.PROTECTION_ENVIRONMENTAL, (int)s.shortValue());
        isArmor[0].addUnsafeEnchantment(Enchantment.PROTECTION_EXPLOSIONS, (int)s.shortValue());
        isArmor[0].addUnsafeEnchantment(Enchantment.PROTECTION_FALL, (int)s.shortValue());
        isArmor[0].addUnsafeEnchantment(Enchantment.PROTECTION_FIRE, (int)s.shortValue());
        isArmor[0].addUnsafeEnchantment(Enchantment.PROTECTION_PROJECTILE, (int)s.shortValue());
        ap.get().getInventory().setHelmet(isArmor[0]);
        ap.get().getInventory().setChestplate(isArmor[1]);
        ap.get().getInventory().setLeggings(isArmor[2]);
        ap.get().getInventory().setBoots(isArmor[3]);
    }

    private Map<ArenaTeam, Short[]> getColorMap() {
        if (this.colorMap == null) {
            this.colorMap = new HashMap<ArenaTeam, Short[]>();
        }
        return this.colorMap;
    }

    private Map<ArenaClass, Short> getLevelMap() {
        if (this.levelMap == null) {
            this.levelMap = new HashMap<ArenaClass, Short>();
        }
        return this.levelMap;
    }

    public void initiate(Player player) {
        if (this.getColorMap().isEmpty()) {
            this.setup();
        }
    }

    public void reset(boolean force) {
        this.getColorMap().remove(this.arena);
        this.getLevelMap().remove(this.arena);
    }

    public void parseStart() {
        if (this.getColorMap().isEmpty()) {
            this.setup();
        }
        for (ArenaPlayer ap : this.arena.getFighters()) {
            this.equip(ap);
        }
    }

    private Short parseClassNameToDefaultProtection(String name) {
        if (name.equals("Tank")) {
            return (short)10;
        }
        if (name.equals("Swordsman")) {
            return (short)4;
        }
        if (name.equals("Ranger")) {
            return (short)1;
        }
        if (name.equals("Pyro")) {
            return (short)1;
        }
        return null;
    }

    public void parseRespawn(Player player, ArenaTeam team, EntityDamageEvent.DamageCause cause, Entity damager) {
        ArenaPlayer ap = ArenaPlayer.parsePlayer((String)player.getName());
        if (this.arena.getArenaConfig().getBoolean(Config.CFG.PLAYER_REFILLINVENTORY)) {
            new EquipRunnable(ap, this);
        }
    }

    private Short[] parseRGBToShortArray(Object o) {
        Short[] result = new Short[]{(short)255, (short)255, (short)255};
        this.debug.i("parsing RGB:");
        this.debug.i(String.valueOf(o));
        if (!(o instanceof String)) {
            return result;
        }
        String s = (String)o;
        if (s == null || s.equals("") || !s.contains(",") || s.split(",").length < 3) {
            return result;
        }
        try {
            String[] split = s.split(",");
            result[0] = Short.parseShort(split[0]);
            result[1] = Short.parseShort(split[1]);
            result[2] = Short.parseShort(split[2]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private String parseTeamColorStringToRGB(String name) {
        if (defaultColors == null) {
            defaultColors = new HashMap();
            defaultColors.put("BLACK", "0,0,0");
            defaultColors.put("DARK_BLUE", "0,0,153");
            defaultColors.put("DARK_GREEN", "0,68,0");
            defaultColors.put("DARK_AQUA", "0,153,153");
            defaultColors.put("DARK_RED", "153,0,0");
            defaultColors.put("DARK_PURPLE", "153,0,153");
            defaultColors.put("GOLD", "0,0,0");
            defaultColors.put("GRAY", "153,153,153");
            defaultColors.put("DARK_GRAY", "68,68,68");
            defaultColors.put("BLUE", "0,0,255");
            defaultColors.put("GREEN", "0,255,0");
            defaultColors.put("AQUA", "0,255,255");
            defaultColors.put("RED", "255,0,0");
            defaultColors.put("LIGHT_PURPLE", "255,0,255");
            defaultColors.put("PINK", "255,0,255");
            defaultColors.put("YELLOW", "255,255,0");
            defaultColors.put("WHITE", "255,255,255");
        }
        String s = defaultColors.get(name);
        this.debug.i("team " + name + " : " + s);
        return s == null ? "255,255,255" : s;
    }

    private void printHelp(CommandSender sender) {
        this.arena.msg(sender, "/pa [arenaname] !bg [teamname]  | show team color");
        this.arena.msg(sender, "/pa [arenaname] !bg [teamname] color \u00a7c<R> \u00a7a<G> \u00a79<B>\u00a7r | set color");
        this.arena.msg(sender, "/pa [arenaname] !bg [classname] | show protection level");
        this.arena.msg(sender, "/pa [arenaname] !bg [classname] level <level> | set protection level");
    }

    private void setup() {
        Object[] s;
        this.debug.i("Setting up BetterGears");
        for (ArenaClass c : this.arena.getClasses()) {
            s = Short.valueOf((short)0);
            try {
                s = Short.valueOf(String.valueOf(this.arena.getArenaConfig().getUnsafe("modules.bettergears.levels." + c.getName())));
                this.debug.i(String.valueOf(c.getName()) + " : " + s);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.getLevelMap().put(c, (Short)s);
        }
        for (ArenaTeam t : this.arena.getTeams()) {
            s = this.parseRGBToShortArray(this.arena.getArenaConfig().getUnsafe("modules.bettergears.colors." + t.getName()));
            this.getColorMap().put(t, (Short[])s);
            this.debug.i(String.valueOf(t.getName()) + " : " + StringParser.joinArray((Object[])s, (String)","));
        }
    }
}

