/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.worldedit;

import com.sk89q.worldedit.CuboidClipboard;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.selections.CuboidSelection;
import com.sk89q.worldedit.bukkit.selections.Selection;
import com.sk89q.worldedit.data.DataException;
import com.sk89q.worldedit.schematic.SchematicFormat;
import java.io.File;
import java.io.IOException;
import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.arena.ArenaPlayer;
import net.slipcor.pvparena.classes.PABlockLocation;
import net.slipcor.pvparena.commands.PAA_Region;
import net.slipcor.pvparena.core.Config;
import net.slipcor.pvparena.core.Language;
import net.slipcor.pvparena.core.StringParser;
import net.slipcor.pvparena.loadables.ArenaModule;
import net.slipcor.pvparena.loadables.ArenaRegionShape;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PAWE
extends ArenaModule {
    private static WorldEditPlugin worldEdit;

    public PAWE() {
        super("WorldEdit");
    }

    public String version() {
        return "v1.0.1.59";
    }

    public boolean checkCommand(String s) {
        return s.equals("regload") || s.equals("regsave") || s.equals("regcreate") || s.equals("!we") || s.equals("worldedit");
    }

    public void commitCommand(CommandSender sender, String[] args) {
        if (!sender.hasPermission("pvparena.admin")) {
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM, (String)Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM_X_ADMIN)));
            return;
        }
        if (args.length < 2) {
            this.helpCommands(this.arena, sender);
            return;
        }
        ArenaRegionShape ars = this.arena.getRegion(args[1]);
        if (args.length < 3) {
            if (args[0].endsWith("load")) {
                this.load(ars);
                this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.MODULE_WORLDEDIT_LOADED, (String)args[1]));
                return;
            }
            if (args[0].endsWith("save")) {
                this.save(ars);
                this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.MODULE_WORLDEDIT_SAVED, (String)args[1]));
                return;
            }
            if (args[0].endsWith("create")) {
                this.create((Player)sender, this.arena, args[1]);
                this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.MODULE_WORLDEDIT_CREATED, (String)args[1]));
                return;
            }
            if (args[0].equals("!we") || args[0].equals("!we")) {
                if (args[1].endsWith("save")) {
                    boolean b = this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_WORLDEDIT_AUTOSAVE);
                    this.arena.getArenaConfig().set(Config.CFG.MODULES_WORLDEDIT_AUTOSAVE, (Object)(!b ? 1 : 0));
                    this.arena.getArenaConfig().save();
                    this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.SET_DONE, (String)Config.CFG.MODULES_WORLDEDIT_AUTOSAVE.getNode(), (String)String.valueOf(!b)));
                    return;
                }
                if (args[1].endsWith("load")) {
                    boolean b = this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_WORLDEDIT_AUTOLOAD);
                    this.arena.getArenaConfig().set(Config.CFG.MODULES_WORLDEDIT_AUTOLOAD, (Object)(!b ? 1 : 0));
                    this.arena.getArenaConfig().save();
                    this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.SET_DONE, (String)Config.CFG.MODULES_WORLDEDIT_AUTOLOAD.getNode(), (String)String.valueOf(!b)));
                    return;
                }
                this.create((Player)sender, this.arena, args[1]);
                this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.MODULE_WORLDEDIT_CREATED, (String)args[1]));
                return;
            }
            this.helpCommands(this.arena, sender);
        } else if (args[0].endsWith("load")) {
            this.load(ars, args[2]);
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.MODULE_WORLDEDIT_LOADED, (String)args[1]));
        } else if (args[0].endsWith("save")) {
            this.save(ars, args[2]);
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.MODULE_WORLDEDIT_SAVED, (String)args[1]));
        } else {
            this.create((Player)sender, this.arena, args[1], args[2]);
        }
    }

    private void create(Player p, Arena arena, String regionName, String regionShape) {
        Selection s = worldEdit.getSelection(p);
        if (s == null) {
            Arena.pmsg((CommandSender)p, (String)Language.parse((Language.MSG)Language.MSG.ERROR_REGION_SELECT_2));
            return;
        }
        ArenaPlayer ap = ArenaPlayer.parsePlayer((String)p.getName());
        ap.setSelection(s.getMinimumPoint(), false);
        ap.setSelection(s.getMaximumPoint(), true);
        PAA_Region cmd = new PAA_Region();
        String[] args = new String[]{regionName, regionShape};
        cmd.commit(arena, (CommandSender)p, args);
    }

    private void create(Player p, Arena arena, String regionName) {
        this.create(p, arena, regionName, "CUBOID");
    }

    public void displayInfo(CommandSender sender) {
        sender.sendMessage(String.valueOf(StringParser.colorVar((String)"autoload", (boolean)this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_WORLDEDIT_AUTOLOAD))) + " | " + StringParser.colorVar((String)"autosave", (boolean)this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_WORLDEDIT_AUTOSAVE)));
    }

    private void helpCommands(Arena arena, CommandSender sender) {
        arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_ERROR, (String)"/pa regsave [regionname] {filename}"));
        arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_ERROR, (String)"/pa regload [regionname] {filename}"));
        arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_ERROR, (String)"/pa regcreate [regionname]"));
        arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_ERROR, (String)"/pa !we autoload"));
        arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_ERROR, (String)"/pa !we autosave"));
        arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_ERROR, (String)"/pa !we create"));
    }

    public void load(ArenaRegionShape ars) {
        this.load(ars, String.valueOf(ars.getArena().getName()) + "_" + ars.getRegionName());
    }

    public void load(ArenaRegionShape ars, String regionName) {
        try {
            CuboidClipboard cc = SchematicFormat.MCEDIT.load(new File(PVPArena.instance.getDataFolder(), String.valueOf(regionName) + ".schematic"));
            PABlockLocation min = ars.getMinimumLocation();
            PABlockLocation max = ars.getMaximumLocation();
            int size = (max.getX() + 2 - min.getX()) * (max.getY() + 2 - min.getY()) * (max.getZ() + 2 - min.getZ());
            EditSession es = new EditSession((LocalWorld)new BukkitWorld(Bukkit.getWorld((String)ars.getWorldName())), size);
            PABlockLocation loc = ars.getMinimumLocation();
            cc.place(es, new Vector(loc.getX() - 1, loc.getY() - 1, loc.getZ() - 1), false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DataException e) {
            e.printStackTrace();
        }
        catch (MaxChangedBlocksException e) {
            e.printStackTrace();
        }
    }

    public void onThisLoad() {
        Plugin pwep = Bukkit.getPluginManager().getPlugin("WorldEdit");
        if (pwep != null && pwep.isEnabled() && pwep instanceof WorldEditPlugin) {
            worldEdit = (WorldEditPlugin)pwep;
        }
    }

    public void parseStart() {
        if (this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_WORLDEDIT_AUTOSAVE)) {
            for (ArenaRegionShape ars : this.arena.getRegionsByType(ArenaRegionShape.RegionType.BATTLE)) {
                this.save(ars);
            }
        }
    }

    public void reset(boolean force) {
        if (this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_WORLDEDIT_AUTOLOAD)) {
            for (ArenaRegionShape ars : this.arena.getRegionsByType(ArenaRegionShape.RegionType.BATTLE)) {
                this.load(ars);
            }
        }
    }

    public void save(ArenaRegionShape ars) {
        this.save(ars, String.valueOf(ars.getArena().getName()) + "_" + ars.getRegionName());
    }

    public void save(ArenaRegionShape ars, String regionName) {
        CuboidSelection cs = new CuboidSelection(Bukkit.getWorld((String)ars.getWorldName()), ars.getMinimumLocation().toLocation(), ars.getMaximumLocation().toLocation());
        Vector min = cs.getNativeMinimumPoint();
        Vector max = cs.getNativeMaximumPoint();
        min = min.subtract(1, 1, 1);
        max = max.add(1, 1, 1);
        PABlockLocation lmin = ars.getMinimumLocation();
        PABlockLocation lmax = ars.getMaximumLocation();
        int size = (lmax.getX() - lmin.getX()) * (lmax.getY() - lmin.getY()) * (lmax.getZ() - lmin.getZ());
        CuboidClipboard cc = new CuboidClipboard(max.subtract(min), min);
        EditSession es = new EditSession((LocalWorld)new BukkitWorld(Bukkit.getWorld((String)ars.getWorldName())), size);
        cc.copy(es);
        try {
            SchematicFormat.MCEDIT.save(cc, new File(PVPArena.instance.getDataFolder(), String.valueOf(regionName) + ".schematic"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DataException e) {
            e.printStackTrace();
        }
    }
}

