/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.blockrestore;

import java.util.HashMap;
import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.commands.PAA_Edit;
import net.slipcor.pvparena.core.Config;
import net.slipcor.pvparena.core.Debug;
import net.slipcor.pvparena.core.StringParser;
import net.slipcor.pvparena.modules.blockrestore.Blocks;
import net.slipcor.pvparena.modules.blockrestore.RestoreContainer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.block.Dispenser;
import org.bukkit.block.Furnace;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class RestoreRunner
implements Runnable {
    HashMap<Location, ItemStack[]> chests;
    HashMap<Location, ItemStack[]> furnaces;
    HashMap<Location, ItemStack[]> dispensers;
    protected final Blocks blocks;
    private Debug debug = new Debug(66);

    public RestoreRunner(Blocks blocks, HashMap<Location, ItemStack[]> chests, HashMap<Location, ItemStack[]> furnaces, HashMap<Location, ItemStack[]> dispensers) {
        this.debug.i("RestoreRunner contructor: " + blocks.getArena().getName());
        this.blocks = blocks;
        this.chests = chests;
        this.furnaces = furnaces;
        this.dispensers = dispensers;
        if (chests != null) {
            this.debug.i("chests: " + chests.size());
        }
        if (furnaces != null) {
            this.debug.i("furnaces: " + furnaces.size());
        }
        if (dispensers != null) {
            this.debug.i("dispensers: " + dispensers.size());
        }
    }

    @Override
    public void run() {
        PAA_Edit.activeEdits.put("server", this.blocks.getArena());
        World world = Bukkit.getWorld((String)this.blocks.getArena().getWorld());
        for (Location loc : this.chests.keySet()) {
            if (loc == null) break;
            try {
                this.debug.i("trying to restore chest: " + loc.toString());
                Block b = world.getBlockAt(loc);
                b.setType(Material.CHEST);
                Inventory inv = ((Chest)b.getState()).getInventory();
                inv.clear();
                int i = 0;
                ItemStack[] itemStackArray = this.chests.get(loc);
                int n = itemStackArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ItemStack is = itemStackArray[n2];
                    this.debug.i("restoring: " + StringParser.getStringFromItemStack((ItemStack)is));
                    inv.setItem(i++, is);
                    ++n2;
                }
                this.debug.i("success!");
                this.chests.remove(loc);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)PVPArena.instance, (Runnable)this, (long)this.blocks.getArena().getArenaConfig().getInt(Config.CFG.MODULES_BLOCKRESTORE_OFFSET) * 1L);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Location loc : this.dispensers.keySet()) {
            if (loc == null) break;
            try {
                this.debug.i("trying to restore dispenser: " + loc.toString());
                Inventory inv = ((Dispenser)world.getBlockAt(loc).getState()).getInventory();
                inv.clear();
                ItemStack[] itemStackArray = this.dispensers.get(loc);
                int n = itemStackArray.length;
                int n3 = 0;
                while (n3 < n) {
                    ItemStack is = itemStackArray[n3];
                    if (is != null) {
                        inv.addItem(new ItemStack[]{is.clone()});
                    }
                    ++n3;
                }
                this.debug.i("success!");
                this.dispensers.remove(loc);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)PVPArena.instance, (Runnable)this, (long)this.blocks.getArena().getArenaConfig().getInt(Config.CFG.MODULES_BLOCKRESTORE_OFFSET) * 1L);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (Location loc : this.furnaces.keySet()) {
            if (loc == null) break;
            try {
                this.debug.i("trying to restore furnace: " + loc.toString());
                ((Furnace)world.getBlockAt(loc).getState()).getInventory().setContents(RestoreContainer.cloneIS(this.furnaces.get(loc)));
                this.debug.i("success!");
                this.furnaces.remove(loc);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)PVPArena.instance, (Runnable)this, (long)this.blocks.getArena().getArenaConfig().getInt(Config.CFG.MODULES_BLOCKRESTORE_OFFSET) * 1L);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        PAA_Edit.activeEdits.remove("server");
    }
}

