/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.startfreeze;

import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.arena.ArenaPlayer;
import net.slipcor.pvparena.commands.AbstractArenaCommand;
import net.slipcor.pvparena.core.Config;
import net.slipcor.pvparena.core.Language;
import net.slipcor.pvparena.loadables.ArenaModule;
import net.slipcor.pvparena.modules.startfreeze.StartFreezer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class StartFreeze
extends ArenaModule
implements Listener {
    StartFreezer runnable = null;
    private boolean setup = false;

    public StartFreeze() {
        super("StartFreeze");
    }

    public String version() {
        return "v1.0.1.59";
    }

    public boolean checkCommand(String s) {
        return s.equals("startfreeze") || s.equals("!sf");
    }

    public void commitCommand(CommandSender sender, String[] args) {
        if (!PVPArena.hasAdminPerms((CommandSender)sender) && !PVPArena.hasCreatePerms((CommandSender)sender, (Arena)this.arena)) {
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM, (String)Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM_X_ADMIN)));
            return;
        }
        if (!AbstractArenaCommand.argCountValid((CommandSender)sender, (Arena)this.arena, (String[])args, (Integer[])new Integer[]{2})) {
            return;
        }
        if (args[0].equals("!sf") || args[0].equals("startfreeze")) {
            int i = 0;
            try {
                i = Integer.parseInt(args[1]);
            }
            catch (Exception e) {
                this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_NOT_NUMERIC, (String)args[1]));
                return;
            }
            this.arena.getArenaConfig().set(Config.CFG.MODULES_STARTFREEZE_TIMER, (Object)i);
            this.arena.getArenaConfig().save();
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.SET_DONE, (String)Config.CFG.MODULES_STARTFREEZE_TIMER.getNode(), (String)String.valueOf(i)));
        }
    }

    public void displayInfo(CommandSender sender) {
        sender.sendMessage("seconds: " + this.arena.getArenaConfig().getInt(Config.CFG.MODULES_STARTFREEZE_TIMER));
    }

    public void reset(boolean force) {
        if (this.runnable != null) {
            this.runnable.cancel();
        }
        this.runnable = null;
    }

    public void parseStart() {
        this.runnable = new StartFreezer(null);
        this.runnable.runTaskLater((Plugin)PVPArena.instance, (long)this.arena.getArenaConfig().getInt(Config.CFG.MODULES_STARTFREEZE_TIMER) * 20L);
        this.arena.broadcast(Language.parse((Language.MSG)Language.MSG.MODULE_STARTFREEZE_ANNOUNCE, (String)String.valueOf(this.arena.getArenaConfig().getInt(Config.CFG.MODULES_STARTFREEZE_TIMER))));
    }

    public void configParse(YamlConfiguration config) {
        if (!this.setup) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)PVPArena.instance);
            this.setup = true;
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player p = event.getPlayer();
        ArenaPlayer ap = ArenaPlayer.parsePlayer((String)p.getName());
        if (ap.getArena() == null || !this.arena.equals(ap.getArena())) {
            return;
        }
        if (this.runnable != null) {
            Location from = event.getFrom();
            Location to = event.getTo();
            if (from.getBlockX() != to.getBlockX() || from.getBlockY() != to.getBlockY() || from.getBlockZ() != to.getBlockZ()) {
                event.setCancelled(true);
            }
        }
    }
}

