/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.colorteams;

import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.arena.ArenaPlayer;
import net.slipcor.pvparena.arena.ArenaTeam;
import net.slipcor.pvparena.commands.AbstractArenaCommand;
import net.slipcor.pvparena.core.Config;
import net.slipcor.pvparena.core.Language;
import net.slipcor.pvparena.core.StringParser;
import net.slipcor.pvparena.loadables.ArenaModule;
import net.slipcor.pvparena.modules.colorteams.CTListener;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.kitteh.tag.TagAPI;

public class CTManager
extends ArenaModule {
    protected static boolean enabled = false;

    public CTManager() {
        super("ColorTeams");
    }

    public String version() {
        return "v1.0.1.59";
    }

    public boolean checkCommand(String s) {
        return s.equals("!ct") || s.equals("colorteams");
    }

    public void commitCommand(CommandSender sender, String[] args) {
        if (!PVPArena.hasAdminPerms((CommandSender)sender) && !PVPArena.hasCreatePerms((CommandSender)sender, (Arena)this.arena)) {
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM, (String)Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM_X_ADMIN)));
            return;
        }
        if (!AbstractArenaCommand.argCountValid((CommandSender)sender, (Arena)this.arena, (String[])args, (Integer[])new Integer[]{2})) {
            return;
        }
        Config.CFG c = null;
        if (args[1].equals("hidename")) {
            c = Config.CFG.CHAT_COLORNICK;
        }
        if (c == null) {
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_ARGUMENT, (String)args[1], (String)"hidename"));
            return;
        }
        boolean b = this.arena.getArenaConfig().getBoolean(c);
        this.arena.getArenaConfig().set(c, (Object)(!b ? 1 : 0));
        this.arena.getArenaConfig().save();
        this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.SET_DONE, (String)c.getNode(), (String)String.valueOf(!b)));
    }

    public void displayInfo(CommandSender player) {
        player.sendMessage(String.valueOf(StringParser.colorVar((String)"enabled", (boolean)this.arena.getArenaConfig().getBoolean(Config.CFG.CHAT_COLORNICK))) + " | " + StringParser.colorVar((String)"hidename", (boolean)this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_COLORTEAMS_HIDENAME)));
    }

    public void configParse(YamlConfiguration config) {
        if (enabled) {
            return;
        }
        if (Bukkit.getServer().getPluginManager().getPlugin("TagAPI") != null) {
            Bukkit.getPluginManager().registerEvents((Listener)new CTListener(), (Plugin)PVPArena.instance);
            Arena.pmsg((CommandSender)Bukkit.getConsoleSender(), (String)Language.parse((Language.MSG)Language.MSG.MODULE_COLORTEAMS_TAGAPI));
        }
        enabled = true;
    }

    public void tpPlayerToCoordName(Player player, String place) {
        if (this.arena.getArenaConfig().getBoolean(Config.CFG.CHAT_COLORNICK)) {
            ArenaTeam team = ArenaPlayer.parsePlayer((String)player.getName()).getArenaTeam();
            String n = team == null ? player.getName() : String.valueOf(team.getColorCodeString()) + player.getName();
            n = n.replaceAll("(&([a-f0-9]))", "\u00a7$2");
            player.setDisplayName(n);
            this.updateName(player);
        }
    }

    public void unload(Player player) {
        player.setDisplayName(player.getName());
        if (enabled) {
            class TempRunner
            implements Runnable {
                private final /* synthetic */ Player val$player;

                TempRunner(Player player) {
                    this.val$player = player;
                }

                @Override
                public void run() {
                    try {
                        TagAPI.refreshPlayer((Player)this.val$player);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            Bukkit.getScheduler().runTaskLater((Plugin)PVPArena.instance, (Runnable)new TempRunner(player), 60L);
        }
    }

    public void updateName(Player player) {
        if (enabled) {
            TagAPI.refreshPlayer((Player)player);
        }
    }
}

