/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.aftermatch;

import java.util.Set;
import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.arena.ArenaPlayer;
import net.slipcor.pvparena.arena.ArenaTeam;
import net.slipcor.pvparena.commands.AbstractArenaCommand;
import net.slipcor.pvparena.core.Config;
import net.slipcor.pvparena.core.Language;
import net.slipcor.pvparena.core.StringParser;
import net.slipcor.pvparena.loadables.ArenaModule;
import net.slipcor.pvparena.modules.aftermatch.AfterRunnable;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;

public class AfterMatch
extends ArenaModule
implements Cloneable {
    protected Integer runId = null;
    private boolean aftermatch = false;

    public AfterMatch() {
        super("AfterMatch");
    }

    public String version() {
        return "v1.0.1.59";
    }

    public void afterMatch() {
        for (ArenaTeam t : this.arena.getTeams()) {
            for (ArenaPlayer p : t.getTeamMembers()) {
                if (!p.getStatus().equals((Object)ArenaPlayer.Status.FIGHT)) continue;
                Player player = p.get();
                this.arena.tpPlayerToCoordName(player, "after");
            }
        }
        this.arena.broadcast(Language.parse((Language.MSG)Language.MSG.MODULE_AFTERMATCH_STARTING));
        PVPArena.instance.getAgm().setPlayerLives(this.arena, 0);
        this.aftermatch = true;
    }

    public boolean checkCommand(String s) {
        return s.equals("!am") || s.equals("aftermatch");
    }

    public String checkForMissingSpawns(Set<String> list) {
        for (String s : list) {
            if (!s.startsWith("after")) continue;
            return null;
        }
        return Language.parse((Language.MSG)Language.MSG.MODULE_AFTERMATCH_SPAWNNOTSET);
    }

    public void commitCommand(CommandSender sender, String[] args) {
        if (!PVPArena.hasAdminPerms((CommandSender)sender) && !PVPArena.hasCreatePerms((CommandSender)sender, (Arena)this.arena)) {
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM, (String)Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM_X_ADMIN)));
            return;
        }
        if (!AbstractArenaCommand.argCountValid((CommandSender)sender, (Arena)this.arena, (String[])args, (Integer[])new Integer[]{2, 3})) {
            return;
        }
        if (args[0].equals("!am") || args[0].equals("aftermatch")) {
            if (args.length == 2) {
                if (args[1].equals("off")) {
                    this.arena.getArenaConfig().set(Config.CFG.MODULES_AFTERMATCH_AFTERMATCH, (Object)args[1]);
                    this.arena.getArenaConfig().save();
                    this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.SET_DONE, (String)Config.CFG.MODULES_AFTERMATCH_AFTERMATCH.getNode(), (String)args[1]));
                    return;
                }
                this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_ARGUMENT, (String)args[1], (String)"off"));
                return;
            }
            int i = 0;
            try {
                i = Integer.parseInt(args[2]);
            }
            catch (Exception e) {
                this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_NOT_NUMERIC, (String)args[2]));
                return;
            }
            if (args[1].equals("time") || args[1].equals("death")) {
                this.arena.getArenaConfig().set(Config.CFG.MODULES_AFTERMATCH_AFTERMATCH, (Object)(String.valueOf(args[1]) + ":" + i));
                this.arena.getArenaConfig().save();
                this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.SET_DONE, (String)Config.CFG.MODULES_AFTERMATCH_AFTERMATCH.getNode(), (String)(String.valueOf(args[1]) + ":" + i)));
                return;
            }
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_ARGUMENT, (String)args[1], (String)"time | death"));
            return;
        }
    }

    public void configParse(YamlConfiguration config) {
        String pu = config.getString(Config.CFG.MODULES_AFTERMATCH_AFTERMATCH.getNode(), "off");
        if (!pu.startsWith("death") && !pu.startsWith("time")) {
            PVPArena.instance.getLogger().warning("error activating aftermatch module");
        }
    }

    public void displayInfo(CommandSender player) {
        player.sendMessage("active: " + StringParser.colorVar((!this.arena.getArenaConfig().getString(Config.CFG.MODULES_AFTERMATCH_AFTERMATCH).equals("off") ? 1 : 0) != 0) + "(" + StringParser.colorVar((String)this.arena.getArenaConfig().getString(Config.CFG.MODULES_AFTERMATCH_AFTERMATCH)) + ")");
    }

    public boolean hasSpawn(String string) {
        return string.equals("after");
    }

    public void parsePlayerDeath(Player player, EntityDamageEvent cause) {
        String pu = this.arena.getArenaConfig().getString(Config.CFG.MODULES_AFTERMATCH_AFTERMATCH);
        if (pu.equals("off") || this.aftermatch) {
            return;
        }
        String[] ss = pu.split(":");
        if (pu.startsWith("time") || this.runId != null) {
            return;
        }
        int i = Integer.parseInt(ss[1]);
        for (ArenaTeam t : this.arena.getTeams()) {
            for (ArenaPlayer p : t.getTeamMembers()) {
                if (!p.getStatus().equals((Object)ArenaPlayer.Status.FIGHT) || --i >= 0) continue;
                return;
            }
        }
        this.runId = null;
        this.afterMatch();
    }

    public void reset(boolean force) {
        String pu = this.arena.getArenaConfig().getString(Config.CFG.MODULES_AFTERMATCH_AFTERMATCH);
        if (pu.equals("off")) {
            return;
        }
        if (this.runId != null) {
            Bukkit.getScheduler().cancelTask(this.runId.intValue());
            this.runId = null;
        }
        this.aftermatch = false;
    }

    public void parseStart() {
        String pu = this.arena.getArenaConfig().getString(Config.CFG.MODULES_AFTERMATCH_AFTERMATCH);
        if (this.runId != null) {
            Bukkit.getScheduler().cancelTask(this.runId.intValue());
            this.runId = null;
        }
        int i = 0;
        String[] ss = pu.split(":");
        if (!pu.startsWith("time")) {
            return;
        }
        i = Integer.parseInt(ss[1]);
        debug.i("using aftermatch : " + this.arena.getArenaConfig().getString(Config.CFG.MODULES_AFTERMATCH_AFTERMATCH) + " : " + i);
        if (i > 0) {
            debug.i("aftermatch time trigger!");
            new AfterRunnable(this, i);
        }
    }
}

