/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.vaultsupport;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.milkbowl.vault.economy.Economy;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.arena.ArenaPlayer;
import net.slipcor.pvparena.arena.ArenaTeam;
import net.slipcor.pvparena.classes.PACheck;
import net.slipcor.pvparena.core.Config;
import net.slipcor.pvparena.core.Language;
import net.slipcor.pvparena.core.StringParser;
import net.slipcor.pvparena.loadables.ArenaModule;
import net.slipcor.pvparena.loadables.ArenaModuleManager;
import net.slipcor.pvparena.ncloader.NCBLoadable;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultSupport
extends ArenaModule {
    private static Economy economy = null;
    private HashMap<String, Double> playerBetMap = null;
    private HashMap<String, Double> playerJoinMap = null;
    private double pot = 0.0;

    public VaultSupport() {
        super("Vault");
    }

    public String version() {
        return "v1.0.1.59";
    }

    public boolean checkCommand(String cmd) {
        try {
            double amount = Double.parseDouble(cmd);
            debug.i("parsing join bet amount: " + amount);
            return true;
        }
        catch (Exception e) {
            return cmd.equalsIgnoreCase("bet");
        }
    }

    public PACheck checkJoin(CommandSender sender, PACheck res, boolean join) {
        if (res.hasError() || !join) {
            return res;
        }
        if (this.arena.getArenaConfig().getInt(Config.CFG.MODULES_VAULT_ENTRYFEE) > 0 && economy != null) {
            if (!economy.hasAccount(sender.getName())) {
                debug.i("Account not found: " + sender.getName(), sender);
                res.setError((NCBLoadable)this, "account not found: " + sender.getName());
                return res;
            }
            if (!economy.has(sender.getName(), (double)this.arena.getArenaConfig().getInt(Config.CFG.MODULES_VAULT_ENTRYFEE))) {
                res.setError((NCBLoadable)this, Language.parse((Language.MSG)Language.MSG.MODULE_VAULT_NOTENOUGH, (String)economy.format((double)this.arena.getArenaConfig().getInt(Config.CFG.MODULES_VAULT_ENTRYFEE))));
                return res;
            }
        }
        return res;
    }

    public void commitCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            Language.parse((Language.MSG)Language.MSG.ERROR_ONLY_PLAYERS);
            return;
        }
        Player player = (Player)sender;
        ArenaPlayer ap = ArenaPlayer.parsePlayer((String)player.getName());
        if (ap.getArenaTeam() != null) {
            this.arena.msg((CommandSender)player, Language.parse((Language.MSG)Language.MSG.MODULE_VAULT_BETNOTYOURS));
            return;
        }
        if (economy == null) {
            return;
        }
        if (args[0].equalsIgnoreCase("bet")) {
            Player p = Bukkit.getPlayer((String)args[1]);
            if (p != null) {
                ap = ArenaPlayer.parsePlayer((String)p.getName());
            }
            if (p == null && this.arena.getTeam(args[1]) == null && ap.getArenaTeam() == null) {
                this.arena.msg((CommandSender)player, Language.parse((Language.MSG)Language.MSG.MODULE_VAULT_BETOPTIONS));
                return;
            }
            double amount = 0.0;
            try {
                amount = Double.parseDouble(args[2]);
            }
            catch (Exception e) {
                this.arena.msg((CommandSender)player, Language.parse((Language.MSG)Language.MSG.MODULE_VAULT_INVALIDAMOUNT, (String)args[2]));
                return;
            }
            if (!economy.hasAccount(player.getName())) {
                debug.i("Account not found: " + player.getName(), sender);
                return;
            }
            if (!economy.has(player.getName(), amount)) {
                this.arena.msg((CommandSender)player, Language.parse((Language.MSG)Language.MSG.MODULE_VAULT_NOTENOUGH, (String)economy.format(amount)));
                return;
            }
            if (amount < this.arena.getArenaConfig().getDouble(Config.CFG.MODULES_VAULT_MINIMUMBET) || amount > this.arena.getArenaConfig().getDouble(Config.CFG.MODULES_VAULT_MAXIMUMBET)) {
                this.arena.msg((CommandSender)player, Language.parse((Language.MSG)Language.MSG.ERROR_INVALID_VALUE, (String)economy.format(this.arena.getArenaConfig().getDouble(Config.CFG.MODULES_VAULT_MINIMUMBET)), (String)economy.format(this.arena.getArenaConfig().getDouble(Config.CFG.MODULES_VAULT_MAXIMUMBET))));
                return;
            }
            economy.withdrawPlayer(player.getName(), amount);
            this.arena.msg((CommandSender)player, Language.parse((Language.MSG)Language.MSG.MODULE_VAULT_BETPLACED, (String)args[1]));
            this.getPlayerBetMap().put(String.valueOf(player.getName()) + ":" + args[1], amount);
            return;
        }
        double amount = 0.0;
        try {
            amount = Double.parseDouble(args[0]);
        }
        catch (Exception e) {
            return;
        }
        if (!economy.hasAccount(player.getName())) {
            debug.i("Account not found: " + player.getName(), sender);
            return;
        }
        if (!economy.has(player.getName(), amount)) {
            this.arena.msg((CommandSender)player, Language.parse((Language.MSG)Language.MSG.MODULE_VAULT_NOTENOUGH, (String)economy.format(amount)));
            return;
        }
        PACheck res = new PACheck();
        this.checkJoin(sender, res, true);
        if (res.hasError()) {
            this.arena.msg(sender, res.getError());
            return;
        }
        economy.withdrawPlayer(player.getName(), amount);
        this.arena.msg((CommandSender)player, Language.parse((Language.MSG)Language.MSG.MODULE_VAULT_BETPLACED, (String)args[1]));
        this.getPlayerJoinMap().put(player.getName(), amount);
        this.commitCommand((CommandSender)player, null);
    }

    public boolean commitEnd(ArenaTeam aTeam) {
        if (economy != null) {
            debug.i("eConomy set, parse bets");
            for (String nKey : this.getPlayerBetMap().keySet()) {
                debug.i("bet: " + nKey);
                String[] nSplit = nKey.split(":");
                if (this.arena.getTeam(nSplit[1]) == null || this.arena.getTeam(nSplit[1]).getName().equals("free") || !nSplit[1].equalsIgnoreCase(aTeam.getName())) continue;
                double teamFactor = this.arena.getArenaConfig().getDouble(Config.CFG.MODULES_VAULT_BETWINTEAMFACTOR) * (double)this.arena.getTeamNames().size();
                if (teamFactor <= 0.0) {
                    teamFactor = 1.0;
                }
                double amount = this.getPlayerBetMap().get(nKey) * (teamFactor *= this.arena.getArenaConfig().getDouble(Config.CFG.MODULES_VAULT_BETWINFACTOR));
                if (!economy.hasAccount(nSplit[0])) {
                    debug.i("Account not found: " + nSplit[0]);
                    return true;
                }
                economy.depositPlayer(nSplit[0], amount);
                try {
                    this.arena.msg((CommandSender)Bukkit.getPlayer((String)nSplit[0]), Language.parse((Language.MSG)Language.MSG.MODULE_VAULT_YOUWON, (String)economy.format(amount)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public void onThisLoad() {
        if (economy == null && Bukkit.getServer().getPluginManager().getPlugin("Vault") != null) {
            this.setupEconomy();
        }
    }

    private Map<String, Double> getPlayerBetMap() {
        if (this.playerBetMap == null) {
            this.playerBetMap = new HashMap();
        }
        return this.playerBetMap;
    }

    private Map<String, Double> getPlayerJoinMap() {
        if (this.playerJoinMap == null) {
            this.playerJoinMap = new HashMap();
        }
        return this.playerJoinMap;
    }

    public void giveRewards(Player player) {
        debug.i("giving rewards to player " + player.getName(), (CommandSender)player);
        debug.i("", (CommandSender)player);
        int winners = 0;
        debug.i("giving Vault rewards to Player " + player, (CommandSender)player);
        for (ArenaPlayer p : this.arena.getFighters()) {
            debug.i("- checking fighter " + p.getName(), p.getName());
            if (p.getStatus() == null || !p.getStatus().equals((Object)ArenaPlayer.Status.FIGHT)) continue;
            debug.i("-- added!", p.getName());
            ++winners;
        }
        debug.i("winners: " + winners, (CommandSender)player);
        if (economy != null) {
            debug.i("checking on bet amounts!", (CommandSender)player);
            for (String nKey : this.getPlayerBetMap().keySet()) {
                String[] nSplit = nKey.split(":");
                if (!nSplit[1].equalsIgnoreCase(player.getName())) continue;
                double playerFactor = (double)this.arena.getFighters().size() * this.arena.getArenaConfig().getDouble(Config.CFG.MODULES_VAULT_BETWINPLAYERFACTOR);
                if (playerFactor <= 0.0) {
                    playerFactor = 1.0;
                }
                double amount = this.getPlayerBetMap().get(nKey) * (playerFactor *= this.arena.getArenaConfig().getDouble(Config.CFG.MODULES_VAULT_BETWINFACTOR));
                economy.depositPlayer(nSplit[0], amount);
                try {
                    ArenaModuleManager.announce((Arena)this.arena, (String)Language.parse((Language.MSG)Language.MSG.NOTICE_PLAYERAWARDED, (String)economy.format(amount)), (String)"PRIZE");
                    this.arena.msg((CommandSender)Bukkit.getPlayer((String)nSplit[0]), Language.parse((Language.MSG)Language.MSG.MODULE_VAULT_YOUWON, (String)economy.format(amount)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_VAULT_WINPOT)) {
                debug.i("calculating win pot!", (CommandSender)player);
                double amount = winners > 0 ? this.pot / (double)winners : 0.0;
                economy.depositPlayer(player.getName(), amount);
                this.arena.msg((CommandSender)player, Language.parse((Language.MSG)Language.MSG.NOTICE_AWARDED, (String)economy.format(amount)));
            } else if (this.arena.getArenaConfig().getInt(Config.CFG.MODULES_VAULT_WINREWARD, 0) > 0) {
                double amount = this.arena.getArenaConfig().getInt(Config.CFG.MODULES_VAULT_WINREWARD, 0);
                debug.i("calculating win reward: " + amount, (CommandSender)player);
                economy.depositPlayer(player.getName(), amount);
                this.arena.msg((CommandSender)player, Language.parse((Language.MSG)Language.MSG.NOTICE_AWARDED, (String)economy.format(amount)));
            }
            for (String nKey : this.getPlayerJoinMap().keySet()) {
                if (!nKey.equalsIgnoreCase(player.getName())) continue;
                double playerFactor = this.arena.getArenaConfig().getDouble(Config.CFG.MODULES_VAULT_WINFACTOR);
                double amount = this.getPlayerJoinMap().get(nKey) * playerFactor;
                economy.depositPlayer(nKey, amount);
                try {
                    ArenaModuleManager.announce((Arena)this.arena, (String)Language.parse((Language.MSG)Language.MSG.NOTICE_PLAYERAWARDED, (String)economy.format(amount)), (String)"PRIZE");
                    this.arena.msg((CommandSender)Bukkit.getPlayer((String)nKey), Language.parse((Language.MSG)Language.MSG.MODULE_VAULT_YOUWON, (String)economy.format(amount)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void killreward(Player p, Entity damager) {
        Player player = null;
        if (damager instanceof Player) {
            player = (Player)damager;
        }
        if (player == null) {
            return;
        }
        double amount = this.arena.getArenaConfig().getDouble(Config.CFG.MODULES_VAULT_KILLREWARD);
        if (amount < 0.01) {
            return;
        }
        if (!economy.hasAccount(player.getName())) {
            debug.i("Account not found: " + player.getName(), (CommandSender)player);
            return;
        }
        economy.depositPlayer(player.getName(), amount);
        try {
            this.arena.msg((CommandSender)Bukkit.getPlayer((String)player.getName()), Language.parse((Language.MSG)Language.MSG.MODULE_VAULT_YOUWON, (String)economy.format(amount)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void displayInfo(CommandSender player) {
        player.sendMessage("entryfee: " + StringParser.colorVar((int)this.arena.getArenaConfig().getInt(Config.CFG.MODULES_VAULT_ENTRYFEE)) + " || reward: " + StringParser.colorVar((int)this.arena.getArenaConfig().getInt(Config.CFG.MODULES_VAULT_WINREWARD)) + " || killreward: " + StringParser.colorVar((double)this.arena.getArenaConfig().getDouble(Config.CFG.MODULES_VAULT_KILLREWARD)) + " || winFactor: " + StringParser.colorVar((double)this.arena.getArenaConfig().getDouble(Config.CFG.MODULES_VAULT_WINFACTOR)));
        player.sendMessage("minbet: " + StringParser.colorVar((double)this.arena.getArenaConfig().getDouble(Config.CFG.MODULES_VAULT_MINIMUMBET)) + " || maxbet: " + StringParser.colorVar((double)this.arena.getArenaConfig().getDouble(Config.CFG.MODULES_VAULT_MAXIMUMBET)) + " || betWinFactor: " + StringParser.colorVar((double)this.arena.getArenaConfig().getDouble(Config.CFG.MODULES_VAULT_BETWINFACTOR)));
        player.sendMessage("betTeamWinFactor: " + StringParser.colorVar((double)this.arena.getArenaConfig().getDouble(Config.CFG.MODULES_VAULT_BETWINTEAMFACTOR)) + " || betPlayerWinFactor: " + StringParser.colorVar((double)this.arena.getArenaConfig().getDouble(Config.CFG.MODULES_VAULT_BETWINPLAYERFACTOR)));
        player.sendMessage(String.valueOf(StringParser.colorVar((String)"bet pot", (boolean)this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_VAULT_BETPOT))) + " || " + StringParser.colorVar((String)"win pot", (boolean)this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_VAULT_WINPOT)));
    }

    public void parseJoin(CommandSender sender, ArenaTeam team) {
        int entryfee = this.arena.getArenaConfig().getInt(Config.CFG.MODULES_VAULT_ENTRYFEE, 0);
        if (entryfee > 0 && economy != null) {
            economy.withdrawPlayer(sender.getName(), (double)entryfee);
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.MODULE_VAULT_JOINPAY, (String)economy.format((double)entryfee)));
            this.pot += (double)entryfee;
        }
    }

    public void parsePlayerDeath(Player p, EntityDamageEvent cause) {
        this.killreward(p, (Entity)ArenaPlayer.getLastDamagingPlayer((Event)cause));
    }

    protected void pay(HashSet<String> result) {
        if (result == null || result.size() == this.arena.getTeamNames().size()) {
            return;
        }
        debug.i("Paying winners: " + StringParser.joinSet(result, (String)", "));
        if (economy != null) {
            String[] nSplit;
            double pot = 0.0;
            double winpot = 0.0;
            for (String s : this.getPlayerBetMap().keySet()) {
                nSplit = s.split(":");
                pot += this.getPlayerBetMap().get(s).doubleValue();
                if (!result.contains(nSplit)) continue;
                winpot += this.getPlayerBetMap().get(s).doubleValue();
            }
            for (String nKey : this.getPlayerBetMap().keySet()) {
                nSplit = nKey.split(":");
                ArenaTeam team = this.arena.getTeam(nSplit[1]);
                if ((team == null || team.getName().equals("free")) && Bukkit.getPlayerExact((String)nSplit[1]) == null || !result.contains(nSplit[1])) continue;
                double amount = 0.0;
                if (this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_VAULT_BETPOT)) {
                    if (winpot > 0.0) {
                        amount = pot * this.getPlayerBetMap().get(nKey) / winpot;
                    }
                } else {
                    double teamFactor = this.arena.getArenaConfig().getDouble(Config.CFG.MODULES_VAULT_BETWINTEAMFACTOR) * (double)this.arena.getTeamNames().size();
                    if (teamFactor <= 0.0) {
                        teamFactor = 1.0;
                    }
                    amount = this.getPlayerBetMap().get(nKey) * (teamFactor *= this.arena.getArenaConfig().getDouble(Config.CFG.MODULES_VAULT_BETWINFACTOR));
                }
                if (!economy.hasAccount(nSplit[0])) {
                    debug.i("Account not found: " + nSplit[0]);
                    continue;
                }
                economy.depositPlayer(nSplit[0], amount);
                try {
                    this.arena.msg((CommandSender)Bukkit.getPlayer((String)nSplit[0]), Language.parse((Language.MSG)Language.MSG.MODULE_VAULT_YOUWON, (String)economy.format(amount)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void reset(boolean force) {
        this.getPlayerBetMap().clear();
        this.getPlayerJoinMap().clear();
        this.pot = 0.0;
    }

    public void resetPlayer(Player player, boolean force) {
        if (player == null) {
            return;
        }
        ArenaPlayer ap = ArenaPlayer.parsePlayer((String)player.getName());
        if (ap == null) {
            return;
        }
        if (ap.getStatus() == null || force) {
            return;
        }
        if (ap.getStatus().equals((Object)ArenaPlayer.Status.LOUNGE) || ap.getStatus().equals((Object)ArenaPlayer.Status.READY)) {
            int entryfee = this.arena.getArenaConfig().getInt(Config.CFG.MODULES_VAULT_ENTRYFEE);
            if (entryfee < 1) {
                return;
            }
            this.arena.msg((CommandSender)player, Language.parse((Language.MSG)Language.MSG.MODULE_VAULT_REFUNDING, (String)economy.format((double)entryfee)));
            if (!economy.hasAccount(player.getName())) {
                debug.i("Account not found: " + player.getName(), (CommandSender)player);
                return;
            }
            economy.depositPlayer(player.getName(), (double)entryfee);
            this.pot -= (double)entryfee;
        }
    }

    private boolean setupEconomy() {
        RegisteredServiceProvider economyProvider = Bukkit.getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            economy = (Economy)economyProvider.getProvider();
        }
        return economy != null;
    }

    public void timedEnd(HashSet<String> result) {
        this.pay(result);
    }
}

