/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.powerups;

import java.util.HashMap;
import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.core.Debug;
import net.slipcor.pvparena.modules.powerups.PowerupEffect;
import net.slipcor.pvparena.modules.powerups.PowerupType;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.player.PlayerVelocityEvent;

public class Powerup {
    public String name;
    public Material item;
    private PowerupEffect[] effects;
    private Debug debug = new Debug(16);

    public Powerup(String pName, HashMap<String, Object> puEffects) {
        PowerupEffect pe;
        PowerupType pec;
        int count = 0;
        this.name = pName;
        this.debug.i("creating powerup " + pName);
        this.item = Material.valueOf((String)((String)puEffects.get("item")));
        this.debug.i("item added: " + this.item.toString());
        for (String eClass : puEffects.keySet()) {
            pec = PowerupEffect.parseClass(eClass);
            if (pec == null) {
                if (eClass.equals("item")) continue;
                PVPArena.instance.getLogger().warning("unknown effect class: " + eClass);
                continue;
            }
            pe = new PowerupEffect(eClass, (HashMap)puEffects.get(eClass), PowerupEffect.parsePotionEffect(eClass));
            if (pe.type == null) continue;
            ++count;
        }
        this.debug.i("effects found: " + count);
        if (count < 1) {
            return;
        }
        this.effects = new PowerupEffect[count];
        count = 0;
        for (String eClass : puEffects.keySet()) {
            pec = PowerupEffect.parseClass(eClass);
            if (pec == null) continue;
            pe = new PowerupEffect(eClass, (HashMap)puEffects.get(eClass), PowerupEffect.parsePotionEffect(eClass));
            if (pe.type == null) continue;
            this.effects[count++] = pe;
        }
    }

    public Powerup(Powerup p) {
        this.name = p.name;
        this.effects = p.effects;
        this.item = p.item;
    }

    public boolean isActive() {
        PowerupEffect[] powerupEffectArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            PowerupEffect pe = powerupEffectArray[n2];
            if (pe.active) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isEffectActive(PowerupType peClass) {
        PowerupEffect[] powerupEffectArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            PowerupEffect pe = powerupEffectArray[n2];
            if (pe.uses != 0 && pe.duration != 0 && pe.type.equals((Object)peClass)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean canBeTriggered() {
        PowerupEffect[] powerupEffectArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            PowerupEffect pe = powerupEffectArray[n2];
            if (pe.uses != 0 && pe.duration != 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void activate(Player player) {
        this.debug.i("activating! - " + this.name, (CommandSender)player);
        PowerupEffect[] powerupEffectArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            PowerupEffect pe = powerupEffectArray[n2];
            if (pe.uses != 0 && pe.duration != 0) {
                pe.init(player);
            }
            ++n2;
        }
    }

    public void commit(Player attacker, Player defender, EntityDamageByEntityEvent event) {
        this.debug.i("committing effects:", (CommandSender)attacker);
        this.debug.i("committing effects:", (CommandSender)defender);
        PowerupEffect[] powerupEffectArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            PowerupEffect pe = powerupEffectArray[n2];
            if (pe.uses != 0 && pe.duration != 0) {
                pe.commit(attacker, defender, event);
            }
            ++n2;
        }
    }

    public void commit(EntityRegainHealthEvent event) {
        PowerupEffect[] powerupEffectArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            PowerupEffect pe = powerupEffectArray[n2];
            if (pe.uses != 0 && pe.duration != 0 && pe.type.equals((Object)PowerupType.HEAL)) {
                pe.commit(event);
            }
            ++n2;
        }
    }

    public void commit(PlayerVelocityEvent event) {
        PowerupEffect[] powerupEffectArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            PowerupEffect pe = powerupEffectArray[n2];
            if (pe.uses != 0 && pe.duration != 0 && pe.type.equals((Object)PowerupType.HEAL)) {
                pe.commit(event);
            }
            ++n2;
        }
    }

    public void tick() {
        PowerupEffect[] powerupEffectArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            PowerupEffect pe = powerupEffectArray[n2];
            if (pe.uses != 0 && pe.duration > 0) {
                --pe.duration;
            }
            ++n2;
        }
    }

    @Deprecated
    public void disable() {
    }
}

