/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.blockrestore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.classes.PABlockLocation;
import net.slipcor.pvparena.core.Debug;
import net.slipcor.pvparena.core.StringParser;
import net.slipcor.pvparena.loadables.ArenaRegionShape;
import net.slipcor.pvparena.modules.blockrestore.Blocks;
import net.slipcor.pvparena.modules.blockrestore.RestoreRunner;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.block.Dispenser;
import org.bukkit.block.Furnace;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class RestoreContainer {
    private Blocks blocks;
    private ArenaRegionShape bfRegion;
    private HashMap<Location, ItemStack[]> chests = new HashMap();
    private HashMap<Location, ItemStack[]> furnaces = new HashMap();
    private HashMap<Location, ItemStack[]> dispensers = new HashMap();
    private static Debug debug = new Debug(55);

    public RestoreContainer(Blocks b, ArenaRegionShape r) {
        this.blocks = b;
        this.bfRegion = r;
    }

    protected void restoreChests() {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)PVPArena.instance, (Runnable)new RestoreRunner(this.blocks, this.chests, this.furnaces, this.dispensers));
    }

    protected static ItemStack[] cloneIS(ItemStack[] contents) {
        ItemStack[] result = new ItemStack[contents.length];
        int i = 0;
        while (i < result.length) {
            if (contents[i] != null) {
                ItemStack is = contents[i];
                result[i] = new ItemStack(is.getType(), is.getAmount(), is.getDurability());
                result[i].setData(is.getData());
                for (Enchantment ench : is.getEnchantments().keySet()) {
                    result[i].addUnsafeEnchantment(ench, ((Integer)is.getEnchantments().get(ench)).intValue());
                }
            }
            ++i;
        }
        debug.i(StringParser.getStringFromItemStacks((ItemStack[])result));
        return result;
    }

    public void saveChests() {
        if (this.blocks.getArena().getArenaConfig().getStringList("inventories", new ArrayList()).size() > 0) {
            List tempList = this.blocks.getArena().getArenaConfig().getStringList("inventories", null);
            debug.i("reading inventories");
            for (String s : tempList) {
                Location loc = this.parseStringToLocation(s);
                this.saveBlock(loc.getWorld(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
            }
            return;
        }
        debug.i("NO inventories");
        this.chests.clear();
        this.furnaces.clear();
        this.dispensers.clear();
        PABlockLocation min = this.bfRegion.getMinimumLocation();
        PABlockLocation max = this.bfRegion.getMaximumLocation();
        debug.i("min: " + min.toString());
        debug.i("max: " + max.toString());
        World world = Bukkit.getWorld((String)max.getWorldName());
        ArrayList<String> result = new ArrayList<String>();
        if (this.bfRegion.getShape().equals((Object)ArenaRegionShape.RegionShape.CUBOID)) {
            debug.i("cube!");
            int x = min.getX();
            while (x <= max.getX()) {
                int y = min.getY();
                while (y <= max.getY()) {
                    int z = min.getZ();
                    while (z <= max.getZ()) {
                        Location loc = this.saveBlock(world, x, y, z);
                        if (loc != null) {
                            debug.i("loc not null: " + loc.toString());
                            result.add(this.parseLocationToString(loc));
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        } else if (this.bfRegion.getShape().equals((Object)ArenaRegionShape.RegionShape.SPHERIC)) {
            debug.i("sphere!");
            int x = min.getX();
            while (x <= max.getX()) {
                int y = min.getY();
                while (y <= max.getY()) {
                    int z = min.getZ();
                    while (z <= max.getZ()) {
                        Location loc = this.saveBlock(world, x, y, z);
                        if (loc != null) {
                            debug.i("loc not null: " + loc.toString());
                            result.add(this.parseLocationToString(loc));
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
        this.blocks.getArena().getArenaConfig().setManually("inventories", result);
        this.blocks.getArena().getArenaConfig().save();
    }

    private Location saveBlock(World world, int x, int y, int z) {
        Block b = world.getBlockAt(x, y, z);
        if (b.getType() == Material.CHEST) {
            Chest c = (Chest)b.getState();
            this.chests.put(b.getLocation(), RestoreContainer.cloneIS(c.getInventory().getContents()));
            return b.getLocation();
        }
        if (b.getType() == Material.FURNACE) {
            Furnace c = (Furnace)b.getState();
            this.furnaces.put(b.getLocation(), RestoreContainer.cloneIS(c.getInventory().getContents()));
            return b.getLocation();
        }
        if (b.getType() == Material.DISPENSER) {
            Dispenser c = (Dispenser)b.getState();
            this.dispensers.put(b.getLocation(), RestoreContainer.cloneIS(c.getInventory().getContents()));
            return b.getLocation();
        }
        return null;
    }

    private Location parseStringToLocation(String loc) {
        String[] args = loc.split(",");
        World world = Bukkit.getWorld((String)args[0]);
        int x = Integer.parseInt(args[1]);
        int y = Integer.parseInt(args[2]);
        int z = Integer.parseInt(args[3]);
        return new Location(world, (double)x, (double)y, (double)z);
    }

    private String parseLocationToString(Location loc) {
        return String.valueOf(loc.getWorld().getName()) + "," + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ();
    }
}

