/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.playerfinder;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.arena.ArenaPlayer;
import net.slipcor.pvparena.core.Language;
import net.slipcor.pvparena.loadables.ArenaModule;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class PlayerFinder
extends ArenaModule
implements Listener {
    boolean setup = false;

    public PlayerFinder() {
        super("PlayerFinder");
    }

    public String version() {
        return "v1.0.1.56";
    }

    public void onThisLoad() {
        if (!this.setup) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)PVPArena.instance);
            this.setup = true;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerFind(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (ArenaPlayer.parsePlayer((String)player.getName()).getArena() == null) {
            debug.i("No arena!", (CommandSender)player);
            return;
        }
        if (player.getItemInHand() == null || player.getItemInHand().getType() != Material.COMPASS) {
            debug.i("No compass!", (CommandSender)player);
            return;
        }
        List list = player.getNearbyEntities(100.0, 100.0, 100.0);
        HashMap<Double, Player> sortMap = new HashMap<Double, Player>();
        debug.i("ok!", (CommandSender)player);
        for (Entity e : list) {
            if (!(e instanceof Player) || e == player) continue;
            debug.i(((Player)e).getName(), (CommandSender)player);
            sortMap.put(player.getLocation().distance(e.getLocation()), (Player)e);
        }
        if (sortMap.isEmpty()) {
            debug.i("noone there!", (CommandSender)player);
        }
        TreeMap sortedMap = new TreeMap(sortMap);
        if (event.getAction() == Action.LEFT_CLICK_AIR) {
            debug.i("left");
            Iterator iterator = sortedMap.values().iterator();
            if (iterator.hasNext()) {
                Player otherPlayer = (Player)iterator.next();
                player.setCompassTarget(otherPlayer.getLocation());
                Arena.pmsg((CommandSender)player, (String)Language.parse((Language.MSG)Language.MSG.MODULE_PLAYERFINDER_POINT, (String)otherPlayer.getName()));
            }
        } else if (event.getAction() == Action.RIGHT_CLICK_AIR) {
            debug.i("right");
            Iterator iterator = sortedMap.keySet().iterator();
            if (iterator.hasNext()) {
                double d = (Double)iterator.next();
                Arena.pmsg((CommandSender)player, (String)Language.parse((Language.MSG)Language.MSG.MODULE_PLAYERFINDER_NEAR, (String)String.valueOf((int)d)));
            }
        }
    }
}

