/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.redstone;

import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.arena.ArenaPlayer;
import net.slipcor.pvparena.arena.ArenaTeam;
import net.slipcor.pvparena.classes.PABlockLocation;
import net.slipcor.pvparena.core.Debug;
import net.slipcor.pvparena.listeners.PlayerListener;
import net.slipcor.pvparena.loadables.ArenaModule;
import net.slipcor.pvparena.managers.ArenaManager;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;

public class RedStoneTriggers
extends ArenaModule
implements Listener {
    private boolean setup = false;

    public RedStoneTriggers() {
        super("RedStoneTriggers");
        debug = new Debug(403);
    }

    public String version() {
        return "v1.0.1.44";
    }

    public void configParse(YamlConfiguration config) {
        if (!this.setup) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)PVPArena.instance);
            this.setup = true;
        }
    }

    @EventHandler
    public void onRedStone(BlockRedstoneEvent event) {
        block7: {
            Sign s;
            Arena arena;
            block6: {
                arena = ArenaManager.getArenaByRegionLocation((PABlockLocation)new PABlockLocation(event.getBlock().getLocation()));
                if (arena == null || !arena.equals(this.arena)) {
                    return;
                }
                debug.i("redstone in arena " + arena.toString());
                Block block = event.getBlock();
                if (!(block.getState() instanceof Sign)) {
                    return;
                }
                s = (Sign)block.getState();
                if (!s.getLine(0).equals("[WIN]")) break block6;
                for (ArenaTeam team : arena.getTeams()) {
                    if (team.getName().equalsIgnoreCase(s.getLine(1))) continue;
                    for (ArenaPlayer ap : team.getTeamMembers()) {
                        if (!ap.getStatus().equals((Object)ArenaPlayer.Status.FIGHT)) continue;
                        event.getBlock().getWorld().strikeLightningEffect(ap.get().getLocation());
                        EntityDamageEvent e = new EntityDamageEvent((Entity)ap.get(), EntityDamageEvent.DamageCause.LIGHTNING, 10);
                        PlayerListener.finallyKillPlayer((Arena)arena, (Player)ap.get(), (Event)e);
                    }
                }
                break block7;
            }
            if (!s.getLine(0).equals("[LOSE]")) break block7;
            for (ArenaTeam team : arena.getTeams()) {
                if (!team.getName().equalsIgnoreCase(s.getLine(1))) continue;
                for (ArenaPlayer ap : team.getTeamMembers()) {
                    if (!ap.getStatus().equals((Object)ArenaPlayer.Status.FIGHT)) continue;
                    event.getBlock().getWorld().strikeLightningEffect(ap.get().getLocation());
                    EntityDamageEvent e = new EntityDamageEvent((Entity)ap.get(), EntityDamageEvent.DamageCause.LIGHTNING, 10);
                    PlayerListener.finallyKillPlayer((Arena)arena, (Player)ap.get(), (Event)e);
                }
            }
        }
    }
}

