/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.turrets;

import java.util.HashMap;
import java.util.Map;
import net.slipcor.pvparena.classes.PALocation;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LargeFireball;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.WitherSkull;

public class Turret {
    private final double yaw;
    private final double offset;
    private static Map<String, Class<? extends Projectile>> types = new HashMap<String, Class<? extends Projectile>>();
    private final Class<? extends Projectile> type;

    static {
        types.put("fire", Fireball.class);
        types.put("snow", Snowball.class);
        types.put("large", LargeFireball.class);
        types.put("small", SmallFireball.class);
        types.put("wither", WitherSkull.class);
    }

    public Turret(String name, PALocation loc, double offset) {
        this.yaw = loc.getYaw();
        this.offset = offset < 10.0 ? 10.0 : offset;
        for (String string : types.keySet()) {
            if (!name.contains(string)) continue;
            this.type = types.get(string);
            return;
        }
        this.type = Arrow.class;
    }

    protected Class<? extends Projectile> getType() {
        return this.type;
    }

    public boolean cancelMovement(float oldYaw) {
        float yaw = oldYaw;
        yaw = (float)((double)yaw - this.yaw);
        if ((yaw = Math.abs(yaw)) > 180.0f) {
            yaw = 360.0f - yaw;
        }
        return (double)yaw > this.offset;
    }

    public float getYaw() {
        return (float)this.yaw;
    }
}

