/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.realspectate;

import java.util.HashSet;
import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.ArenaPlayer;
import net.slipcor.pvparena.arena.ArenaTeam;
import net.slipcor.pvparena.classes.PACheck;
import net.slipcor.pvparena.classes.PALocation;
import net.slipcor.pvparena.core.Language;
import net.slipcor.pvparena.loadables.ArenaModule;
import net.slipcor.pvparena.modules.realspectate.RealSpectateListener;
import net.slipcor.pvparena.modules.realspectate.SpectateWrapper;
import net.slipcor.pvparena.ncloader.NCBLoadable;
import net.slipcor.pvparena.runnables.PlayerStateCreateRunnable;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class RealSpectate
extends ArenaModule {
    RealSpectateListener listener = null;
    int priority = 2;

    public RealSpectate() {
        super("RealSpectate");
    }

    public String version() {
        return "v1.0.0.0";
    }

    public PACheck checkJoin(CommandSender sender, PACheck res, boolean join) {
        if (join) {
            return res;
        }
        if (this.arena.getFighters().size() < 1) {
            res.setError((NCBLoadable)this, Language.parse((Language.MSG)Language.MSG.ERROR_NOPLAYERFOUND));
        }
        if (res.getPriority() < this.priority) {
            res.setPriority((NCBLoadable)this, this.priority);
        }
        return res;
    }

    public void commitSpectate(Player player) {
        debug.i("committing REAL spectate", (CommandSender)player);
        ArenaPlayer ap = ArenaPlayer.parsePlayer((String)player.getName());
        ap.setLocation(new PALocation(ap.get().getLocation()));
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)PVPArena.instance, (Runnable)new PlayerStateCreateRunnable(ap, ap.get()), 2L);
        ap.setArena(this.arena);
        ap.setStatus(ArenaPlayer.Status.WATCH);
        debug.i("switching:", (CommandSender)player);
        this.getListener().switchPlayer(player, null, true);
    }

    public void parseJoin(CommandSender sender, ArenaTeam team) {
        for (SpectateWrapper sw : this.getListener().spectated_players.values()) {
            sw.update();
        }
    }

    public void parseStart() {
        this.getListener();
    }

    public void reset(boolean force) {
        this.getListener();
        HashSet<SpectateWrapper> list = new HashSet<SpectateWrapper>();
        HashSet<Player> pList = new HashSet<Player>();
        for (Player p : this.getListener().spectated_players.keySet()) {
            pList.add(p);
        }
        for (SpectateWrapper sw : this.getListener().spectated_players.values()) {
            list.add(sw);
        }
        for (SpectateWrapper sw : list) {
            sw.stopHard();
        }
        this.getListener().spectated_players.clear();
    }

    public void unload(Player player) {
        HashSet<SpectateWrapper> list = new HashSet<SpectateWrapper>();
        for (SpectateWrapper sw : this.getListener().spectated_players.values()) {
            list.add(sw);
        }
        Player[] playerArray = Bukkit.getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            p.showPlayer(player);
            ++n2;
        }
        for (SpectateWrapper sw : list) {
            if (!sw.hasSpectator(player)) continue;
            sw.removeSpectator(player);
            return;
        }
        if (this.arena.getFighters().size() < 1) {
            HashSet<SpectateWrapper> list2 = new HashSet<SpectateWrapper>();
            for (SpectateWrapper sw : this.getListener().spectated_players.values()) {
                list2.add(sw);
            }
            for (SpectateWrapper sw : list2) {
                sw.stopSpectating();
            }
            this.getListener().spectated_players.clear();
        }
    }

    RealSpectateListener getListener() {
        if (this.listener == null) {
            this.listener = new RealSpectateListener(this);
            Bukkit.getPluginManager().registerEvents((Listener)this.listener, (Plugin)PVPArena.instance);
        }
        return this.listener;
    }
}

