/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.realspectate;

import java.util.HashMap;
import java.util.Iterator;
import net.slipcor.pvparena.arena.ArenaPlayer;
import net.slipcor.pvparena.classes.PABlockLocation;
import net.slipcor.pvparena.core.Debug;
import net.slipcor.pvparena.modules.realspectate.RealSpectate;
import net.slipcor.pvparena.modules.realspectate.SpectateWrapper;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.util.Vector;

public class RealSpectateListener
implements Listener {
    final RealSpectate rs;
    HashMap<Player, SpectateWrapper> spectated_players = new HashMap();
    Debug debug = new Debug(456);

    public RealSpectateListener(RealSpectate realSpectate) {
        this.rs = realSpectate;
    }

    void initiate(ArenaPlayer ap) {
        Iterator iterator = this.rs.getArena().getEveryone().iterator();
        if (iterator.hasNext()) {
            ArenaPlayer a = (ArenaPlayer)iterator.next();
            this.update(ap, a);
        }
    }

    void update(ArenaPlayer spectator, ArenaPlayer fighter) {
        Player s = spectator.get();
        Player f = fighter.get();
        this.createSpectateWrapper(s, f);
    }

    SpectateWrapper createSpectateWrapper(Player s, Player f) {
        this.debug.i("create wrapper: " + s.getName() + "+" + String.valueOf(f), (CommandSender)s);
        if (!this.spectated_players.containsKey(f)) {
            this.spectated_players.put(f, new SpectateWrapper(s, f, this));
        }
        for (SpectateWrapper sw : this.spectated_players.values()) {
            sw.update(s);
            sw.update();
        }
        return this.spectated_players.get(f);
    }

    private Player getSpectatedSuspect(Player p) {
        for (SpectateWrapper sw : this.spectated_players.values()) {
            if (!sw.hasSpectator(p)) continue;
            return sw.getSuspect();
        }
        return null;
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getEntityType() != EntityType.PLAYER) {
            return;
        }
        Player subject = this.getSpectatedSuspect((Player)event.getEntity());
        if (subject != null) {
            this.debug.i("player is spectating and being damaged", (CommandSender)subject);
            if (event.getDamager() instanceof Projectile) {
                this.debug.i("relay damage", (CommandSender)subject);
                EntityDamageByEntityEvent projectileEvent = new EntityDamageByEntityEvent(event.getDamager(), (Entity)subject, event.getCause(), event.getDamage());
                subject.setLastDamageCause((EntityDamageEvent)projectileEvent);
                subject.damage(event.getDamage(), event.getDamager());
            }
            event.setCancelled(true);
            event.getDamager().remove();
            return;
        }
        subject = (Player)event.getEntity();
        if (!this.spectated_players.containsKey(subject)) {
            return;
        }
        this.spectated_players.get(subject).updateHealth();
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onEntityDeath(EntityDeathEvent event) {
        if (event.getEntityType() != EntityType.PLAYER) {
            return;
        }
        Player subject = this.getSpectatedSuspect((Player)event.getEntity());
        if (subject != null) {
            Player spectator = (Player)event.getEntity();
            spectator.setHealth(1);
            event.getDrops().clear();
            return;
        }
        subject = (Player)event.getEntity();
        if (!this.spectated_players.containsKey(subject)) {
            return;
        }
        this.spectated_players.get(subject).stopSpectating();
        this.spectated_players.remove(subject);
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityRegainHealth(EntityRegainHealthEvent event) {
        if (event.getEntityType() != EntityType.PLAYER) {
            return;
        }
        Player subject = this.getSpectatedSuspect((Player)event.getEntity());
        if (subject != null) {
            event.setCancelled(true);
            return;
        }
        subject = (Player)event.getEntity();
        if (!this.spectated_players.containsKey(subject)) {
            return;
        }
        this.spectated_players.get(subject).updateHealth();
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityTarget(EntityTargetEvent event) {
        if (event.getTarget() == null || event.getTarget().getType() != EntityType.PLAYER) {
            return;
        }
        Player subject = (Player)event.getTarget();
        if (!this.spectated_players.containsKey(subject)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        Player subject = this.getSpectatedSuspect((Player)event.getWhoClicked());
        if (subject != null) {
            event.setCancelled(true);
            return;
        }
        subject = (Player)event.getWhoClicked();
        if (!this.spectated_players.containsKey(subject)) {
            return;
        }
        this.spectated_players.get(subject).updateInventory();
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClose(InventoryCloseEvent event) {
        Player subject = this.getSpectatedSuspect((Player)event.getPlayer());
        if (subject != null) {
            return;
        }
        subject = (Player)event.getPlayer();
        if (!this.spectated_players.containsKey(subject)) {
            return;
        }
        this.spectated_players.get(subject).closeInventory(event.getInventory());
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryOpen(InventoryOpenEvent event) {
        Player subject = this.getSpectatedSuspect((Player)event.getPlayer());
        if (subject != null) {
            event.setCancelled(true);
            return;
        }
        subject = (Player)event.getPlayer();
        if (!this.spectated_players.containsKey(subject)) {
            return;
        }
        this.spectated_players.get(subject).openInventory(event.getInventory());
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Player subject = this.getSpectatedSuspect(event.getPlayer());
        if (subject != null) {
            event.setCancelled(true);
            return;
        }
        subject = event.getPlayer();
        if (!this.spectated_players.containsKey(subject)) {
            return;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player subject = this.getSpectatedSuspect(event.getPlayer());
        if (subject != null) {
            Player spectator = event.getPlayer();
            String actionName = event.getAction().name();
            event.setCancelled(true);
            if (actionName.startsWith("LEFT_")) {
                this.switchPlayer(spectator, subject, false);
            } else if (actionName.startsWith("RIGHT_")) {
                this.switchPlayer(spectator, subject, true);
            }
            return;
        }
        subject = event.getPlayer();
        if (!this.spectated_players.containsKey(subject)) {
            return;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Player subject = this.getSpectatedSuspect(event.getPlayer());
        if (subject != null) {
            Player spectator = event.getPlayer();
            event.setCancelled(true);
            this.switchPlayer(spectator, subject, event.getRightClicked() != null);
            return;
        }
        subject = event.getPlayer();
        if (!this.spectated_players.containsKey(subject)) {
            return;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerItemHeld(PlayerItemHeldEvent event) {
        Player subject = this.getSpectatedSuspect(event.getPlayer());
        if (subject != null) {
            return;
        }
        subject = event.getPlayer();
        if (!this.spectated_players.containsKey(subject)) {
            return;
        }
        this.spectated_players.get(subject).selectItem(event.getNewSlot());
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        Player subject = this.getSpectatedSuspect(event.getPlayer());
        if (subject != null) {
            event.setCancelled(true);
            return;
        }
        subject = event.getPlayer();
        if (!this.spectated_players.containsKey(subject)) {
            return;
        }
        this.spectated_players.get(subject).updateLocation();
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        Player subject = this.getSpectatedSuspect(event.getPlayer());
        if (subject != null) {
            event.setCancelled(true);
            return;
        }
        subject = event.getPlayer();
        if (!this.spectated_players.containsKey(subject)) {
            return;
        }
        this.spectated_players.get(subject).updateInventory();
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player subject = this.getSpectatedSuspect(event.getPlayer());
        if (subject != null) {
            Player spectator = event.getPlayer();
            this.spectated_players.get(subject).removeSpectator(spectator);
            return;
        }
        subject = event.getPlayer();
        if (!this.spectated_players.containsKey(subject)) {
            return;
        }
        this.spectated_players.get(subject).stopSpectating();
        this.spectated_players.remove(subject);
    }

    @EventHandler(ignoreCancelled=true)
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        this.debug.i("ProjectileLaunch!");
        if (event == null || event.getEntity() == null || event.getEntity().getShooter() == null || !event.getEntity().getShooter().getType().equals((Object)EntityType.PLAYER)) {
            return;
        }
        Player subject = this.getSpectatedSuspect((Player)event.getEntity().getShooter());
        if (subject != null) {
            this.debug.i("subject != null", (CommandSender)subject);
            event.setCancelled(true);
            return;
        }
        subject = (Player)event.getEntity().getShooter();
        if (!this.spectated_players.containsKey(subject)) {
            this.debug.i("not being spectated", (CommandSender)subject);
            return;
        }
        this.debug.i("subject is being spectated", (CommandSender)subject);
        Projectile projectile = event.getEntity();
        Location location = subject.getLocation();
        this.debug.i(String.valueOf(new PABlockLocation(location)), (CommandSender)subject);
        Vector direction = location.getDirection();
        location.add(direction.normalize().multiply(1));
        location.setY(location.getY() + 1.4);
        this.debug.i(String.valueOf(new PABlockLocation(location)), (CommandSender)subject);
        projectile.teleport(location);
    }

    void switchPlayer(Player spectator, Player subject, boolean forward) {
        if (subject != null) {
            spectator.showPlayer(subject);
        }
        if (this.rs.getArena().getFighters().size() < 1) {
            this.debug.i("< 1", (CommandSender)spectator);
            return;
        }
        Player nextPlayer = null;
        boolean next = false;
        for (ArenaPlayer ap : this.rs.getArena().getFighters()) {
            this.debug.i("checking " + ap.getName(), (CommandSender)spectator);
            Player p = ap.get();
            if (subject == null) {
                this.debug.i("subject == null", (CommandSender)spectator);
                nextPlayer = p;
                break;
            }
            if (!p.equals(subject) || next) {
                this.debug.i("||", (CommandSender)spectator);
                nextPlayer = p;
                if (!next) continue;
                this.debug.i("next", (CommandSender)spectator);
                break;
            }
            if (forward) continue;
            this.debug.i("step back", (CommandSender)spectator);
            if (nextPlayer == null) {
                this.debug.i("get last element", (CommandSender)spectator);
                for (ArenaPlayer ap2 : this.rs.getArena().getFighters()) {
                    this.debug.i(ap2.getName(), (CommandSender)spectator);
                    nextPlayer = ap2.get();
                }
            }
            this.debug.i("==>" + nextPlayer.getName(), (CommandSender)spectator);
            break;
        }
        if (subject != null) {
            this.spectated_players.get(subject).removeSpectator(spectator);
        }
        this.createSpectateWrapper(spectator, nextPlayer);
    }
}

