/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.flyspectate;

import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.ArenaPlayer;
import net.slipcor.pvparena.arena.ArenaTeam;
import net.slipcor.pvparena.classes.PACheck;
import net.slipcor.pvparena.classes.PALocation;
import net.slipcor.pvparena.core.Language;
import net.slipcor.pvparena.loadables.ArenaModule;
import net.slipcor.pvparena.modules.flyspectate.RealSpectateListener;
import net.slipcor.pvparena.ncloader.NCBLoadable;
import net.slipcor.pvparena.runnables.PlayerStateCreateRunnable;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class FlySpectate
extends ArenaModule {
    RealSpectateListener listener = null;
    int priority = 3;

    public FlySpectate() {
        super("FlySpectate");
    }

    public String version() {
        return "v1.0.0.0";
    }

    public PACheck checkJoin(CommandSender sender, PACheck res, boolean join) {
        if (join) {
            return res;
        }
        if (this.arena.getFighters().size() < 1) {
            res.setError((NCBLoadable)this, Language.parse((Language.MSG)Language.MSG.ERROR_NOPLAYERFOUND));
        }
        if (res.getPriority() < this.priority) {
            res.setPriority((NCBLoadable)this, this.priority);
        }
        return res;
    }

    RealSpectateListener getListener() {
        if (this.listener == null) {
            this.listener = new RealSpectateListener(this);
            Bukkit.getPluginManager().registerEvents((Listener)this.listener, (Plugin)PVPArena.instance);
        }
        return this.listener;
    }

    public void commitSpectate(Player player) {
        debug.i("committing REAL spectate", (CommandSender)player);
        ArenaPlayer ap = ArenaPlayer.parsePlayer((String)player.getName());
        ap.setLocation(new PALocation(ap.get().getLocation()));
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)PVPArena.instance, (Runnable)new PlayerStateCreateRunnable(ap, ap.get()), 2L);
        ap.setArena(this.arena);
        ap.setStatus(ArenaPlayer.Status.WATCH);
        debug.i("switching:", (CommandSender)player);
        this.getListener().hidePlayerLater(player);
        class RunLater
        implements Runnable {
            private final /* synthetic */ Player val$player;

            RunLater(Player player) {
                this.val$player = player;
            }

            @Override
            public void run() {
                FlySpectate.this.arena.tpPlayerToCoordName(this.val$player, "spectator");
                this.val$player.setGameMode(GameMode.CREATIVE);
            }
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)PVPArena.instance, (Runnable)new RunLater(player), 5L);
    }

    public void parseJoin(CommandSender sender, ArenaTeam team) {
        this.getListener().hideAllSpectatorsLater();
    }

    public void reset(boolean force) {
        if (this.listener != null) {
            this.listener.stop();
        }
    }

    public void unload(Player player) {
        Player[] playerArray = Bukkit.getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            p.showPlayer(player);
            ++n2;
        }
        this.getListener().removeSpectator(player);
    }
}

