/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.turrets;

import java.util.HashMap;
import java.util.Map;
import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.classes.PABlockLocation;
import net.slipcor.pvparena.classes.PALocation;
import net.slipcor.pvparena.core.Config;
import net.slipcor.pvparena.core.Debug;
import net.slipcor.pvparena.loadables.ArenaModule;
import net.slipcor.pvparena.managers.SpawnManager;
import net.slipcor.pvparena.modules.turrets.Turret;
import org.bukkit.Bukkit;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class Turrets
extends ArenaModule
implements Listener {
    private boolean setup = false;
    private Map<String, Long> shootingPlayers;
    private Map<PABlockLocation, Turret> turretMap;
    private int minInterval = 0;

    public Turrets() {
        super("Turrets");
        debug = new Debug(413);
    }

    public String version() {
        return "v1.0.1.44";
    }

    public boolean hasSpawn(String spawn) {
        return spawn.contains("turret");
    }

    public void configParse(YamlConfiguration config) {
        if (!this.setup) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)PVPArena.instance);
            this.setup = true;
        }
        this.shootingPlayers = new HashMap<String, Long>();
        this.turretMap = new HashMap<PABlockLocation, Turret>();
        Map spawns = SpawnManager.getSpawnMap((Arena)this.arena, (String)"turrets");
        double degrees = this.arena.getArenaConfig().getDouble(Config.CFG.MODULES_TURRETS_MAXDEGREES);
        for (String name : spawns.keySet()) {
            PALocation loc = (PALocation)spawns.get(name);
            this.turretMap.put(new PABlockLocation(loc.toLocation()), new Turret(name, loc, degrees));
        }
        this.minInterval = this.arena.getArenaConfig().getInt(Config.CFG.MODULES_TURRETS_MININTERVAL);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlateTrigger(PlayerInteractEvent event) {
        if (event.getAction() != Action.PHYSICAL) {
            return;
        }
        debug.i("plateTrigger", (CommandSender)event.getPlayer());
        PABlockLocation loc = new PABlockLocation(event.getClickedBlock().getLocation());
        if (this.turretMap.containsKey(loc)) {
            debug.i("found. set!", (CommandSender)event.getPlayer());
            class RunLater
            implements Runnable {
                private final /* synthetic */ PlayerInteractEvent val$event;

                RunLater(PlayerInteractEvent playerInteractEvent) {
                    this.val$event = playerInteractEvent;
                }

                @Override
                public void run() {
                    debug.i("set done!", (CommandSender)this.val$event.getPlayer());
                    Turrets.this.shootingPlayers.put(this.val$event.getPlayer().getName(), System.currentTimeMillis() + (long)(Turrets.this.minInterval * 50));
                }
            }
            Bukkit.getScheduler().runTaskLater((Plugin)PVPArena.instance, (Runnable)new RunLater(event), 5L);
        }
    }

    @EventHandler
    public void onClick(PlayerInteractEvent event) {
        debug.i("click!", (CommandSender)event.getPlayer());
        if (this.arena == null || !this.arena.isFightInProgress() || !this.shootingPlayers.containsKey(event.getPlayer().getName())) {
            return;
        }
        debug.i("ok?", (CommandSender)event.getPlayer());
        if (event.getAction() == Action.PHYSICAL || this.shootingPlayers.get(event.getPlayer().getName()) > System.currentTimeMillis()) {
            return;
        }
        debug.i("ok!", (CommandSender)event.getPlayer());
        Player player = event.getPlayer();
        Turret turret = this.turretMap.get(new PABlockLocation(event.getPlayer().getLocation()));
        if (turret == null) {
            return;
        }
        Projectile projectile = player.launchProjectile(turret.getType());
        projectile.teleport(event.getPlayer().getLocation().getBlock().getRelative(BlockFace.UP, 3).getLocation().add(0.5, 0.5, 0.5).add(projectile.getVelocity().multiply(0)));
        this.shootingPlayers.put(event.getPlayer().getName(), System.currentTimeMillis() + (long)(this.minInterval * 50));
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (this.arena == null || !this.arena.isFightInProgress() || !this.shootingPlayers.containsKey(event.getPlayer().getName())) {
            return;
        }
        if (event.getTo().getBlock().equals(event.getFrom().getBlock())) {
            Turret turret = this.turretMap.get(new PABlockLocation(event.getFrom()));
            if (turret != null && turret.cancelMovement(event.getTo().getYaw())) {
                event.setCancelled(true);
                event.getPlayer().getLocation().setYaw(turret.getYaw());
            }
            return;
        }
        debug.i("new block!", (CommandSender)event.getPlayer());
        this.shootingPlayers.remove(event.getPlayer().getName());
    }

    public void reset(boolean force) {
        this.shootingPlayers.clear();
    }
}

