/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.specialjoin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.arena.ArenaTeam;
import net.slipcor.pvparena.classes.PABlockLocation;
import net.slipcor.pvparena.commands.PAG_Join;
import net.slipcor.pvparena.commands.PAG_Spectate;
import net.slipcor.pvparena.core.Config;
import net.slipcor.pvparena.core.Language;
import net.slipcor.pvparena.loadables.ArenaModule;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class SpecialJoin
extends ArenaModule
implements Listener {
    static HashMap<PABlockLocation, Arena> places = new HashMap();
    static HashMap<String, Arena> selections = new HashMap();
    boolean setup = false;

    public SpecialJoin() {
        super("SpecialJoin");
    }

    public String version() {
        return "v1.0.1.72";
    }

    public boolean checkCommand(String s) {
        return s.toLowerCase().equals("setjoin");
    }

    public void configParse(YamlConfiguration config) {
        try {
            List res = config.getStringList("modules.specialjoin.places");
            for (String s : res) {
                places.put(Config.parseBlockLocation((String)s), this.arena);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void commitCommand(CommandSender sender, String[] args) {
        if (!PVPArena.hasAdminPerms((CommandSender)sender) && !PVPArena.hasCreatePerms((CommandSender)sender, (Arena)this.arena)) {
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM, (String)Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM_X_ADMIN)));
            return;
        }
        if (selections.containsKey(sender.getName())) {
            selections.remove(sender.getName());
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.MODULE_SPECIALJOIN_STOP));
        } else {
            selections.put(sender.getName(), this.arena);
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.MODULE_SPECIALJOIN_START));
        }
    }

    public void onThisLoad() {
        if (!this.setup) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)PVPArena.instance);
            this.setup = true;
        }
    }

    @EventHandler
    public void onSpecialJoin(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            debug.i("PIA cancelled!", (CommandSender)event.getPlayer());
            return;
        }
        debug.i("PIA!", (CommandSender)event.getPlayer());
        if (event.getAction().equals((Object)Action.PHYSICAL)) {
            debug.i("Join via pressure plate!", (CommandSender)event.getPlayer());
            if (event.getPlayer() == null) {
                debug.i("wth?", (CommandSender)event.getPlayer());
                return;
            }
            PABlockLocation loc = new PABlockLocation(event.getPlayer().getLocation());
            PABlockLocation find = null;
            for (PABlockLocation l : places.keySet()) {
                if (!l.getWorldName().equals(loc.getWorldName()) || !(l.getDistance(loc) < (double)0.1f)) continue;
                find = l;
            }
            if (find == null) {
                debug.i("not contained!", (CommandSender)event.getPlayer());
                return;
            }
            PAG_Join j = new PAG_Join();
            j.commit(places.get(find), (CommandSender)event.getPlayer(), new String[0]);
            return;
        }
        if (!event.hasBlock()) {
            debug.i("not has block, out!", (CommandSender)event.getPlayer());
            return;
        }
        if (selections.containsKey(event.getPlayer().getName())) {
            debug.i("selection contains!", (CommandSender)event.getPlayer());
            Material mat = event.getClickedBlock().getType();
            String place = null;
            if (mat == Material.STONE_PLATE || mat == Material.WOOD_PLATE) {
                place = mat.name();
            } else if (mat == Material.STONE_BUTTON || mat == Material.LEVER) {
                place = mat.name();
            } else if (mat == Material.SIGN || mat == Material.SIGN_POST || mat == Material.WALL_SIGN) {
                place = mat.name();
            } else {
                return;
            }
            Arena a = selections.get(event.getPlayer().getName());
            places.put(new PABlockLocation(event.getClickedBlock().getLocation()), a);
            selections.remove(event.getPlayer().getName());
            a.msg((CommandSender)event.getPlayer(), Language.parse((Language.MSG)Language.MSG.MODULE_SPECIALJOIN_DONE, (String)place));
            SpecialJoin.update(a);
            return;
        }
        PABlockLocation loc = new PABlockLocation(event.getClickedBlock().getLocation());
        PABlockLocation find = null;
        for (PABlockLocation l : places.keySet()) {
            if (!l.getWorldName().equals(loc.getWorldName()) || !(l.getDistance(loc) < (double)0.1f)) continue;
            find = l;
        }
        if (find == null) {
            debug.i("places does not contain!", (CommandSender)event.getPlayer());
            return;
        }
        PAG_Join j = new PAG_Join();
        Material mat = event.getClickedBlock().getType();
        if (mat == Material.STONE_BUTTON || mat == Material.LEVER) {
            j.commit(places.get(find), (CommandSender)event.getPlayer(), new String[0]);
        } else if (mat == Material.SIGN || mat == Material.SIGN_POST || mat == Material.WALL_SIGN) {
            Sign s = (Sign)event.getClickedBlock().getState();
            String[] arr = new String[]{s.getLine(1)};
            if (s.getLine(2) != null && s.getLine(2).length() > 0) {
                PAG_Spectate jj = new PAG_Spectate();
                jj.commit(places.get(find), (CommandSender)event.getPlayer(), new String[0]);
            } else {
                j.commit(places.get(find), (CommandSender)event.getPlayer(), arr);
            }
        }
    }

    public void parseJoin(CommandSender sender, ArenaTeam team) {
        SpecialJoin.updateSignDisplay();
    }

    public void parsePlayerLeave(Player player, ArenaTeam team) {
        SpecialJoin.updateSignDisplay();
    }

    public void parseStart() {
        SpecialJoin.updateSignDisplay();
    }

    public void reset(boolean force) {
        SpecialJoin.updateSignDisplay();
    }

    private static void update(Arena a) {
        ArrayList<String> locs = new ArrayList<String>();
        for (PABlockLocation l : places.keySet()) {
            if (!a.getName().equals(places.get(l).getName())) continue;
            locs.add(Config.parseToString((PABlockLocation)l));
        }
        a.getArenaConfig().setManually("modules.specialjoin.places", locs);
        a.getArenaConfig().save();
    }

    private static void updateSignDisplay() {
        class RunLater
        implements Runnable {
            RunLater() {
            }

            @Override
            public void run() {
                for (PABlockLocation loc : places.keySet()) {
                    BlockState state;
                    Arena arena = places.get(loc);
                    if (!arena.getArenaConfig().getBoolean(Config.CFG.MODULES_SPECIALJOIN_SHOWPLAYERS) || !((state = loc.toLocation().getBlock().getState()) instanceof Sign)) continue;
                    Sign sign = (Sign)state;
                    String line = String.valueOf(arena.isFightInProgress() ? "\u00a7a" : (arena.isLocked() ? "\u00a7c" : "\u00a76")) + arena.getFighters().size();
                    int maxPlayers = arena.getArenaConfig().getInt(Config.CFG.READY_MAXPLAYERS);
                    if (maxPlayers > 0) {
                        line = String.valueOf(line) + " / " + maxPlayers;
                    }
                    sign.setLine(3, line);
                    sign.update();
                }
            }
        }
        Bukkit.getScheduler().runTaskLater((Plugin)PVPArena.instance, (Runnable)new RunLater(), 3L);
    }
}

