/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.maps;

import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.classes.PABlockLocation;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class MapItem {
    private final int x;
    private final int z;
    private final boolean player;
    private final String name;
    private final ChatColor color;

    public MapItem(Arena a, Player p, ChatColor c) {
        this.player = true;
        this.color = c;
        this.name = p.getName();
        this.x = 0;
        this.z = 0;
    }

    public MapItem(Arena a, PABlockLocation coord, ChatColor c) {
        this.player = false;
        this.name = null;
        this.color = c;
        this.x = coord.getX();
        this.z = coord.getZ();
    }

    public int getX() {
        if (this.player) {
            try {
                return Bukkit.getPlayerExact((String)this.name).getLocation().getBlockX();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this.x;
    }

    public int getZ() {
        if (this.player) {
            try {
                return Bukkit.getPlayerExact((String)this.name).getLocation().getBlockZ();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this.z;
    }

    public ChatColor getColor() {
        return this.color;
    }

    public boolean isPlayer() {
        return this.player;
    }

    public String getName() {
        return this.name;
    }
}

