/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.maps;

import java.util.HashSet;
import java.util.Set;
import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.arena.ArenaTeam;
import net.slipcor.pvparena.classes.PABlockLocation;
import net.slipcor.pvparena.classes.PALocation;
import net.slipcor.pvparena.commands.AbstractArenaCommand;
import net.slipcor.pvparena.core.Config;
import net.slipcor.pvparena.core.Language;
import net.slipcor.pvparena.core.StringParser;
import net.slipcor.pvparena.goals.GoalFlags;
import net.slipcor.pvparena.loadables.ArenaGoal;
import net.slipcor.pvparena.loadables.ArenaModule;
import net.slipcor.pvparena.managers.SpawnManager;
import net.slipcor.pvparena.modules.maps.MapItem;
import net.slipcor.pvparena.modules.maps.MapListener;
import net.slipcor.pvparena.modules.maps.MyRenderer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;

public class Maps
extends ArenaModule {
    private HashSet<String> mappings = new HashSet();
    private HashSet<MapItem> items = new HashSet();
    private boolean setup = false;

    public Maps() {
        super("ArenaMaps");
    }

    public String version() {
        return "v1.0.1.59";
    }

    public boolean checkCommand(String s) {
        return s.equals("!map") || s.equals("arenamaps");
    }

    public void commitCommand(CommandSender sender, String[] args) {
        if (!PVPArena.hasAdminPerms((CommandSender)sender) && !PVPArena.hasCreatePerms((CommandSender)sender, (Arena)this.arena)) {
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM, (String)Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM_X_ADMIN)));
            return;
        }
        if (!AbstractArenaCommand.argCountValid((CommandSender)sender, (Arena)this.arena, (String[])args, (Integer[])new Integer[]{2})) {
            return;
        }
        if (args[0].equals("!map") || args[0].equals("arenamaps")) {
            Config.CFG c = null;
            if (args[1].equals("align")) {
                c = Config.CFG.MODULES_ARENAMAPS_ALIGNTOPLAYER;
            }
            if (args[1].equals("lives")) {
                c = Config.CFG.MODULES_ARENAMAPS_SHOWLIVES;
            }
            if (args[1].equals("players")) {
                c = Config.CFG.MODULES_ARENAMAPS_SHOWPLAYERS;
            }
            if (args[1].equals("spawns")) {
                c = Config.CFG.MODULES_ARENAMAPS_SHOWSPAWNS;
            }
            if (c == null) {
                this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_ARGUMENT, (String)args[1], (String)"align | lives | players | spawns"));
                return;
            }
            boolean b = this.arena.getArenaConfig().getBoolean(c);
            this.arena.getArenaConfig().set(c, (Object)(!b ? 1 : 0));
            this.arena.getArenaConfig().save();
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.SET_DONE, (String)c.getNode(), (String)String.valueOf(!b)));
            return;
        }
    }

    public void displayInfo(CommandSender sender) {
        sender.sendMessage(String.valueOf(StringParser.colorVar((String)"playerAlign", (boolean)this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_ARENAMAPS_ALIGNTOPLAYER))) + "||" + StringParser.colorVar((String)"showLives", (boolean)this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_ARENAMAPS_SHOWLIVES)) + "||" + StringParser.colorVar((String)"showPlayers", (boolean)this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_ARENAMAPS_SHOWPLAYERS)) + "||" + StringParser.colorVar((String)"showSpawns", (boolean)this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_ARENAMAPS_SHOWSPAWNS)));
    }

    public HashSet<MapItem> getItems() {
        return this.items;
    }

    public void trySetup() {
        if (this.setup) {
            return;
        }
        Bukkit.getPluginManager().registerEvents((Listener)new MapListener(this), (Plugin)PVPArena.instance);
        this.setup = true;
    }

    public void parseJoin(CommandSender sender, ArenaTeam team) {
        this.trySetup();
        Player player = (Player)sender;
        HashSet<Object> maps = new HashSet();
        if (this.mappings.isEmpty()) {
            maps = new HashSet();
            this.prepareSpawnLocations();
        } else {
            maps = this.mappings;
        }
        maps.add(player.getName());
        this.items.add(new MapItem(this.arena, player, team.getColor()));
        this.mappings = maps;
    }

    private void prepareSpawnLocations() {
        if (!this.items.isEmpty()) {
            this.items.clear();
        }
        HashSet<MapItem> locations = new HashSet<MapItem>();
        for (ArenaTeam team : this.arena.getTeams()) {
            Set locs = SpawnManager.getSpawns((Arena)this.arena, (String)team.getName());
            for (PALocation loc : locs) {
                locations.add(new MapItem(this.arena, new PABlockLocation(loc.toLocation()), team.getColor()));
            }
            for (ArenaGoal goal : this.arena.getGoals()) {
                if (!(goal instanceof GoalFlags)) continue;
                locs = SpawnManager.getSpawns((Arena)this.arena, (String)(String.valueOf(team.getName()) + "flag"));
                for (PALocation loc : locs) {
                    locations.add(new MapItem(this.arena, new PABlockLocation(loc.toLocation()), team.getColor()));
                }
            }
        }
        this.items = locations;
    }

    public void reset(boolean force) {
        this.mappings.remove(this.arena);
    }

    public void parseRespawn(Player player, ArenaTeam team, EntityDamageEvent.DamageCause cause, Entity damager) {
        if (player == null) {
            return;
        }
        if (!this.arena.hasPlayer(player)) {
            return;
        }
        class RunLater
        implements Runnable {
            private final /* synthetic */ Player val$player;

            RunLater(Player player) {
                this.val$player = player;
            }

            @Override
            public void run() {
                Short value = MyRenderer.getId(this.val$player.getName());
                this.val$player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.MAP, 1, value.shortValue())});
                Maps.this.mappings.add(this.val$player.getName());
                if (value != Short.MIN_VALUE) {
                    MapView map = Bukkit.getMap((short)value);
                    MyRenderer mr = new MyRenderer(Maps.this);
                    map.addRenderer((MapRenderer)mr);
                }
            }
        }
        Bukkit.getScheduler().runTaskLater((Plugin)PVPArena.instance, (Runnable)new RunLater(player), 5L);
    }

    public void parseStart() {
        if (this.mappings.isEmpty()) {
            return;
        }
        for (String playerName : this.mappings) {
            Player player = Bukkit.getPlayerExact((String)playerName);
            if (player == null || !this.arena.hasPlayer(player)) continue;
            Short value = MyRenderer.getId(playerName);
            player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.MAP, 1, value.shortValue())});
            this.mappings.add(player.getName());
            if (value == Short.MIN_VALUE) continue;
            MapView map = Bukkit.getMap((short)value);
            MyRenderer mr = new MyRenderer(this);
            map.addRenderer((MapRenderer)mr);
        }
    }

    public boolean hasCustomMap(String sPlayer) {
        return this.mappings.contains(sPlayer);
    }
}

