/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.maps;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.arena.ArenaPlayer;
import net.slipcor.pvparena.arena.ArenaTeam;
import net.slipcor.pvparena.classes.PABlockLocation;
import net.slipcor.pvparena.classes.PACheck;
import net.slipcor.pvparena.core.Config;
import net.slipcor.pvparena.managers.SpawnManager;
import net.slipcor.pvparena.modules.maps.MapItem;
import net.slipcor.pvparena.modules.maps.Maps;
import org.bukkit.ChatColor;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapFont;
import org.bukkit.map.MapPalette;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.map.MinecraftFont;

public class MyRenderer
extends MapRenderer {
    static HashMap<ChatColor, Byte> colors = new HashMap();
    private String playerName = null;
    private Arena arena = null;
    private static YamlConfiguration playerMaps;
    private boolean showPlayers;
    private boolean showSpawns;
    private boolean showLives;
    private Maps maps;
    static HashSet<Short> done;
    private static final String[] RCODE;
    private static final int[] BVAL;

    static {
        colors.put(ChatColor.AQUA, MapPalette.matchColor((int)0, (int)255, (int)255));
        colors.put(ChatColor.BLACK, MapPalette.matchColor((int)0, (int)0, (int)0));
        colors.put(ChatColor.BLUE, MapPalette.matchColor((int)0, (int)0, (int)255));
        colors.put(ChatColor.DARK_AQUA, MapPalette.matchColor((int)0, (int)128, (int)128));
        colors.put(ChatColor.DARK_BLUE, MapPalette.matchColor((int)0, (int)0, (int)128));
        colors.put(ChatColor.DARK_GRAY, MapPalette.matchColor((int)128, (int)128, (int)128));
        colors.put(ChatColor.DARK_GREEN, MapPalette.matchColor((int)0, (int)128, (int)0));
        colors.put(ChatColor.DARK_PURPLE, MapPalette.matchColor((int)128, (int)0, (int)128));
        colors.put(ChatColor.DARK_RED, MapPalette.matchColor((int)128, (int)0, (int)0));
        colors.put(ChatColor.GOLD, MapPalette.matchColor((int)128, (int)128, (int)0));
        colors.put(ChatColor.GRAY, MapPalette.matchColor((int)192, (int)192, (int)192));
        colors.put(ChatColor.GREEN, MapPalette.matchColor((int)0, (int)255, (int)0));
        colors.put(ChatColor.LIGHT_PURPLE, MapPalette.matchColor((int)255, (int)0, (int)255));
        colors.put(ChatColor.RED, MapPalette.matchColor((int)255, (int)0, (int)0));
        colors.put(ChatColor.WHITE, MapPalette.matchColor((int)255, (int)255, (int)255));
        colors.put(ChatColor.YELLOW, MapPalette.matchColor((int)255, (int)255, (int)0));
        PVPArena.instance.getDataFolder().mkdir();
        File configFile = new File(PVPArena.instance.getDataFolder(), "maps.yml");
        if (!configFile.exists()) {
            try {
                configFile.createNewFile();
            }
            catch (Exception e) {
                PVPArena.instance.getLogger().severe("Error when creating map file.");
            }
        }
        playerMaps = new YamlConfiguration();
        try {
            playerMaps.load(configFile);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (InvalidConfigurationException e1) {
            e1.printStackTrace();
        }
        done = new HashSet();
        RCODE = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        BVAL = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    }

    public MyRenderer(Maps m) {
        this.maps = m;
    }

    private static void savePlayers() {
        try {
            playerMaps.save(new File(PVPArena.instance.getDataFolder(), "maps.yml"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void render(MapView map, MapCanvas canvas, Player player) {
        int mapZ;
        int mapX;
        byte outline;
        byte color;
        if (this.playerName == null) {
            if (this.maps.hasCustomMap(player.getName()) && !done.contains(map.getId())) {
                this.playerName = player.getName();
                this.arena = ArenaPlayer.parsePlayer((String)this.playerName).getArena();
                if (playerMaps.get(player.getName()) == null) {
                    playerMaps.set(player.getName(), (Object)map.getId());
                    MyRenderer.savePlayers();
                } else if (playerMaps.getInt(this.playerName) != map.getId()) {
                    return;
                }
                map.setScale(MapView.Scale.CLOSE);
                done.add(map.getId());
                this.showSpawns = this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_ARENAMAPS_SHOWSPAWNS);
                this.showPlayers = this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_ARENAMAPS_SHOWPLAYERS);
                this.showLives = this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_ARENAMAPS_SHOWLIVES);
            }
            return;
        }
        if (!player.getName().equals(this.playerName)) {
            return;
        }
        if (this.arena != null && this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_ARENAMAPS_ALIGNTOPLAYER)) {
            map.setCenterX(player.getLocation().getBlockX());
            map.setCenterZ(player.getLocation().getBlockZ());
        } else if (this.arena != null) {
            PABlockLocation loc = SpawnManager.getRegionCenter((Arena)this.arena);
            map.setCenterX(loc.getX());
            map.setCenterZ(loc.getZ());
        } else {
            PVPArena.instance.getLogger().severe("arena null");
        }
        int mapcenterx = map.getCenterX();
        int mapcenterz = map.getCenterZ();
        int x = 0;
        while (x < 128) {
            int z = 0;
            while (z < 128) {
                canvas.setPixel(x, z, (byte)-1);
                ++z;
            }
            ++x;
        }
        HashSet<MapItem> items = this.maps.getItems();
        if (this.showSpawns) {
            for (MapItem item : items) {
                if (item.isPlayer()) continue;
                outline = color = colors.get(item.getColor()).byteValue();
                mapX = (item.getX() - mapcenterx) / 2 + 64;
                mapZ = (item.getZ() - mapcenterz) / 2 + 64;
                if (mapX < 1 || mapX >= 127 || mapZ < 1 || mapZ >= 127) continue;
                canvas.setPixel(mapX, mapZ, color);
                canvas.setPixel(mapX - 1, mapZ - 1, outline);
                canvas.setPixel(mapX, mapZ - 1, outline);
                canvas.setPixel(mapX + 1, mapZ - 1, outline);
                canvas.setPixel(mapX - 1, mapZ, outline);
                canvas.setPixel(mapX + 1, mapZ, outline);
                canvas.setPixel(mapX - 1, mapZ + 1, outline);
                canvas.setPixel(mapX, mapZ + 1, outline);
                canvas.setPixel(mapX + 1, mapZ + 1, outline);
            }
        }
        if (this.showPlayers) {
            for (MapItem item : items) {
                if (!item.isPlayer()) continue;
                color = colors.get(item.getColor());
                outline = MapPalette.matchColor((int)0, (int)0, (int)0);
                mapX = (item.getX() - mapcenterx) / 2 + 64;
                mapZ = (item.getZ() - mapcenterz) / 2 + 64;
                if (mapX < 1 || mapX >= 127 || mapZ < 1 || mapZ >= 127) continue;
                canvas.setPixel(mapX, mapZ, color);
                if (item.getName().equals(this.playerName)) continue;
                canvas.setPixel(mapX - 1, mapZ - 1, outline);
                canvas.setPixel(mapX, mapZ - 1, outline);
                canvas.setPixel(mapX + 1, mapZ - 1, outline);
                canvas.setPixel(mapX - 1, mapZ, outline);
                canvas.setPixel(mapX + 1, mapZ, outline);
                canvas.setPixel(mapX - 1, mapZ + 1, outline);
                canvas.setPixel(mapX, mapZ + 1, outline);
                canvas.setPixel(mapX + 1, mapZ + 1, outline);
            }
        }
        if (!this.showLives) {
            return;
        }
        HashMap<String, Integer> lives = new HashMap<String, Integer>();
        for (ArenaTeam team : this.arena.getTeams()) {
            Iterator iterator;
            if (team.getName().equals("free") || !(iterator = team.getTeamMembers().iterator()).hasNext()) continue;
            ArenaPlayer ap = (ArenaPlayer)iterator.next();
            lives.put(team.getName(), PACheck.handleGetLives((Arena)ap.getArena(), (ArenaPlayer)ap));
        }
        String string = "";
        for (String s : lives.keySet()) {
            if (!string.equals("")) {
                string = String.valueOf(string) + " | ";
            }
            string = String.valueOf(string) + this.calculate(s, (Integer)lives.get(s));
        }
        try {
            canvas.drawText(0, 10, (MapFont)MinecraftFont.Font, string);
        }
        catch (Exception e) {
            canvas.drawText(0, 10, (MapFont)MinecraftFont.Font, "invalid team name");
        }
    }

    private String calculate(String s, Integer i) {
        return String.valueOf(s) + ": " + this.binaryToRoman(i);
    }

    /*
     * Unable to fully structure code
     */
    private String binaryToRoman(int binary) {
        roman = "";
        i = 0;
        ** GOTO lbl9
        {
            binary -= MyRenderer.BVAL[i];
            roman = String.valueOf(roman) + MyRenderer.RCODE[i];
            do {
                if (binary >= MyRenderer.BVAL[i]) continue block0;
                ++i;
lbl9:
                // 2 sources

            } while (i < MyRenderer.RCODE.length);
        }
        return roman;
    }

    public static Short getId(String sPlayer) {
        if (playerMaps.get(sPlayer) == null) {
            return (short)Short.MIN_VALUE;
        }
        return (short)playerMaps.getInt(sPlayer);
    }
}

