/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.factions;

import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.arena.ArenaPlayer;
import net.slipcor.pvparena.core.Debug;
import net.slipcor.pvparena.modules.factions.FactionsSupport;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Wolf;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class FactionsListener
implements Listener {
    private Debug debug = new Debug(66);
    private final FactionsSupport fs;

    public FactionsListener(FactionsSupport fs) {
        this.fs = fs;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Wolf wolf;
        if (!event.isCancelled()) {
            return;
        }
        Entity p1 = event.getDamager();
        Entity p2 = event.getEntity();
        this.debug.i("onEntityDamageByEntity: cause: " + event.getCause().name() + " : " + event.getDamager().toString() + " => " + event.getEntity().toString());
        if (p1 instanceof Projectile) {
            this.debug.i("parsing projectile");
            p1 = ((Projectile)p1).getShooter();
            this.debug.i("=> " + String.valueOf(p1));
        }
        if (event.getEntity() instanceof Wolf && (wolf = (Wolf)event.getEntity()).getOwner() != null) {
            try {
                p1 = (Entity)wolf.getOwner();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (p1 != null && p2 != null && p1 instanceof Player && p2 instanceof Player && PVPArena.instance.getConfig().getBoolean("onlyPVPinArena")) {
            event.setCancelled(true);
        }
        if (p2 == null || !(p2 instanceof Player)) {
            return;
        }
        Arena arena = ArenaPlayer.parsePlayer((String)((Player)p2).getName()).getArena();
        if (arena == null || !arena.equals(this.fs.getArena())) {
            return;
        }
        this.debug.i("onEntityDamageByEntity: fighting player");
        if (p1 == null || !(p1 instanceof Player)) {
            return;
        }
        this.debug.i("both entities are players");
        event.setCancelled(false);
    }
}

