/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.battlefieldguard;

import net.slipcor.pvparena.api.PVPArenaAPI;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.arena.ArenaPlayer;
import net.slipcor.pvparena.core.Config;
import net.slipcor.pvparena.core.Debug;
import net.slipcor.pvparena.managers.ArenaManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;

public class BattleRunnable
implements Runnable {
    private Debug debug = new Debug(42);

    public BattleRunnable() {
        this.debug.i("BattleRunnable constructor");
    }

    @Override
    public void run() {
        if (!Debug.override) {
            this.debug.i("BattleRunnable commiting");
        }
        try {
            Player[] playerArray = Bukkit.getServer().getOnlinePlayers();
            int n = playerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Player p = playerArray[n2];
                ArenaPlayer ap = ArenaPlayer.parsePlayer((String)p.getName());
                String name = PVPArenaAPI.getArenaNameByLocation((Location)p.getLocation());
                if (!p.hasPermission("pvparena.admin")) {
                    if (!Debug.override) {
                        this.debug.i("arena pos: " + String.valueOf(name), (CommandSender)p);
                        this.debug.i("arena IN : " + String.valueOf(ap.getArena()), (CommandSender)p);
                    }
                    if (!(name == null || name.equals("") || ap.getArena() != null && ap.getArena().getName().equals(name))) {
                        if (ap.getArena() != null) {
                            if (ap.getArena().getArenaConfig().getBoolean(Config.CFG.MODULES_BATTLEFIELDGUARD_ENTERDEATH)) {
                                ap.get().setLastDamageCause(new EntityDamageEvent((Entity)ap.get(), EntityDamageEvent.DamageCause.CUSTOM, 1000));
                                ap.get().setHealth(0);
                                ap.get().damage(1000);
                            } else {
                                ap.getArena().playerLeave(p, Config.CFG.TP_EXIT, false);
                            }
                        } else {
                            Arena a = ArenaManager.getArenaByName((String)name);
                            if (a.getArenaConfig().getBoolean(Config.CFG.MODULES_BATTLEFIELDGUARD_ENTERDEATH)) {
                                p.setLastDamageCause(new EntityDamageEvent((Entity)p, EntityDamageEvent.DamageCause.CUSTOM, 1000));
                                p.setHealth(0);
                                p.damage(1000);
                            } else {
                                a.tpPlayerToCoordName(p, "exit");
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

