/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.betterfight;

import java.util.HashMap;
import java.util.Map;
import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.arena.ArenaPlayer;
import net.slipcor.pvparena.arena.ArenaTeam;
import net.slipcor.pvparena.commands.AbstractArenaCommand;
import net.slipcor.pvparena.core.Config;
import net.slipcor.pvparena.core.Language;
import net.slipcor.pvparena.core.StringParser;
import net.slipcor.pvparena.loadables.ArenaModule;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;

public class BetterFight
extends ArenaModule {
    Map<String, Integer> killMap = null;

    public BetterFight() {
        super("BetterFight");
    }

    public String version() {
        return "v1.0.1.59";
    }

    public boolean checkCommand(String s) {
        return s.equals("!bf") || s.equals("betterfight");
    }

    public void commitCommand(CommandSender sender, String[] args) {
        if (!PVPArena.hasAdminPerms((CommandSender)sender) && !PVPArena.hasCreatePerms((CommandSender)sender, (Arena)this.arena)) {
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM, (String)Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM_X_ADMIN)));
            return;
        }
        if (args[0].equals("!bf") || args[0].equals("betterfight")) {
            if (args.length == 2) {
                if (args[1].equals("reset")) {
                    boolean b = this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_BETTERFIGHT_RESETKILLSTREAKONDEATH);
                    this.arena.getArenaConfig().set(Config.CFG.MODULES_BETTERFIGHT_RESETKILLSTREAKONDEATH, (Object)(!b ? 1 : 0));
                    this.arena.getArenaConfig().save();
                    this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.SET_DONE, (String)Config.CFG.MODULES_BETTERFIGHT_RESETKILLSTREAKONDEATH.getNode(), (String)String.valueOf(!b)));
                    return;
                }
                if (args[1].equals("explode")) {
                    boolean b = this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_BETTERFIGHT_EXPLODEONDEATH);
                    this.arena.getArenaConfig().set(Config.CFG.MODULES_BETTERFIGHT_EXPLODEONDEATH, (Object)(!b ? 1 : 0));
                    this.arena.getArenaConfig().save();
                    this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.SET_DONE, (String)Config.CFG.MODULES_BETTERFIGHT_EXPLODEONDEATH.getNode(), (String)String.valueOf(!b)));
                    return;
                }
                this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_ARGUMENT, (String)args[1], (String)"reset | explode"));
                return;
            }
            if (args[1].equals("items")) {
                if (!AbstractArenaCommand.argCountValid((CommandSender)sender, (Arena)this.arena, (String[])args, (Integer[])new Integer[]{3})) {
                    return;
                }
                this.arena.getArenaConfig().set(Config.CFG.MODULES_BETTERFIGHT_ONEHITITEMS, (Object)args[2]);
                this.arena.getArenaConfig().save();
                this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.SET_DONE, (String)Config.CFG.MODULES_BETTERFIGHT_ONEHITITEMS.getNode(), (String)args[2]));
                return;
            }
            if (args[1].equals("messages")) {
                int i = 0;
                try {
                    i = Integer.parseInt(args[2]);
                }
                catch (Exception e) {
                    this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_NOT_NUMERIC, (String)args[2]));
                    return;
                }
                String value = StringParser.joinArray((Object[])StringParser.shiftArrayBy((String[])args, (int)2), (String)" ");
                this.arena.getArenaConfig().setManually("betterfight.messages.m" + i, (Object)value);
                this.arena.getArenaConfig().save();
                this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.SET_DONE, (String)("betterfight.messages.m" + i), (String)value));
                return;
            }
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_ARGUMENT, (String)args[1], (String)"reset | items | messages | explode"));
            return;
        }
    }

    public void configParse(YamlConfiguration config) {
        if (this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_BETTERFIGHT_MESSAGES)) {
            config.addDefault("betterfight.messages.m1", (Object)"First Kill!");
            config.addDefault("betterfight.messages.m2", (Object)"Double Kill!");
            config.addDefault("betterfight.messages.m3", (Object)"Triple Kill!");
            config.addDefault("betterfight.messages.m4", (Object)"Quadra Kill!");
            config.addDefault("betterfight.messages.m5", (Object)"Super Kill!");
            config.addDefault("betterfight.messages.m6", (Object)"Ultra Kill!");
            config.addDefault("betterfight.messages.m7", (Object)"Godlike!");
            config.addDefault("betterfight.messages.m8", (Object)"Monster!");
        }
        config.addDefault("betterfight.sounds.arrow", (Object)"none");
        config.addDefault("betterfight.sounds.egg", (Object)"none");
        config.addDefault("betterfight.sounds.snow", (Object)"none");
        config.addDefault("betterfight.sounds.fireball", (Object)"none");
        config.options().copyDefaults(true);
    }

    public void displayInfo(CommandSender sender) {
        sender.sendMessage("one-hit items: " + this.arena.getArenaConfig().getString(Config.CFG.MODULES_BETTERFIGHT_ONEHITITEMS));
        sender.sendMessage(String.valueOf(StringParser.colorVar((String)"explode", (boolean)this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_BETTERFIGHT_EXPLODEONDEATH))) + " | " + StringParser.colorVar((String)"messages", (boolean)this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_BETTERFIGHT_MESSAGES)) + " | " + StringParser.colorVar((String)"reset on death", (boolean)this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_BETTERFIGHT_RESETKILLSTREAKONDEATH)));
    }

    private Map<String, Integer> getKills() {
        if (this.killMap == null) {
            this.killMap = new HashMap<String, Integer>();
        }
        return this.killMap;
    }

    public void onEntityDamageByEntity(Player attacker, Player defender, EntityDamageByEntityEvent event) {
        String s = this.arena.getArenaConfig().getString(Config.CFG.MODULES_BETTERFIGHT_ONEHITITEMS);
        if (s.equalsIgnoreCase("none")) {
            return;
        }
        if (event.getDamager() instanceof Projectile) {
            if (event.getDamager() instanceof Snowball) {
                this.handle(event, "snow");
                if (s.toLowerCase().contains("snow")) {
                    event.setDamage(1000);
                }
            }
            if (event.getDamager() instanceof Arrow) {
                this.handle(event, "arrow");
                if (s.toLowerCase().contains("arrow")) {
                    event.setDamage(1000);
                }
            }
            if (event.getDamager() instanceof Fireball) {
                this.handle(event, "fireball");
                if (s.toLowerCase().contains("fireball")) {
                    event.setDamage(1000);
                }
            }
            if (event.getDamager() instanceof Egg) {
                this.handle(event, "egg");
                if (s.toLowerCase().contains("egg")) {
                    event.setDamage(1000);
                }
            }
        }
    }

    private void handle(EntityDamageByEntityEvent event, String string) {
        if (((Projectile)event.getDamager()).getShooter() instanceof Player) {
            Player shooter = (Player)((Projectile)event.getDamager()).getShooter();
            float volume = 1.0f;
            float pitch = 1.0f;
            String node = "betterfight.sounds." + string;
            String value = (String)this.arena.getArenaConfig().getUnsafe(node);
            if (value.equals("none")) {
                return;
            }
            try {
                Sound sound = Sound.valueOf((String)value.toUpperCase());
                shooter.playSound(shooter.getLocation(), sound, volume, pitch);
                if (event.getEntity() instanceof Player) {
                    Player damagee = (Player)event.getEntity();
                    damagee.playSound(shooter.getLocation(), sound, volume, pitch);
                }
            }
            catch (Exception e) {
                PVPArena.instance.getLogger().warning("Node " + node + " is not a valid sound in arena " + this.arena.getName());
            }
        }
    }

    public void parsePlayerDeath(Player player, EntityDamageEvent cause) {
        Player p = ArenaPlayer.getLastDamagingPlayer((Event)cause);
        if (this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_BETTERFIGHT_RESETKILLSTREAKONDEATH)) {
            this.getKills().put(player.getName(), 0);
        }
        if (this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_BETTERFIGHT_EXPLODEONDEATH)) {
            class RunLater
            implements Runnable {
                final Location l;

                public RunLater(Location loc) {
                    this.l = loc;
                }

                @Override
                public void run() {
                    this.l.getWorld().createExplosion(this.l.getX(), this.l.getY(), this.l.getZ(), 2.0f);
                }
            }
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)PVPArena.instance, (Runnable)new RunLater(player.getLocation().clone()), 2L);
        }
        if (p == null || this.getKills().get(p.getName()) == null) {
            return;
        }
        int killcount = this.getKills().get(p.getName());
        this.getKills().put(p.getName(), ++killcount);
        if (!this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_BETTERFIGHT_MESSAGES)) {
            return;
        }
        String msg = (String)this.arena.getArenaConfig().getUnsafe("betterfight.messages.m" + killcount);
        if (msg == null || msg.equals("")) {
            return;
        }
        this.arena.broadcast(msg);
    }

    public void parseStart() {
        for (ArenaTeam team : this.arena.getTeams()) {
            for (ArenaPlayer ap : team.getTeamMembers()) {
                this.getKills().put(ap.getName(), 0);
            }
        }
    }

    public void reset(boolean force) {
        this.getKills().clear();
    }
}

