/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.powerups;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.arena.ArenaPlayer;
import net.slipcor.pvparena.arena.ArenaTeam;
import net.slipcor.pvparena.classes.PACheck;
import net.slipcor.pvparena.core.Config;
import net.slipcor.pvparena.core.Debug;
import net.slipcor.pvparena.core.Language;
import net.slipcor.pvparena.listeners.EntityListener;
import net.slipcor.pvparena.loadables.ArenaModuleManager;
import net.slipcor.pvparena.managers.ArenaManager;
import net.slipcor.pvparena.managers.StatisticsManager;
import net.slipcor.pvparena.modules.powerups.PowerupType;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PowerupEffect {
    protected boolean active = false;
    protected int uses = -1;
    protected int duration = -1;
    protected PowerupType type = null;
    protected String mobtype = null;
    private double factor = 1.0;
    private double chance = 1.0;
    private int diff = 0;
    private List<String> items = new ArrayList<String>();
    private static Debug debug = new Debug(17);
    private PotionEffect potEff = null;

    public PowerupEffect(String eClass, HashMap<String, Object> puEffectVals, PotionEffect effect) {
        debug.i("adding effect " + eClass);
        this.type = PowerupEffect.parseClass(eClass);
        this.potEff = effect;
        debug.i("effect class is " + this.type.toString());
        for (String evName : puEffectVals.keySet()) {
            if (evName.equals("uses")) {
                this.uses = (Integer)puEffectVals.get(evName);
                debug.i("uses :" + String.valueOf(this.uses));
                continue;
            }
            if (evName.equals("duration")) {
                this.duration = (Integer)puEffectVals.get(evName);
                debug.i("duration: " + String.valueOf(this.duration));
                continue;
            }
            if (evName.equals("factor")) {
                this.factor = (Double)puEffectVals.get(evName);
                debug.i("factor: " + String.valueOf(this.factor));
                continue;
            }
            if (evName.equals("chance")) {
                this.chance = (Double)puEffectVals.get(evName);
                debug.i("chance: " + String.valueOf(this.chance));
                continue;
            }
            if (evName.equals("diff")) {
                this.diff = (Integer)puEffectVals.get(evName);
                debug.i("diff: " + String.valueOf(this.diff));
                continue;
            }
            if (evName.equals("items")) {
                this.items.add((String)puEffectVals.get(evName));
                debug.i("items: " + this.items.toString());
                continue;
            }
            if (evName.equals("type")) {
                this.mobtype = (String)puEffectVals.get(evName);
                debug.i("type: " + this.type.name());
                continue;
            }
            PVPArena.instance.getLogger().warning("undefined effect class value: " + evName);
        }
    }

    public static PowerupType parseClass(String s) {
        PowerupType[] powerupTypeArray = PowerupType.values();
        int n = powerupTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PowerupType c = powerupTypeArray[n2];
            if (c.name().equalsIgnoreCase(s)) {
                return c;
            }
            if (s.toUpperCase().startsWith("POTION.")) {
                return PowerupType.POTEFF;
            }
            ++n2;
        }
        return null;
    }

    public void init(Player player) {
        if (this.uses == 0) {
            return;
        }
        if (this.uses > 0) {
            this.active = true;
            --this.uses;
        } else {
            this.active = true;
        }
        debug.i("initiating - " + this.type.name(), (CommandSender)player);
        if (this.duration == 0) {
            this.active = false;
        }
        if (this.type.isActivatedOnPickup()) {
            this.commit(player);
        }
        if (this.potEff != null) {
            player.addPotionEffect(this.potEff);
        }
    }

    public void removeEffect(Player player) {
        if (this.potEff != null) {
            player.addPotionEffect(new PotionEffect(this.potEff.getType(), 0, 0));
        }
    }

    public void commit(Player attacker, Player defender, EntityDamageByEntityEvent event) {
        debug.i("committing entitydamagebyentityevent: " + this.type.name(), (CommandSender)attacker);
        if (this.type == PowerupType.DMG_RECEIVE) {
            Random r = new Random();
            Float v = Float.valueOf(r.nextFloat());
            debug.i("random r = " + v, (CommandSender)defender);
            if ((double)v.floatValue() <= this.chance) {
                event.setDamage((int)Math.round((double)event.getDamage() * this.factor));
            }
        } else if (this.type == PowerupType.DMG_CAUSE) {
            Random r = new Random();
            Float v = Float.valueOf(r.nextFloat());
            debug.i("random r = " + v, (CommandSender)attacker);
            if ((double)v.floatValue() <= this.chance) {
                event.setDamage((int)Math.round((double)event.getDamage() * this.factor));
            }
        } else if (this.type == PowerupType.DMG_REFLECT) {
            if (attacker == null) {
                return;
            }
            Random r = new Random();
            Float v = Float.valueOf(r.nextFloat());
            debug.i("random r = " + v, (CommandSender)attacker);
            debug.i("random r = " + v, (CommandSender)defender);
            if ((double)v.floatValue() <= this.chance) {
                EntityDamageByEntityEvent reflectEvent = new EntityDamageByEntityEvent((Entity)defender, (Entity)attacker, event.getCause(), (int)Math.round((double)event.getDamage() * this.factor));
                new EntityListener().onEntityDamageByEntity(reflectEvent);
            }
        } else if (this.type == PowerupType.IGNITE) {
            Random r = new Random();
            Float v = Float.valueOf(r.nextFloat());
            debug.i("random r = " + v, (CommandSender)defender);
            if ((double)v.floatValue() <= this.chance) {
                defender.setFireTicks(20);
            }
        } else {
            PVPArena.instance.getLogger().warning("unexpected fight powerup effect: " + this.type.name());
        }
    }

    public boolean commit(Player player) {
        debug.i("committing " + this.type.name(), (CommandSender)player);
        Random r = new Random();
        if ((double)r.nextFloat() <= this.chance) {
            if (this.type == PowerupType.HEALTH) {
                if (this.diff > 0) {
                    player.setHealth(player.getHealth() + this.diff);
                } else {
                    player.setHealth((int)Math.round((double)player.getHealth() * this.factor));
                }
                return true;
            }
            if (this.type == PowerupType.LIVES) {
                ArenaPlayer ap = ArenaPlayer.parsePlayer((String)player.getName());
                int lives = PACheck.handleGetLives((Arena)ap.getArena(), (ArenaPlayer)ap);
                if (lives + this.diff > 0) {
                    PVPArena.instance.getAgm().setPlayerLives(ap.getArena(), ap, lives + this.diff);
                } else {
                    ArenaTeam team = ap.getArenaTeam();
                    Arena arena = ap.getArena();
                    ArenaModuleManager.announce((Arena)arena, (String)Language.parse((Language.MSG)Language.MSG.FIGHT_KILLED_BY, (String)player.getName(), (String)arena.parseDeathCause(player, EntityDamageEvent.DamageCause.MAGIC, (Entity)player)), (String)"LOSER");
                    if (arena.getArenaConfig().getBoolean(Config.CFG.USES_DEATHMESSAGES)) {
                        arena.broadcast(Language.parse((Language.MSG)Language.MSG.FIGHT_KILLED_BY, (String)(String.valueOf(team.colorizePlayer(player)) + ChatColor.YELLOW), (String)arena.parseDeathCause(player, EntityDamageEvent.DamageCause.MAGIC, (Entity)player)));
                    }
                    ap.getStatistics(arena).incStat(StatisticsManager.type.LOSSES);
                    arena.removePlayer(player, "lose", true, false);
                    ap.getArenaTeam().remove(ap);
                    ArenaManager.checkAndCommit((Arena)arena, (boolean)false);
                }
                return true;
            }
            if (this.type == PowerupType.PORTAL) {
                return true;
            }
            if (this.type == PowerupType.REPAIR) {
                for (String i : this.items) {
                    ItemStack is = null;
                    if (i.contains("HELM")) {
                        is = player.getInventory().getHelmet();
                    } else if (i.contains("CHEST") || i.contains("PLATE")) {
                        is = player.getInventory().getChestplate();
                    } else if (i.contains("LEGGINS")) {
                        is = player.getInventory().getLeggings();
                    } else if (i.contains("BOOTS")) {
                        is = player.getInventory().getBoots();
                    } else if (i.contains("SWORD")) {
                        is = player.getItemInHand();
                    }
                    if (is == null || this.diff <= 0) continue;
                    if (is.getDurability() + this.diff > 127) {
                        is.setDurability((short)127);
                        continue;
                    }
                    is.setDurability((short)(is.getDurability() + this.diff));
                }
                return true;
            }
            if (this.type == PowerupType.SPAWN_MOB) {
                return true;
            }
            if (this.type == PowerupType.SPRINT) {
                player.setSprinting(true);
                return true;
            }
        }
        PVPArena.instance.getLogger().warning("unexpected " + this.type.name());
        return false;
    }

    public void commit(EntityRegainHealthEvent event) {
        debug.i("committing entityregainhealthevent " + this.type.name(), (CommandSender)((Player)event.getEntity()));
        if (this.type == PowerupType.HEAL) {
            Random r = new Random();
            if ((double)r.nextFloat() <= this.chance) {
                event.setAmount((int)Math.round((double)event.getAmount() * this.factor));
                ((Player)event.getEntity()).setSaturation(20.0f);
                ((Player)event.getEntity()).setFoodLevel(20);
            }
        } else {
            PVPArena.instance.getLogger().warning("unexpected fight heal effect: " + this.type.name());
        }
    }

    public void commit(PlayerVelocityEvent event) {
        debug.i("committing velocityevent " + this.type.name(), (CommandSender)event.getPlayer());
        if (this.type == PowerupType.HEAL) {
            Random r = new Random();
            if ((double)r.nextFloat() <= this.chance) {
                event.setVelocity(event.getVelocity().multiply(this.factor));
            }
        } else {
            PVPArena.instance.getLogger().warning("unexpected jump effect: " + this.type.name());
        }
    }

    public static PotionEffect parsePotionEffect(String eClass) {
        eClass = eClass.replace("POTION.", "");
        int duration = 1;
        int amplifyer = 1;
        if (eClass.contains(":")) {
            String[] s = eClass.split(":");
            eClass = s[0];
            try {
                duration = Integer.parseInt(s[1]);
            }
            catch (Exception e) {
                Arena.pmsg((CommandSender)Bukkit.getConsoleSender(), (String)Language.parse((Language.MSG)Language.MSG.MODULE_POWERUPS_INVALIDPUEFF, (String)eClass));
            }
            if (s.length > 2) {
                try {
                    amplifyer = Integer.parseInt(s[2]);
                }
                catch (Exception e) {
                    Arena.pmsg((CommandSender)Bukkit.getConsoleSender(), (String)Language.parse((Language.MSG)Language.MSG.MODULE_POWERUPS_INVALIDPUEFF, (String)eClass));
                }
            }
        }
        PotionEffectType[] potionEffectTypeArray = PotionEffectType.values();
        int n = potionEffectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PotionEffectType pet = potionEffectTypeArray[n2];
            if (pet != null) {
                debug.i("parsing PET " + pet.toString());
                if (pet.getName() != null) {
                    debug.i("parsing PET " + pet.toString());
                    if (pet.getName().equals(eClass)) {
                        return new PotionEffect(pet, duration, amplifyer);
                    }
                }
            }
            ++n2;
        }
        return null;
    }
}

