/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.respawnrelay;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.slipcor.pvparena.arena.ArenaPlayer;
import net.slipcor.pvparena.core.Config;
import net.slipcor.pvparena.loadables.ArenaModule;
import net.slipcor.pvparena.modules.respawnrelay.RelayRunnable;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;

public class RespawnRelay
extends ArenaModule {
    protected Map<String, BukkitRunnable> runnerMap;

    public RespawnRelay() {
        super("RespawnRelay");
    }

    public String version() {
        return "v1.0.1.60";
    }

    public String checkForMissingSpawns(Set<String> list) {
        return list.contains("relay") ? null : "relay not set";
    }

    public void displayInfo(CommandSender sender) {
        sender.sendMessage("seconds: " + this.arena.getArenaConfig().getInt(Config.CFG.MODULES_RESPAWNRELAY_INTERVAL));
    }

    protected Map<String, BukkitRunnable> getRunnerMap() {
        if (this.runnerMap == null) {
            this.runnerMap = new HashMap<String, BukkitRunnable>();
        }
        return this.runnerMap;
    }

    public boolean hasSpawn(String s) {
        return s.equals("relay");
    }

    public void reset(boolean force) {
        for (BukkitRunnable br : this.getRunnerMap().values()) {
            br.cancel();
        }
        this.getRunnerMap().clear();
    }

    public boolean tryDeathOverride(ArenaPlayer ap, List<ItemStack> drops) {
        ap.setStatus(ArenaPlayer.Status.DEAD);
        if (drops == null) {
            drops = new ArrayList<ItemStack>();
        }
        this.arena.tpPlayerToCoordName(ap.get(), "relay");
        this.arena.unKillPlayer(ap.get(), ap.get().getLastDamageCause() == null ? null : ap.get().getLastDamageCause().getCause(), (Entity)ap.get().getKiller());
        if (this.getRunnerMap().containsKey(ap.getName())) {
            return true;
        }
        this.getRunnerMap().put(ap.getName(), (BukkitRunnable)new RelayRunnable(this, this.arena, ap, drops));
        return true;
    }
}

