/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.powerups;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.arena.ArenaPlayer;
import net.slipcor.pvparena.arena.ArenaTeam;
import net.slipcor.pvparena.classes.PABlockLocation;
import net.slipcor.pvparena.commands.AbstractArenaCommand;
import net.slipcor.pvparena.core.Config;
import net.slipcor.pvparena.core.Debug;
import net.slipcor.pvparena.core.Language;
import net.slipcor.pvparena.core.StringParser;
import net.slipcor.pvparena.loadables.ArenaModule;
import net.slipcor.pvparena.loadables.ArenaRegionShape;
import net.slipcor.pvparena.managers.SpawnManager;
import net.slipcor.pvparena.modules.powerups.Powerup;
import net.slipcor.pvparena.modules.powerups.PowerupRunnable;
import net.slipcor.pvparena.modules.powerups.PowerupType;
import net.slipcor.pvparena.modules.powerups.Powerups;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PowerupManager
extends ArenaModule
implements Listener {
    protected Powerups usesPowerups = null;
    private int powerupDiff = 0;
    private int powerupDiffI = 0;
    protected int SPAWN_ID = -1;
    private boolean setup = false;

    public PowerupManager() {
        super("PowerUps");
        debug = new Debug(402);
    }

    public String version() {
        return "v1.0.1.59";
    }

    protected void calcPowerupSpawn() {
        debug.i("powerups?");
        if (this.usesPowerups == null) {
            return;
        }
        if (this.usesPowerups.puTotal.size() <= 0) {
            return;
        }
        debug.i("totals are filled");
        Random r = new Random();
        int i = r.nextInt(this.usesPowerups.puTotal.size());
        for (Powerup p : this.usesPowerups.puTotal) {
            if (--i > 0) continue;
            this.commitPowerupItemSpawn(p.item);
            this.arena.broadcast(Language.parse((Language.MSG)Language.MSG.MODULE_POWERUPS_SERVER, (String)p.name));
            return;
        }
    }

    public boolean checkCommand(String s) {
        return s.equals("!pu") || s.startsWith("powerup");
    }

    public void commitCommand(CommandSender sender, String[] args) {
        if (!PVPArena.hasAdminPerms((CommandSender)sender) && !PVPArena.hasCreatePerms((CommandSender)sender, (Arena)this.arena)) {
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM, (String)Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM_X_ADMIN)));
            return;
        }
        if (!AbstractArenaCommand.argCountValid((CommandSender)sender, (Arena)this.arena, (String[])args, (Integer[])new Integer[]{2, 3})) {
            return;
        }
        if (args[0].equals("!pu") || args[0].startsWith("powerup")) {
            if (args.length == 2) {
                if (args[1].equals("off")) {
                    this.arena.getArenaConfig().set(Config.CFG.MODULES_POWERUPS_USAGE, (Object)args[1]);
                    this.arena.getArenaConfig().save();
                    this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.SET_DONE, (String)Config.CFG.MODULES_POWERUPS_USAGE.getNode(), (String)args[1]));
                    return;
                }
                if (args[1].equals("dropspawn")) {
                    boolean b = this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_POWERUPS_DROPSPAWN);
                    this.arena.getArenaConfig().set(Config.CFG.MODULES_POWERUPS_DROPSPAWN, (Object)(!b ? 1 : 0));
                    this.arena.getArenaConfig().save();
                    this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.SET_DONE, (String)Config.CFG.MODULES_POWERUPS_DROPSPAWN.getNode(), (String)String.valueOf(!b)));
                }
                this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_ARGUMENT, (String)args[1], (String)"off | dropspawn"));
                return;
            }
            int i = 0;
            try {
                i = Integer.parseInt(args[2]);
            }
            catch (Exception e) {
                this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_NOT_NUMERIC, (String)args[2]));
                return;
            }
            if (args[1].equals("time") || args[1].equals("death")) {
                this.arena.getArenaConfig().set(Config.CFG.MODULES_POWERUPS_USAGE, (Object)(String.valueOf(args[1]) + ":" + i));
                this.arena.getArenaConfig().save();
                this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.SET_DONE, (String)Config.CFG.MODULES_POWERUPS_USAGE.getNode(), (String)(String.valueOf(args[1]) + ":" + i)));
                return;
            }
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_ARGUMENT, (String)args[1], (String)"time | death"));
            return;
        }
    }

    public boolean commitEnd(ArenaTeam arg1) {
        if (this.usesPowerups != null && this.arena.getArenaConfig().getString(Config.CFG.MODULES_POWERUPS_USAGE).startsWith("death")) {
            debug.i("calculating powerup trigger death");
            ++this.powerupDiffI;
            this.powerupDiffI %= this.powerupDiff;
            if (this.powerupDiffI == 0) {
                this.calcPowerupSpawn();
            }
        }
        return false;
    }

    protected void commitPowerupItemSpawn(Material item) {
        debug.i("dropping item?");
        if (this.arena.getArenaConfig().getBoolean(Config.CFG.MODULES_POWERUPS_DROPSPAWN)) {
            this.dropItemOnSpawn(item);
        } else {
            Set ars = this.arena.getRegionsByType(ArenaRegionShape.RegionType.BATTLE);
            Iterator iterator = ars.iterator();
            if (iterator.hasNext()) {
                ArenaRegionShape ar = (ArenaRegionShape)iterator.next();
                PABlockLocation min = ar.getMinimumLocation();
                PABlockLocation max = ar.getMaximumLocation();
                Random r = new Random();
                int x = r.nextInt(max.getX() - min.getX());
                int z = r.nextInt(max.getZ() - min.getZ());
                World w = Bukkit.getWorld((String)min.getWorldName());
                w.dropItem(w.getHighestBlockAt(min.getX() + x, min.getZ() + z).getRelative(BlockFace.UP).getLocation(), new ItemStack(item, 1));
            }
        }
    }

    public void configParse(YamlConfiguration config) {
        if (!this.setup) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)PVPArena.instance);
            this.setup = true;
        }
        HashMap<String, Object> powerups = new HashMap<String, Object>();
        if (config.getConfigurationSection("powerups") != null) {
            HashMap map = (HashMap)config.getConfigurationSection("powerups").getValues(false);
            HashMap map2 = new HashMap();
            HashMap map3 = new HashMap();
            debug.i("parsing powerups");
            for (String key : map.keySet()) {
                map2 = (HashMap)config.getConfigurationSection("powerups." + key).getValues(false);
                HashMap<String, Object> temp_map = new HashMap<String, Object>();
                for (String kkey : map2.keySet()) {
                    if (kkey.equals("item")) {
                        temp_map.put(kkey, String.valueOf(map2.get(kkey)));
                        debug.i(String.valueOf(key) + " => " + kkey + " => " + String.valueOf(map2.get(kkey)));
                        continue;
                    }
                    debug.i(String.valueOf(key) + " => " + kkey + " => " + this.parseList(map3.values()));
                    map3 = (HashMap)config.getConfigurationSection("powerups." + key + "." + kkey).getValues(false);
                    temp_map.put(kkey, map3);
                }
                powerups.put(key, temp_map);
            }
        }
        if (powerups.size() < 1) {
            return;
        }
        String pu = this.arena.getArenaConfig().getString(Config.CFG.MODULES_POWERUPS_USAGE, "off");
        String[] ss = pu.split(":");
        if (pu.startsWith("death")) {
            this.powerupDiff = Integer.parseInt(ss[1]);
            this.usesPowerups = new Powerups(powerups);
        } else if (pu.startsWith("time")) {
            this.powerupDiff = Integer.parseInt(ss[1]);
            this.usesPowerups = new Powerups(powerups);
        } else {
            PVPArena.instance.getLogger().warning("error activating powerup module");
        }
        config.options().copyDefaults(true);
    }

    public void displayInfo(CommandSender player) {
        player.sendMessage("usage: " + StringParser.colorVar((this.usesPowerups != null ? 1 : 0) != 0) + "(" + StringParser.colorVar((String)this.arena.getArenaConfig().getString(Config.CFG.MODULES_POWERUPS_USAGE)) + ")");
    }

    protected void dropItemOnSpawn(Material item) {
        debug.i("calculating item spawn location");
        Location aim = SpawnManager.getCoords((Arena)this.arena, (String)"powerup").add(0.0, 1.0, 0.0).toLocation();
        debug.i("dropping item on spawn: " + aim.toString());
        Bukkit.getWorld((String)this.arena.getWorld()).dropItem(aim, new ItemStack(item, 1));
    }

    public boolean hasSpawn(String s) {
        return s.toLowerCase().startsWith("powerup");
    }

    public void onEntityDamageByEntity(Player attacker, Player defender, EntityDamageByEntityEvent event) {
        if (this.usesPowerups != null) {
            debug.i("committing powerup triggers", (CommandSender)attacker);
            debug.i("committing powerup triggers", (CommandSender)defender);
            Powerup p = this.usesPowerups.puActive.get(attacker);
            if (p != null && p.canBeTriggered()) {
                p.commit(attacker, defender, event);
            }
            if ((p = this.usesPowerups.puActive.get(defender)) != null && p.canBeTriggered()) {
                p.commit(attacker, defender, event);
            }
        }
    }

    public void onEntityRegainHealth(EntityRegainHealthEvent event) {
        if (this.usesPowerups != null) {
            debug.i("regaining health");
            Powerup p = this.usesPowerups.puActive.get((Player)event.getEntity());
            if (p != null && p.canBeTriggered() && p.isEffectActive(PowerupType.HEAL)) {
                event.setCancelled(true);
                p.commit(event);
            }
        }
    }

    @EventHandler
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        Player player = event.getPlayer();
        ArenaPlayer ap = ArenaPlayer.parsePlayer((String)player.getName());
        if (!this.arena.equals(ap.getArena())) {
            return;
        }
        if (this.usesPowerups != null) {
            debug.i("onPlayerPickupItem: fighting player", (CommandSender)player);
            debug.i("item: " + event.getItem().getItemStack().getType(), (CommandSender)player);
            for (Powerup p : this.usesPowerups.puTotal) {
                debug.i("is it " + p.item + "?", (CommandSender)player);
                if (!event.getItem().getItemStack().getType().equals((Object)p.item)) continue;
                debug.i("yes!", (CommandSender)player);
                Powerup newP = new Powerup(p);
                if (this.usesPowerups.puActive.containsKey(player)) {
                    this.usesPowerups.puActive.remove(player);
                }
                this.usesPowerups.puActive.put(player, newP);
                this.arena.broadcast(Language.parse((Language.MSG)Language.MSG.MODULE_POWERUPS_PLAYER, (String)player.getName(), (String)newP.name));
                event.setCancelled(true);
                event.getItem().remove();
                if (newP.canBeTriggered()) {
                    newP.activate(player);
                }
                return;
            }
        }
    }

    public void onPlayerVelocity(PlayerVelocityEvent event) {
        Powerup p;
        debug.i("inPlayerVelocity: fighting player", (CommandSender)event.getPlayer());
        if (this.usesPowerups != null && (p = this.usesPowerups.puActive.get(event.getPlayer())) != null && p.canBeTriggered() && p.isEffectActive(PowerupType.JUMP)) {
            p.commit(event);
        }
    }

    protected String parseList(Collection<Object> values) {
        String s = "";
        for (Object o : values) {
            if (!s.equals("")) {
                s = String.valueOf(s) + ",";
            }
            try {
                s = String.valueOf(s) + String.valueOf(o);
                debug.i("a");
            }
            catch (Exception e) {
                debug.i("b");
                s = String.valueOf(s) + o.toString();
            }
        }
        return s;
    }

    @EventHandler
    public void parseMove(PlayerMoveEvent event) {
        Powerup p;
        if (this.usesPowerups != null && (p = this.usesPowerups.puActive.get(event.getPlayer())) != null && p.canBeTriggered()) {
            if (p.isEffectActive(PowerupType.FREEZE)) {
                debug.i("freeze in effect, cancelling!", (CommandSender)event.getPlayer());
                event.setCancelled(true);
            }
            if (p.isEffectActive(PowerupType.SPRINT)) {
                debug.i("sprint in effect, sprinting!", (CommandSender)event.getPlayer());
                event.getPlayer().setSprinting(true);
            }
            p.isEffectActive(PowerupType.SLIP);
        }
    }

    protected void powerupTick() {
        if (this.usesPowerups != null) {
            this.usesPowerups.tick();
        }
    }

    public void reset(boolean force) {
        if (this.SPAWN_ID > -1) {
            Bukkit.getScheduler().cancelTask(this.SPAWN_ID);
        }
        this.SPAWN_ID = -1;
    }

    public void parseStart() {
        if (this.usesPowerups != null) {
            String pu = this.arena.getArenaConfig().getString(Config.CFG.MODULES_POWERUPS_USAGE);
            String[] ss = pu.split(":");
            if (!pu.startsWith("time")) {
                return;
            }
            this.powerupDiff = Integer.parseInt(ss[1]);
            debug.i("using powerups : " + this.arena.getArenaConfig().getString(Config.CFG.MODULES_POWERUPS_USAGE) + " : " + this.powerupDiff);
            if (this.powerupDiff > 0) {
                debug.i("powerup time trigger!");
                this.powerupDiff *= 20;
                this.SPAWN_ID = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)PVPArena.instance, (Runnable)new PowerupRunnable(this), (long)this.powerupDiff, (long)this.powerupDiff);
            }
        }
    }
}

