/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.eventactions;

import java.util.ArrayList;
import java.util.List;
import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.classes.PABlockLocation;
import net.slipcor.pvparena.commands.PAA_Edit;
import net.slipcor.pvparena.core.Language;
import net.slipcor.pvparena.loadables.ArenaModule;
import net.slipcor.pvparena.managers.SpawnManager;
import net.slipcor.pvparena.modules.eventactions.EADelay;
import net.slipcor.pvparena.modules.eventactions.PAListener;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.material.Button;
import org.bukkit.material.Lever;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;

public class EventActions
extends ArenaModule {
    private boolean setup = false;

    public EventActions() {
        super("EventActions");
    }

    public String version() {
        return "v1.0.1.80";
    }

    public void configParse(YamlConfiguration config) {
        if (this.setup) {
            return;
        }
        Bukkit.getPluginManager().registerEvents((Listener)new PAListener(this), (Plugin)PVPArena.instance);
        this.setup = true;
    }

    protected void catchEvent(String string, Player p, Arena a) {
        if (a == null || !a.equals(this.arena)) {
            return;
        }
        if (a.getArenaConfig().getUnsafe("event." + string) == null) {
            return;
        }
        List items = a.getArenaConfig().getStringList("event." + string, new ArrayList());
        for (String item : items) {
            if (p != null) {
                item = item.replace("%player%", p.getName());
            }
            item = item.replace("%arena%", a.getName());
            String[] split = (item = ChatColor.translateAlternateColorCodes((char)'&', (String)item)).split("<=>");
            if (split.length != 2) {
                PVPArena.instance.getLogger().warning("[PE] skipping: [" + a.getName() + "]:event." + string + "=>" + item);
                continue;
            }
            if (split[0].equalsIgnoreCase("cmd")) {
                Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), split[1]);
                continue;
            }
            if (split[0].equalsIgnoreCase("pcmd")) {
                p.performCommand(split[1]);
                continue;
            }
            if (split[0].equalsIgnoreCase("brc")) {
                Bukkit.broadcastMessage((String)split[1]);
                continue;
            }
            if (split[0].equalsIgnoreCase("switch")) {
                PABlockLocation loc = new PABlockLocation(SpawnManager.getCoords((Arena)a, (String)split[1]).toLocation());
                System.out.print(loc.toLocation().toVector().toBlockVector().toString());
                MaterialData state = loc.toLocation().getBlock().getState().getData();
                if (state instanceof Lever) {
                    ((Lever)state).setPowered(true);
                } else if (state instanceof Button) {
                    ((Button)state).setPowered(true);
                }
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)PVPArena.instance, (Runnable)new EADelay(loc), 20L);
                continue;
            }
            if (!split[0].equalsIgnoreCase("msg") || p == null) continue;
            p.sendMessage(split[1]);
        }
    }

    public boolean onPlayerInteract(PlayerInteractEvent event) {
        if (!event.hasBlock()) {
            return false;
        }
        debug.i("interact eventactions", (CommandSender)event.getPlayer());
        Arena a = (Arena)PAA_Edit.activeEdits.get(event.getPlayer().getName());
        if (a != null) {
            debug.i("found edit arena", (CommandSender)event.getPlayer());
            Location loc = event.getClickedBlock().getLocation();
            MaterialData state = loc.getBlock().getState().getData();
            if (state instanceof Lever || state instanceof Button) {
                debug.i("found lever/button", (CommandSender)event.getPlayer());
                String s = "switch";
                int i = 0;
                for (String node : a.getArenaConfig().getKeys("spawns")) {
                    if (!node.startsWith(s) || Integer.parseInt(node = node.replace(s, "")) < i) continue;
                    i = Integer.parseInt(node) + 1;
                }
                SpawnManager.setBlock((Arena)a, (PABlockLocation)new PABlockLocation(loc), (String)(String.valueOf(s) + i));
                Arena.pmsg((CommandSender)event.getPlayer(), (String)Language.parse((Language.MSG)Language.MSG.SPAWN_SET, (String)(String.valueOf(s) + i)));
                return true;
            }
        }
        return false;
    }
}

