/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.arenaboards;

import net.slipcor.pvparena.classes.PABlockLocation;
import net.slipcor.pvparena.core.Debug;
import net.slipcor.pvparena.modules.arenaboards.ArenaBoard;
import net.slipcor.pvparena.modules.arenaboards.ArenaBoardSign;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;

public class ArenaBoardColumn {
    protected ArenaBoard board;
    private PABlockLocation location;
    private Debug debug = new Debug(11);
    private ArenaBoardSign[] signs = new ArenaBoardSign[5];

    public ArenaBoardColumn(ArenaBoard ab, PABlockLocation l) {
        this.board = ab;
        this.location = l;
        this.debug.i("fetching sign column");
        this.fetchSigns();
    }

    private void fetchSigns() {
        Location l = this.location.toLocation().getBlock().getRelative(BlockFace.DOWN).getLocation();
        int i = 0;
        try {
            do {
                Sign s = (Sign)l.getBlock().getState();
                s.setLine(0, "");
                s.setLine(1, "");
                s.setLine(2, "");
                s.setLine(3, "");
                s.update();
                this.signs[i] = new ArenaBoardSign(this, l);
                l = l.getBlock().getRelative(BlockFace.DOWN).getLocation();
            } while (++i < 5);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void write(String[] s) {
        int i = 0;
        this.debug.i("writing to column at location " + this.location.toString());
        ArenaBoardSign[] arenaBoardSignArray = this.signs;
        int n = this.signs.length;
        int n2 = 0;
        while (n2 < n) {
            ArenaBoardSign abs = arenaBoardSignArray[n2];
            if (abs == null) {
                return;
            }
            int ii = 0;
            while (i < s.length && ii < 4) {
                abs.set(ii++, s[i++]);
            }
            abs.update();
            ++n2;
        }
    }
}

