/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.walls;

import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.commands.AbstractArenaCommand;
import net.slipcor.pvparena.core.Config;
import net.slipcor.pvparena.core.Language;
import net.slipcor.pvparena.loadables.ArenaModule;
import net.slipcor.pvparena.loadables.ArenaRegionShape;
import net.slipcor.pvparena.modules.walls.WallsRunner;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class Walls
extends ArenaModule {
    WallsRunner runnable = null;

    public Walls() {
        super("Walls");
    }

    public String version() {
        return "v1.0.1.60";
    }

    public boolean checkCommand(String s) {
        return s.equals("walls") || s.equals("wallmaterial") || s.equals("!ww") || s.equals("!wm");
    }

    private void createWalls() {
        Material mat = null;
        try {
            Material newMat = Material.getMaterial((String)this.arena.getArenaConfig().getString(Config.CFG.MODULES_WALLS_MATERIAL));
            mat = Material.getMaterial((String)newMat.name());
        }
        catch (Exception e) {
            mat = Material.SAND;
        }
        for (ArenaRegionShape region : this.arena.getRegions()) {
            if (!region.getRegionName().toLowerCase().contains("wall")) continue;
            World world = region.getWorld();
            int x1 = region.getMinimumLocation().getX();
            int y1 = region.getMinimumLocation().getY();
            int z1 = region.getMinimumLocation().getZ();
            int x2 = region.getMaximumLocation().getX();
            int y2 = region.getMaximumLocation().getY();
            int z2 = region.getMaximumLocation().getZ();
            int a = x1;
            while (a <= x2) {
                int b = y1;
                while (b <= y2) {
                    int c = z1;
                    while (c <= z2) {
                        world.getBlockAt(a, b, c).setType(mat);
                        ++c;
                    }
                    ++b;
                }
                ++a;
            }
        }
    }

    public void commitCommand(CommandSender sender, String[] args) {
        if (!PVPArena.hasAdminPerms((CommandSender)sender) && !PVPArena.hasCreatePerms((CommandSender)sender, (Arena)this.arena)) {
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM, (String)Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM_X_ADMIN)));
            return;
        }
        if (!AbstractArenaCommand.argCountValid((CommandSender)sender, (Arena)this.arena, (String[])args, (Integer[])new Integer[]{2})) {
            return;
        }
        if (args[0].equals("!ww") || args[0].equals("walls")) {
            int i = 0;
            try {
                i = Integer.parseInt(args[1]);
            }
            catch (Exception e) {
                this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_NOT_NUMERIC, (String)args[1]));
                return;
            }
            this.arena.getArenaConfig().set(Config.CFG.MODULES_WALLS_SECONDS, (Object)i);
            this.arena.getArenaConfig().save();
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.SET_DONE, (String)Config.CFG.MODULES_WALLS_SECONDS.getNode(), (String)String.valueOf(i)));
        } else {
            Material mat = null;
            try {
                mat = Material.getMaterial((String)args[0].toUpperCase());
                debug.i("wall material: " + mat.name());
            }
            catch (Exception e) {
                this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_MAT_NOT_FOUND, (String)args[0]));
                return;
            }
            this.arena.getArenaConfig().set(Config.CFG.MODULES_WALLS_MATERIAL, (Object)mat.name());
            this.arena.getArenaConfig().save();
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.SET_DONE, (String)Config.CFG.MODULES_WALLS_MATERIAL.getNode(), (String)mat.name()));
        }
    }

    public void displayInfo(CommandSender sender) {
        sender.sendMessage("seconds: " + this.arena.getArenaConfig().getInt(Config.CFG.MODULES_WALLS_SECONDS) + "material: " + this.arena.getArenaConfig().getString(Config.CFG.MODULES_WALLS_MATERIAL));
    }

    public void parseStart() {
        this.runnable = new WallsRunner(this, this.arena, this.arena.getArenaConfig().getInt(Config.CFG.MODULES_WALLS_SECONDS));
        this.createWalls();
    }

    public void reset(boolean force) {
        if (this.runnable != null) {
            this.runnable.cancel();
        }
        this.runnable = null;
        this.createWalls();
    }

    public void removeWalls() {
        for (ArenaRegionShape region : this.arena.getRegions()) {
            if (!region.getRegionName().toLowerCase().contains("wall")) continue;
            World world = region.getWorld();
            int x1 = region.getMinimumLocation().getX();
            int y1 = region.getMinimumLocation().getY();
            int z1 = region.getMinimumLocation().getZ();
            int x2 = region.getMaximumLocation().getX();
            int y2 = region.getMaximumLocation().getY();
            int z2 = region.getMaximumLocation().getZ();
            int a = x1;
            while (a <= x2) {
                int b = y1;
                while (b <= y2) {
                    int c = z1;
                    while (c <= z2) {
                        world.getBlockAt(a, b, c).setType(Material.AIR);
                        ++c;
                    }
                    ++b;
                }
                ++a;
            }
        }
    }
}

