/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.goals.pillars;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.arena.ArenaPlayer;
import net.slipcor.pvparena.arena.ArenaTeam;
import net.slipcor.pvparena.classes.PABlockLocation;
import net.slipcor.pvparena.classes.PACheck;
import net.slipcor.pvparena.classes.PALocation;
import net.slipcor.pvparena.commands.PAA_Region;
import net.slipcor.pvparena.core.Config;
import net.slipcor.pvparena.core.Debug;
import net.slipcor.pvparena.core.Language;
import net.slipcor.pvparena.core.StringParser;
import net.slipcor.pvparena.goals.pillars.Pillar;
import net.slipcor.pvparena.goals.pillars.PillarRunner;
import net.slipcor.pvparena.loadables.ArenaGoal;
import net.slipcor.pvparena.loadables.ArenaModuleManager;
import net.slipcor.pvparena.managers.SpawnManager;
import net.slipcor.pvparena.managers.StatisticsManager;
import net.slipcor.pvparena.managers.TeamManager;
import net.slipcor.pvparena.ncloader.NCBLoadable;
import net.slipcor.pvparena.runnables.EndRunnable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitTask;

public class GoalPillars
extends ArenaGoal
implements Listener {
    private Map<String, String> flagMap = null;
    private Map<String, ItemStack> headGearMap = null;
    private Map<String, Pillar> pillarMap = null;
    private Map<ArenaTeam, Double> scores = null;
    private static final Set<Material> HEADFLAGS = new HashSet<Material>();
    private String flagName = "";
    private boolean announceTick = true;
    private boolean breakable = false;
    private boolean onlyFree = true;
    private int tickPoints = 1;
    private int tickInterval = 20;
    private final int announceOffset = 3;
    private int offset = 0;
    private BukkitTask pillarRunner = null;
    private static final int PRIORITY = 8;

    static {
        HEADFLAGS.add(Material.PUMPKIN);
        HEADFLAGS.add(Material.WOOL);
        HEADFLAGS.add(Material.JACK_O_LANTERN);
        HEADFLAGS.add(Material.SKULL_ITEM);
    }

    public GoalPillars() {
        super("Pillars");
        this.debug = new Debug(100);
    }

    public String version() {
        return "v1.0.1.57";
    }

    public boolean allowsJoinInBattle() {
        return this.arena.getArenaConfig().getBoolean(Config.CFG.PERMS_JOININBATTLE);
    }

    public PACheck checkCommand(PACheck res, String string) {
        if (res.getPriority() > 8) {
            return res;
        }
        if (string.equalsIgnoreCase("flageffect") || string.equalsIgnoreCase("touchdown") || string.contains("pillar")) {
            res.setPriority((NCBLoadable)this, 8);
        }
        return res;
    }

    public PACheck checkEnd(PACheck res) {
        if (res.getPriority() > 8) {
            return res;
        }
        int count = TeamManager.countActiveTeams((Arena)this.arena);
        if (count == 1) {
            res.setPriority((NCBLoadable)this, 8);
        } else if (count == 0) {
            res.setError((NCBLoadable)this, "No teams playing!");
        }
        return res;
    }

    public String checkForMissingSpawns(Set<String> list) {
        for (String s : list) {
            if (!s.contains("pillar")) continue;
            return null;
        }
        return "no pillar set";
    }

    public PACheck checkInteract(PACheck res, Player player, Block block) {
        if (block == null || res.getPriority() > 8) {
            return res;
        }
        this.debug.i("checking interact", (CommandSender)player);
        if (!block.getType().name().equals(this.arena.getArenaConfig().getString(Config.CFG.GOAL_FLAGS_FLAGTYPE))) {
            this.debug.i("block, but not flag", (CommandSender)player);
            return res;
        }
        this.debug.i("flag click!", (CommandSender)player);
        Pillar pillar = null;
        for (String pillarName : this.getPillarMap().keySet()) {
            pillar = this.getPillarMap().get(pillarName);
            ArenaTeam owner = pillar.getOwner();
            ArenaPlayer clicker = ArenaPlayer.parsePlayer((String)player.getName());
            if (!pillar.getLocation().equals((Object)new PABlockLocation(block.getLocation()))) continue;
            this.announce(pillar, pillarName, owner, clicker, pillar.blockClick(clicker));
            return res;
        }
        return res;
    }

    private void announce(Pillar pillar, String pillarName, ArenaTeam owner, ArenaPlayer player, Pillar.PillarResult result) {
        if (result == Pillar.PillarResult.NONE) {
            return;
        }
        String message = Language.parse((Language.MSG)Language.MSG.getByNode((String)("nulang.goal.pillars.msg." + result.name().toLowerCase())), (String)pillarName, (String)(String.valueOf(player.getArenaTeam().colorizePlayer(player.get())) + ChatColor.YELLOW));
        switch (result) {
            case BLOCK_BROKEN: 
            case LOWER: {
                this.arena.tellTeam(owner.getName(), message, owner.getColor(), null);
                this.arena.msg((CommandSender)player.get(), message);
                break;
            }
            case BLOCK_PLACED: 
            case HIGHER: {
                this.arena.tellTeam(owner.getName(), message, owner.getColor(), null);
                break;
            }
            case CLAIMED: 
            case UNCLAIMED: {
                this.arena.broadcast(message);
                break;
            }
        }
    }

    public PACheck checkJoin(CommandSender sender, PACheck res, String[] args) {
        ArenaTeam team;
        if (res.getPriority() >= 8) {
            return res;
        }
        int maxPlayers = this.arena.getArenaConfig().getInt(Config.CFG.READY_MAXPLAYERS);
        int maxTeamPlayers = this.arena.getArenaConfig().getInt(Config.CFG.READY_MAXTEAMPLAYERS);
        if (maxPlayers > 0 && this.arena.getFighters().size() >= maxPlayers) {
            res.setError((NCBLoadable)this, Language.parse((Language.MSG)Language.MSG.ERROR_JOIN_ARENA_FULL));
            return res;
        }
        if (args == null || args.length < 1) {
            return res;
        }
        if (!this.arena.isFreeForAll() && (team = this.arena.getTeam(args[0])) != null && maxTeamPlayers > 0 && team.getTeamMembers().size() >= maxTeamPlayers) {
            res.setError((NCBLoadable)this, Language.parse((Language.MSG)Language.MSG.ERROR_JOIN_TEAM_FULL));
            return res;
        }
        res.setPriority((NCBLoadable)this, 8);
        return res;
    }

    public PACheck checkSetBlock(PACheck res, Player player, Block block) {
        if (res.getPriority() > 8 || !PAA_Region.activeSelections.containsKey(player.getName())) {
            return res;
        }
        res.setPriority((NCBLoadable)this, 8);
        return res;
    }

    private void commit(Arena arena, String sTeam, boolean win) {
        this.debug.i("[Pillar] committing end: " + sTeam);
        this.debug.i("win: " + win);
        String winteam = sTeam;
        for (ArenaTeam team : arena.getTeams()) {
            if (team.getName().equals(sTeam) == win) continue;
            for (ArenaPlayer ap : team.getTeamMembers()) {
                ap.addStatistic(arena.getName(), StatisticsManager.type.LOSSES, 1);
                arena.tpPlayerToCoordName(ap.get(), "spectator");
                ap.setTelePass(false);
            }
        }
        block2: for (ArenaTeam team : arena.getTeams()) {
            for (ArenaPlayer ap : team.getTeamMembers()) {
                if (!ap.getStatus().equals((Object)ArenaPlayer.Status.FIGHT)) continue;
                winteam = team.getName();
                continue block2;
            }
        }
        if (arena.getTeam(winteam) != null) {
            ArenaModuleManager.announce((Arena)arena, (String)Language.parse((Language.MSG)Language.MSG.TEAM_HAS_WON, (String)(arena.getTeam(winteam).getColor() + "Team " + winteam + ChatColor.YELLOW)), (String)"WINNER");
            arena.broadcast(Language.parse((Language.MSG)Language.MSG.TEAM_HAS_WON, (String)(arena.getTeam(winteam).getColor() + "Team " + winteam + ChatColor.YELLOW)));
        }
        new EndRunnable(arena, arena.getArenaConfig().getInt(Config.CFG.TIME_ENDCOUNTDOWN));
    }

    public void commitCommand(CommandSender sender, String[] args) {
        if (args[0].equalsIgnoreCase("flageffect")) {
            if (args.length < 2) {
                this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_INVALID_ARGUMENT_COUNT, (String)String.valueOf(args.length), (String)"2"));
                return;
            }
            if (args[1].equalsIgnoreCase("none")) {
                this.arena.getArenaConfig().set(Config.CFG.GOAL_FLAGS_FLAGEFFECT, (Object)args[1]);
                this.arena.getArenaConfig().save();
                this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.SET_DONE, (String)Config.CFG.GOAL_FLAGS_FLAGEFFECT.getNode(), (String)args[1]));
                return;
            }
            PotionEffectType pet = null;
            PotionEffectType[] potionEffectTypeArray = PotionEffectType.values();
            int n = potionEffectTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                PotionEffectType x = potionEffectTypeArray[n2];
                if (x != null && x.getName().equalsIgnoreCase(args[1])) {
                    pet = x;
                    break;
                }
                ++n2;
            }
            if (pet == null) {
                this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_POTIONEFFECTTYPE_NOTFOUND, (String)args[1]));
                return;
            }
            int amp = 1;
            if (args.length == 5) {
                try {
                    amp = Integer.parseInt(args[2]);
                }
                catch (Exception e) {
                    this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_NOT_NUMERIC, (String)args[2]));
                    return;
                }
            }
            String value = String.valueOf(args[1]) + "x" + amp;
            this.arena.getArenaConfig().set(Config.CFG.GOAL_FLAGS_FLAGEFFECT, (Object)value);
            this.arena.getArenaConfig().save();
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.SET_DONE, (String)Config.CFG.GOAL_FLAGS_FLAGEFFECT.getNode(), (String)value));
        } else if (args[0].contains("pillar")) {
            this.flagName = args[0];
            PAA_Region.activeSelections.put(sender.getName(), this.arena);
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.GOAL_FLAGS_TOSET, (String)this.flagName));
        }
    }

    public void commitEnd(boolean force) {
        this.debug.i("[Pillar]");
        ArenaTeam aTeam = null;
        block0: for (ArenaTeam team : this.arena.getTeams()) {
            for (ArenaPlayer ap : team.getTeamMembers()) {
                if (!ap.getStatus().equals((Object)ArenaPlayer.Status.FIGHT)) continue;
                aTeam = team;
                continue block0;
            }
        }
        if (aTeam != null && !force) {
            ArenaModuleManager.announce((Arena)this.arena, (String)Language.parse((Language.MSG)Language.MSG.TEAM_HAS_WON, (String)(aTeam.getColor() + "Team " + aTeam.getName() + ChatColor.YELLOW)), (String)"WINNER");
            this.arena.broadcast(Language.parse((Language.MSG)Language.MSG.TEAM_HAS_WON, (String)(aTeam.getColor() + "Team " + aTeam.getName() + ChatColor.YELLOW)));
        }
        if (ArenaModuleManager.commitEnd((Arena)this.arena, aTeam)) {
            return;
        }
        new EndRunnable(this.arena, this.arena.getArenaConfig().getInt(Config.CFG.TIME_ENDCOUNTDOWN));
    }

    public boolean commitSetFlag(Player player, Block block) {
        if (block == null || block.getType() != Material.WOOL) {
            return false;
        }
        if (!PVPArena.hasAdminPerms((CommandSender)player) && !PVPArena.hasCreatePerms((CommandSender)player, (Arena)this.arena)) {
            return false;
        }
        this.debug.i("trying to set a flag", (CommandSender)player);
        SpawnManager.setBlock((Arena)this.arena, (PABlockLocation)new PABlockLocation(block.getLocation()), (String)this.flagName);
        this.arena.msg((CommandSender)player, Language.parse((Language.MSG)Language.MSG.GOAL_FLAGS_SET, (String)this.flagName));
        PAA_Region.activeSelections.remove(player.getName());
        this.flagName = "";
        return false;
    }

    public void commitStart() {
    }

    public void configParse(YamlConfiguration config) {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)PVPArena.instance);
    }

    public void disconnect(ArenaPlayer aPlayer) {
        if (this.getFlagMap() == null) {
            return;
        }
        String sTeam = this.getHeldFlagTeam(aPlayer.getName());
        ArenaTeam flagTeam = this.arena.getTeam(sTeam);
        if (sTeam == null) {
            return;
        }
        this.arena.broadcast(Language.parse((Language.MSG)Language.MSG.GOAL_FLAGS_DROPPED, (String)(String.valueOf(aPlayer.getArenaTeam().getColorCodeString()) + aPlayer.getName() + ChatColor.YELLOW), (String)(String.valueOf(flagTeam.getName()) + ChatColor.YELLOW)));
        this.getFlagMap().remove(flagTeam.getName());
        if (this.getHeadGearMap() != null && this.getHeadGearMap().get(aPlayer.getName()) != null) {
            if (aPlayer.get() != null) {
                aPlayer.get().getInventory().setHelmet(this.getHeadGearMap().get(aPlayer.getName()).clone());
            }
            this.getHeadGearMap().remove(aPlayer.getName());
        }
    }

    private Map<String, String> getFlagMap() {
        if (this.flagMap == null) {
            this.flagMap = new HashMap<String, String>();
        }
        return this.flagMap;
    }

    public PACheck getLives(PACheck res, ArenaPlayer aPlayer) {
        if (!res.hasError() && res.getPriority() <= 8) {
            res.setError((NCBLoadable)this, String.valueOf(this.scores.containsKey(aPlayer.getArenaTeam()) ? this.scores.get(aPlayer.getArenaTeam()) : 0.0));
        }
        return res;
    }

    private Map<String, ItemStack> getHeadGearMap() {
        if (this.headGearMap == null) {
            this.headGearMap = new HashMap<String, ItemStack>();
        }
        return this.headGearMap;
    }

    private String getHeldFlagTeam(String player) {
        if (this.getFlagMap().size() < 1) {
            return null;
        }
        this.debug.i("getting held FLAG of player " + player, player);
        for (String sTeam : this.getFlagMap().keySet()) {
            this.debug.i("team " + sTeam + " is in " + this.getFlagMap().get(sTeam) + "s hands", player);
            if (!player.equals(this.getFlagMap().get(sTeam))) continue;
            return sTeam;
        }
        return null;
    }

    private Map<String, Pillar> getPillarMap() {
        if (this.pillarMap == null) {
            this.pillarMap = new HashMap<String, Pillar>();
        }
        return this.pillarMap;
    }

    public String guessSpawn(String place) {
        HashMap<Integer, String> locs = new HashMap<Integer, String>();
        int pos = 0;
        this.debug.i("searching for team spawns: " + place);
        HashMap coords = (HashMap)this.arena.getArenaConfig().getYamlConfiguration().getConfigurationSection("spawns").getValues(false);
        for (String name : coords.keySet()) {
            if (!name.startsWith(place)) continue;
            locs.put(pos++, name);
            this.debug.i("found match: " + name);
        }
        if (locs.size() < 1) {
            return null;
        }
        Random random = new Random();
        return (String)locs.get(random.nextInt(locs.size()));
    }

    public boolean hasSpawn(String string) {
        for (String teamName : this.arena.getTeamNames()) {
            if (!string.toLowerCase().startsWith(String.valueOf(teamName.toLowerCase()) + "spawn")) continue;
            return true;
        }
        return false;
    }

    public boolean isInternal() {
        return true;
    }

    public void parsePlayerDeath(Player player, EntityDamageEvent lastDamageCause) {
        if (this.getFlagMap() == null) {
            this.debug.i("no flags set!!", (CommandSender)player);
            return;
        }
        String sTeam = this.getHeldFlagTeam(player.getName());
        ArenaTeam flagTeam = this.arena.getTeam(sTeam);
        ArenaPlayer aPlayer = ArenaPlayer.parsePlayer((String)player.getName());
        if (flagTeam == null) {
            return;
        }
        this.arena.broadcast(Language.parse((Language.MSG)Language.MSG.GOAL_FLAGS_DROPPED, (String)(String.valueOf(aPlayer.getArenaTeam().colorizePlayer(player)) + ChatColor.YELLOW), (String)(String.valueOf(flagTeam.getColoredName()) + ChatColor.YELLOW)));
        this.getFlagMap().remove(flagTeam.getName());
        if (this.getHeadGearMap() != null && this.getHeadGearMap().get(player.getName()) != null) {
            player.getInventory().setHelmet(this.getHeadGearMap().get(player.getName()).clone());
            this.getHeadGearMap().remove(player.getName());
        }
    }

    public void parseStart() {
        this.getPillarMap().clear();
        if (this.scores == null) {
            this.scores = new HashMap<ArenaTeam, Double>();
        }
        this.scores.clear();
        Map map = SpawnManager.getSpawnMap((Arena)this.arena, (String)"pillar");
        int emptyHeight = this.arena.getArenaConfig().getInt(Config.CFG.GOAL_PILLARS_EMPTYHEIGHT);
        this.breakable = this.arena.getArenaConfig().getBoolean(Config.CFG.GOAL_PILLARS_BREAKABLE);
        this.tickInterval = this.arena.getArenaConfig().getInt(Config.CFG.GOAL_PILLARS_INTERVAL);
        int maxClicks = this.arena.getArenaConfig().getInt(Config.CFG.GOAL_PILLARS_MAXCLICKS);
        int maxHeight = this.arena.getArenaConfig().getInt(Config.CFG.GOAL_PILLARS_MAXHEIGHT);
        int teamHeight = this.arena.getArenaConfig().getInt(Config.CFG.GOAL_PILLARS_TEAMHEIGHT);
        this.tickPoints = this.arena.getArenaConfig().getInt(Config.CFG.GOAL_PILLARS_TICKPOINTS);
        this.onlyFree = this.arena.getArenaConfig().getBoolean(Config.CFG.GOAL_PILLARS_ONLYFREE);
        this.announceTick = this.arena.getArenaConfig().getBoolean(Config.CFG.GOAL_PILLARS_ANNOUNCETICK);
        for (String spawnName : map.keySet()) {
            String[] split = spawnName.split("pillar");
            ArenaTeam owner = this.arena.getTeam(split[0]);
            this.getPillarMap().put(spawnName, new Pillar(new PABlockLocation(((PALocation)map.get(spawnName)).toLocation()), owner == null ? emptyHeight : teamHeight, maxHeight, maxClicks, owner));
        }
        for (Pillar pillar : this.getPillarMap().values()) {
            pillar.reset();
        }
        this.pillarRunner = Bukkit.getScheduler().runTaskTimer((Plugin)PVPArena.instance, (Runnable)((Object)new PillarRunner(this)), (long)this.tickInterval * 1L, (long)this.tickInterval * 1L);
    }

    private boolean reduceLivesCheckEndAndCommit() {
        this.debug.i("checking lives");
        int max = this.arena.getArenaConfig().getInt(Config.CFG.GOAL_PILLARS_LIVES);
        for (ArenaTeam team : this.scores.keySet()) {
            double score = this.scores.get(team);
            if (!(score >= (double)max)) continue;
            this.commit(this.arena, team.getName(), true);
            return true;
        }
        return false;
    }

    public void reset(boolean force) {
        this.getFlagMap().clear();
        this.getHeadGearMap().clear();
        for (Pillar p : this.getPillarMap().values()) {
            p.reset();
        }
        if (this.pillarRunner != null) {
            this.pillarRunner.cancel();
            this.pillarRunner = null;
        }
    }

    public void setDefaults(YamlConfiguration config) {
        if (this.arena.isFreeForAll()) {
            return;
        }
        if (config.get("teams.free") != null) {
            config.set("teams", null);
        }
        if (config.get("teams") == null) {
            this.debug.i("no teams defined, adding custom red and blue!");
            config.addDefault("teams.red", (Object)ChatColor.RED.name());
            config.addDefault("teams.blue", (Object)ChatColor.BLUE.name());
        }
        if (this.arena.getArenaConfig().getBoolean(Config.CFG.GOAL_FLAGS_WOOLFLAGHEAD) && config.get("flagColors") == null) {
            this.debug.i("no flagheads defined, adding white and black!");
            config.addDefault("flagColors.red", (Object)"WHITE");
            config.addDefault("flagColors.blue", (Object)"BLACK");
        }
    }

    public Map<String, Double> timedEnd(Map<String, Double> scores) {
        for (ArenaTeam team : this.arena.getTeams()) {
            double score;
            double d = score = this.scores.containsKey(team) ? this.scores.get(team) : 0.0;
            if (scores.containsKey(team)) {
                scores.put(team.getName(), scores.get(team.getName()) + score);
                continue;
            }
            scores.put(team.getName(), score);
        }
        return scores;
    }

    protected void tick() {
        if (this.arena.realEndRunner != null) {
            return;
        }
        boolean didsomething = false;
        boolean claimedAll = true;
        ArenaTeam allClaimed = null;
        for (String name : this.getPillarMap().keySet()) {
            ArenaTeam owner;
            Pillar pillar = this.getPillarMap().get(name);
            if (pillar.getOwner() == null) {
                claimedAll = false;
                continue;
            }
            if ((allClaimed == null || allClaimed == pillar.getOwner()) && claimedAll) {
                allClaimed = pillar.getOwner();
            }
            if (this.onlyFree && (pillar.getDefaultTeam() != null || name.contains(pillar.getOwner().getName())) || pillar.getDefaultTeam() != null && pillar.getDefaultTeam() == pillar.getOwner()) continue;
            if (pillar.getDefaultTeam() == null) {
                boolean conti = false;
                for (String teamName : this.arena.getTeamNames()) {
                    if (!name.contains(teamName) || pillar.getOwner().getName().equals(teamName)) continue;
                    conti = true;
                    break;
                }
                if (conti) continue;
            }
            double score = this.scores.containsKey(owner = pillar.getOwner()) ? this.scores.get(owner) : 0.0;
            this.scores.put(owner, score += pillar.getClaimStatus() * (double)this.tickPoints);
            didsomething = true;
        }
        if (claimedAll && this.arena.getArenaConfig().getBoolean(Config.CFG.GOAL_PILLARS_CLAIMALL)) {
            for (ArenaTeam otherTeam : this.arena.getTeams()) {
                if (otherTeam.equals(allClaimed)) continue;
                this.getLifeMap().remove(otherTeam.getName());
                for (ArenaPlayer ap : otherTeam.getTeamMembers()) {
                    if (!ap.getStatus().equals((Object)ArenaPlayer.Status.FIGHT)) continue;
                    ap.setStatus(ArenaPlayer.Status.LOST);
                    this.arena.removePlayer(ap.get(), Config.CFG.TP_LOSE.toString(), true, false);
                }
            }
            PACheck.handleEnd((Arena)this.arena, (boolean)false);
            return;
        }
        if (this.scores.isEmpty() || !didsomething) {
            return;
        }
        if (this.reduceLivesCheckEndAndCommit() || !this.announceTick) {
            return;
        }
        ++this.offset;
        this.offset %= 3;
        if (this.offset != 0) {
            return;
        }
        HashSet<String> msgs = new HashSet<String>();
        for (ArenaTeam team : this.scores.keySet()) {
            msgs.add(Language.parse((Language.MSG)Language.MSG.GOAL_PILLARS_MSG_SCORE, (String)(String.valueOf(team.getColoredName()) + ChatColor.YELLOW), (String)String.format("%.1f", this.scores.get(team))));
        }
        this.arena.broadcast(StringParser.joinSet(msgs, (String)" - "));
    }

    public void unload(Player player) {
        this.disconnect(ArenaPlayer.parsePlayer((String)player.getName()));
        if (this.allowsJoinInBattle()) {
            this.arena.hasNotPlayed(ArenaPlayer.parsePlayer((String)player.getName()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onFlagAdd(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        ArenaPlayer aPlayer = ArenaPlayer.parsePlayer((String)player.getName());
        if (!this.arena.equals(aPlayer.getArena())) {
            return;
        }
        Block block = event.getBlockAgainst();
        if (!block.getType().name().equals(this.arena.getArenaConfig().getString(Config.CFG.GOAL_FLAGS_FLAGTYPE))) {
            this.debug.i("block, but not flag", (CommandSender)player);
            return;
        }
        this.debug.i("flag place?", (CommandSender)player);
        Pillar pillar = null;
        for (String pillarName : this.getPillarMap().keySet()) {
            pillar = this.getPillarMap().get(pillarName);
            ArenaTeam owner = pillar.getOwner();
            ArenaPlayer clicker = ArenaPlayer.parsePlayer((String)player.getName());
            if (pillar.getLocation().equals((Object)new PABlockLocation(block.getLocation()))) {
                this.debug.i("cancel!", (CommandSender)player);
                event.setCancelled(true);
                if (!this.breakable) {
                    this.debug.i("!breakable => OUT", (CommandSender)player);
                    return;
                }
                this.announce(pillar, pillarName, owner, clicker, pillar.blockPlace(clicker));
                return;
            }
            if (!pillar.containsLocation(new PABlockLocation(event.getBlock().getLocation()))) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onFlagClaim(BlockBreakEvent event) {
        Block block = event.getBlock();
        Player player = event.getPlayer();
        ArenaPlayer aPlayer = ArenaPlayer.parsePlayer((String)player.getName());
        if (!this.arena.equals(aPlayer.getArena())) {
            return;
        }
        if (!block.getType().name().equals(this.arena.getArenaConfig().getString(Config.CFG.GOAL_FLAGS_FLAGTYPE))) {
            this.debug.i("block, but not flag", (CommandSender)player);
            return;
        }
        this.debug.i("flag break?", (CommandSender)player);
        Pillar pillar = null;
        for (String pillarName : this.getPillarMap().keySet()) {
            pillar = this.getPillarMap().get(pillarName);
            ArenaTeam owner = pillar.getOwner();
            ArenaPlayer clicker = ArenaPlayer.parsePlayer((String)player.getName());
            if (pillar.getLocation().equals((Object)new PABlockLocation(block.getLocation()))) {
                if (!this.breakable || owner == null) {
                    this.debug.i("!breakable || " + owner + "=> CANCEL", (CommandSender)player);
                    event.setCancelled(true);
                    return;
                }
                Pillar.PillarResult result = pillar.blockBreak(clicker);
                event.setCancelled(result == Pillar.PillarResult.NONE);
                this.announce(pillar, pillarName, owner, clicker, result);
                return;
            }
            if (!pillar.containsLocation(new PABlockLocation(event.getBlock().getLocation()))) continue;
            event.setCancelled(true);
            return;
        }
    }
}

