/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvparena.modules.skins;

import java.util.HashSet;
import me.desmin88.mobdisguise.api.MobDisguiseAPI;
import net.slipcor.pvparena.PVPArena;
import net.slipcor.pvparena.arena.Arena;
import net.slipcor.pvparena.arena.ArenaClass;
import net.slipcor.pvparena.arena.ArenaPlayer;
import net.slipcor.pvparena.arena.ArenaTeam;
import net.slipcor.pvparena.commands.AbstractArenaCommand;
import net.slipcor.pvparena.core.Language;
import net.slipcor.pvparena.loadables.ArenaModule;
import net.slipcor.pvparena.modules.skins.DisguiseRunnable;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import pgDev.bukkit.DisguiseCraft.DisguiseCraft;
import pgDev.bukkit.DisguiseCraft.api.DisguiseCraftAPI;
import pgDev.bukkit.DisguiseCraft.disguise.Disguise;
import pgDev.bukkit.DisguiseCraft.disguise.DisguiseType;

public class Skins
extends ArenaModule {
    protected static boolean mdHandler = false;
    protected static boolean dcHandler = false;
    protected static boolean enabled = false;
    DisguiseCraftAPI dapi = null;
    HashSet<String> disguised = new HashSet();

    public Skins() {
        super("Skins");
    }

    public String version() {
        return "v1.0.0.11";
    }

    public boolean checkCommand(String s) {
        return s.equals("!sk") || s.startsWith("skins");
    }

    public void commitCommand(CommandSender sender, String[] args) {
        if (!PVPArena.hasAdminPerms((CommandSender)sender) && !PVPArena.hasCreatePerms((CommandSender)sender, (Arena)this.arena)) {
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM, (String)Language.parse((Language.MSG)Language.MSG.ERROR_NOPERM_X_ADMIN)));
            return;
        }
        if (!AbstractArenaCommand.argCountValid((CommandSender)sender, (Arena)this.arena, (String[])args, (Integer[])new Integer[]{3})) {
            return;
        }
        ArenaClass c = this.arena.getClass(args[1]);
        if (c == null) {
            ArenaTeam team = this.arena.getTeam(args[1]);
            if (team != null) {
                if (args.length == 2) {
                    this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.MODULE_SKINS_SHOWTEAM, (String)team.getColoredName(), (String)((String)this.arena.getArenaConfig().getUnsafe("skins." + team.getName()))));
                    return;
                }
                this.arena.getArenaConfig().setManually("skins." + team.getName(), (Object)args[2]);
                this.arena.getArenaConfig().save();
                this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.SET_DONE, (String)team.getName(), (String)args[2]));
                return;
            }
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_CLASS_NOT_FOUND, (String)args[1]));
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.ERROR_TEAMNOTFOUND, (String)args[1]));
            this.printHelp(this.arena, sender);
            return;
        }
        if (args.length == 2) {
            this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.MODULE_SKINS_SHOWCLASS, (String)((String)this.arena.getArenaConfig().getUnsafe("skins." + c.getName()))));
            return;
        }
        this.arena.getArenaConfig().setManually("skins." + c.getName(), (Object)args[2]);
        this.arena.getArenaConfig().save();
        this.arena.msg(sender, Language.parse((Language.MSG)Language.MSG.SET_DONE, (String)c.getName(), (String)args[2]));
    }

    public void configParse(YamlConfiguration config) {
        if (config.get("skins") == null) {
            for (ArenaTeam team : this.arena.getTeams()) {
                String sName = team.getName();
                config.addDefault("skins." + sName, (Object)"Herobrine");
            }
            config.options().copyDefaults(true);
        }
    }

    public void parseRespawn(Player player, ArenaTeam team, EntityDamageEvent.DamageCause lastDamageCause, Entity damager) {
        if (dcHandler && this.dapi.isDisguised(player)) {
            this.dapi.undisguisePlayer(player);
        }
    }

    public void onThisLoad() {
        if (enabled) {
            return;
        }
        Language.MSG m = Language.MSG.MODULE_SKINS_NOMOD;
        if (Bukkit.getServer().getPluginManager().getPlugin("DisguiseCraft") != null) {
            dcHandler = true;
            m = Language.MSG.MODULE_SKINS_DISGUISECRAFT;
            this.dapi = DisguiseCraft.getAPI();
        } else if (Bukkit.getServer().getPluginManager().getPlugin("MobDisguise") != null) {
            mdHandler = true;
            m = Language.MSG.MODULE_SKINS_MOBDISGUISE;
        }
        enabled = true;
        Arena.pmsg((CommandSender)Bukkit.getConsoleSender(), (String)Language.parse((Language.MSG)m));
    }

    private void printHelp(Arena arena, CommandSender sender) {
        arena.msg(sender, "/pa [arenaname] !sk [teamname]  | show team disguise");
        arena.msg(sender, "/pa [arenaname] !sk [teamname] [skin] | set team disguise");
        arena.msg(sender, "/pa [arenaname] !sk [classname]  | show class disguise");
        arena.msg(sender, "/pa [arenaname] !sk [classname] [skin] | set class disguise");
    }

    public void tpPlayerToCoordName(Player player, String place) {
        ArenaTeam team;
        if (dcHandler) {
            this.dapi = DisguiseCraft.getAPI();
        }
        if (!dcHandler && !mdHandler && (team = ArenaPlayer.parsePlayer((String)player.getName()).getArenaTeam()) != null) {
            ItemStack is = new ItemStack(Material.SKULL_ITEM, 1);
            String disguise = (String)this.arena.getArenaConfig().getUnsafe("skins." + team.getName());
            if (disguise == null) {
                return;
            }
            if (disguise.equals("SKELETON")) {
                is.setDurability((short)0);
            } else if (disguise.equals("WITHER_SKELETON")) {
                is.setDurability((short)1);
            } else if (disguise.equals("ZOMBIE")) {
                is.setDurability((short)2);
            } else if (disguise.equals("PLAYER")) {
                is.setDurability((short)3);
            } else if (disguise.equals("CREEPER")) {
                is.setDurability((short)4);
            } else {
                is.setDurability((short)3);
                SkullMeta sm = (SkullMeta)is.getItemMeta();
                sm.setOwner(disguise);
                is.setItemMeta((ItemMeta)sm);
            }
            class TempRunnable
            implements Runnable {
                private final /* synthetic */ Player val$player;
                private final /* synthetic */ ItemStack val$is;

                TempRunnable(Player player, ItemStack itemStack) {
                    this.val$player = player;
                    this.val$is = itemStack;
                }

                @Override
                public void run() {
                    this.val$player.getInventory().setHelmet(this.val$is);
                }
            }
            Bukkit.getScheduler().runTaskLater((Plugin)PVPArena.instance, (Runnable)new TempRunnable(player, is), 5L);
        }
        if (this.disguised.contains(player.getName())) {
            return;
        }
        if (this.arena.hasPlayer(player)) {
            team = ArenaPlayer.parsePlayer((String)player.getName()).getArenaTeam();
            if (team == null) {
                return;
            }
            String disguise = (String)this.arena.getArenaConfig().getUnsafe("skins." + team.getName());
            if (disguise == null || disguise.equals("none")) {
                return;
            }
            if (dcHandler) {
                DisguiseType t = DisguiseType.fromString((String)disguise);
                Disguise d = new Disguise(this.dapi.newEntityID(), disguise, t == null ? DisguiseType.Player : t);
                if (this.dapi.isDisguised(player)) {
                    this.dapi.undisguisePlayer(player);
                }
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)PVPArena.instance, (Runnable)new DisguiseRunnable(player, d), 3L);
            } else if (mdHandler && !MobDisguiseAPI.disguisePlayer((Player)player, (String)disguise) && !MobDisguiseAPI.disguisePlayerAsPlayer((Player)player, (String)disguise)) {
                PVPArena.instance.getLogger().warning("Unable to disguise " + player.getName() + " as " + disguise);
            }
            this.disguised.add(player.getName());
        }
    }

    public void unload(Player player) {
        if (dcHandler) {
            this.dapi.undisguisePlayer(player);
        } else if (mdHandler) {
            MobDisguiseAPI.undisguisePlayer((Player)player);
        }
        this.disguised.remove(player.getName());
    }
}

