/*
 * Decompiled with CFR 0.152.
 */
package rangatangaa.minecraft.Blocks3D;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.launchwrapper.IClassTransformer;

public class ClassPatcher
implements IClassTransformer {
    public static HashMap<String, File> toPatch = new HashMap();

    public byte[] transform(String name, String arg1, byte[] data) {
        File zipLocation = toPatch.remove(name);
        if (zipLocation != null) {
            data = this.overwriteClass(name, data, zipLocation);
        }
        return data;
    }

    private byte[] overwriteClass(String name, byte[] data, File zipLocation) {
        try {
            ZipFile zip = new ZipFile(zipLocation);
            ZipEntry entry = zip.getEntry("I3DPatches/" + name.replace('.', '/') + ".class");
            if (entry == null) {
                System.out.println("[Blocks3D] Class \"" + name + "\" not found in " + zipLocation.getName());
            } else {
                int inputLength;
                InputStream zipInputStream = zip.getInputStream(entry);
                int maxBytes = (int)entry.getSize();
                data = new byte[maxBytes];
                for (int bytes = 0; bytes < maxBytes; bytes += inputLength) {
                    inputLength = zipInputStream.read(data, bytes, maxBytes - bytes);
                    if (inputLength > 0) continue;
                    throw new IOException();
                }
                zipInputStream.close();
            }
            zip.close();
        }
        catch (Exception e) {
            System.out.println("[Blocks3D] Error overwriting class \"" + name + "\" from " + zipLocation.getName() + "error" + e);
        }
        return data;
    }

    public static void addPatchesFrom(File zipLocation) {
        int patchCount = 0;
        try {
            ZipFile zip = new ZipFile(zipLocation);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                String filename = entries.nextElement().getName();
                if (!filename.startsWith("I3DPatches/") || !filename.endsWith(".class")) continue;
                toPatch.put(filename.substring(11, filename.length() - 6), zipLocation);
                ++patchCount;
            }
            zip.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("[Blocks3D] Found " + patchCount);
    }
}

