/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extrabiomes.Extrabiomes;
import extrabiomes.lib.GeneralSettings;
import extrabiomes.lib.SaplingSettings;
import extrabiomes.module.summa.TreeSoilRegistry;
import extrabiomes.module.summa.worldgen.WorldGenBaldCypressTree;
import extrabiomes.module.summa.worldgen.WorldGenJapaneseMapleShrub;
import extrabiomes.module.summa.worldgen.WorldGenJapaneseMapleTree;
import extrabiomes.module.summa.worldgen.WorldGenNewTreeBase;
import extrabiomes.module.summa.worldgen.WorldGenRainbowEucalyptusTree;
import extrabiomes.module.summa.worldgen.WorldGenSakuraBlossomTree;
import java.util.List;
import java.util.Random;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;

public class BlockNewSapling
extends ane {
    int saplingID = 0;
    static int saplingLifespan = 5000;
    private ms[] textures = new ms[]{null, null, null, null, null, null, null, null};
    private static final int METADATA_BITMASK = 7;
    private static final int METADATA_MARKBIT = 8;
    private static int forestrySoilID = 0;

    private static boolean isEnoughLightToGrow(abw world, int x, int y, int z2) {
        return world.n(x, y, z2) >= 9;
    }

    private static boolean isMarkedMetadata(int metadata) {
        return (metadata & 8) != 0;
    }

    private static int markedMetadata(int metadata) {
        return metadata | 8;
    }

    public static void setForestrySoilID(int soilID) {
        forestrySoilID = soilID;
    }

    private static int unmarkedMetadata(int metadata) {
        return metadata & 7;
    }

    public BlockNewSapling(int id) {
        super(id);
        float var3 = 0.4f;
        this.a(0.099999994f, 0.0f, 0.099999994f, 0.9f, 0.8f, 0.9f);
        this.saplingID = id;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void a(mt iconRegistry) {
        this.textures[0] = iconRegistry.a(Extrabiomes.TEXTURE_PATH + "saplingbaldcypress");
        this.textures[1] = iconRegistry.a(Extrabiomes.TEXTURE_PATH + "saplingjapanesemaple");
        this.textures[2] = iconRegistry.a(Extrabiomes.TEXTURE_PATH + "saplingjapanesemapleshrub");
        this.textures[3] = iconRegistry.a(Extrabiomes.TEXTURE_PATH + "saplingrainboweucalyptus");
        this.textures[4] = iconRegistry.a(Extrabiomes.TEXTURE_PATH + "saplingsakura");
    }

    private void attemptGrowTree(abw world, int x, int y, int z2, Random rand) {
        if (BlockNewSapling.isEnoughLightToGrow(world, x, y + 1, z2) && rand.nextInt(7) == 0) {
            int metadata = world.h(x, y, z2);
            if (!BlockNewSapling.isMarkedMetadata(metadata)) {
                world.b(x, y, z2, BlockNewSapling.markedMetadata(metadata), 3);
            } else {
                this.growTree(world, x, y, z2, rand);
            }
        }
    }

    protected boolean g_(int id) {
        return TreeSoilRegistry.isValidSoil(id);
    }

    public int a(int metadata) {
        return BlockNewSapling.unmarkedMetadata(metadata);
    }

    public ms a(int side, int metadata) {
        if (this.textures[metadata = BlockNewSapling.unmarkedMetadata(metadata)] == null) {
            metadata = 0;
        }
        return this.textures[metadata];
    }

    public void markOrGrowMarked(abw world, int x, int y, int z2, Random rand) {
        int marked = world.h(x, y, z2);
        if ((marked & 8) == 0) {
            world.b(x, y, z2, marked | 8, 4);
        } else {
            this.growTree(world, x, y, z2, rand);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void a(int id, ww tab, List itemList) {
        for (BlockType blockType : BlockType.values()) {
            itemList.add(new ye((aqz)this, 1, blockType.metadata()));
        }
    }

    public void growTree(abw world, int x, int y, int z2, Random rand) {
        boolean isForestryFarmed;
        int metadata = BlockNewSapling.unmarkedMetadata(world.h(x, y, z2));
        WorldGenNewTreeBase tree = null;
        int x1 = 0;
        int z1 = 0;
        boolean isHuge = false;
        boolean bl = isForestryFarmed = world.a(x, y - 1, z2) == forestrySoilID;
        if (metadata == BlockType.BALD_CYPRESS.metadata() || metadata == BlockType.RAINBOW_EUCALYPTUS.metadata()) {
            for (x1 = 0; x1 >= -1; --x1) {
                for (z1 = 0; z1 >= -1; --z1) {
                    if (!this.isSameSapling(world, x + x1, y, z2 + z1, metadata) || !this.isSameSapling(world, x + x1 + 1, y, z2 + z1, metadata) || !this.isSameSapling(world, x + x1, y, z2 + z1 + 1, metadata) || !this.isSameSapling(world, x + x1 + 1, y, z2 + z1 + 1, metadata)) continue;
                    tree = metadata == BlockType.BALD_CYPRESS.metadata() ? new WorldGenBaldCypressTree(true) : new WorldGenRainbowEucalyptusTree(true);
                    isHuge = true;
                    break;
                }
                if (tree == null) {
                    continue;
                }
                break;
            }
        } else {
            tree = metadata == BlockType.JAPANESE_MAPLE.metadata() ? new WorldGenJapaneseMapleTree(true) : (metadata == BlockType.SAKURA_BLOSSOM.metadata() ? new WorldGenSakuraBlossomTree(true) : new WorldGenJapaneseMapleShrub(true));
        }
        if (tree != null) {
            if (isHuge) {
                world.c(x + x1, y, z2 + z1, 0);
                world.c(x + x1 + 1, y, z2 + z1, 0);
                world.c(x + x1, y, z2 + z1 + 1, 0);
                world.c(x + x1 + 1, y, z2 + z1 + 1, 0);
            } else {
                world.c(x, y, z2, 0);
            }
            if (!tree.a(world, rand, x + x1, y, z2 + z1)) {
                if (isHuge) {
                    world.f(x + x1, y, z2 + z1, this.cF, metadata, 3);
                    world.f(x + x1 + 1, y, z2 + z1, this.cF, metadata, 3);
                    world.f(x + x1, y, z2 + z1 + 1, this.cF, metadata, 3);
                    world.f(x + x1 + 1, y, z2 + z1 + 1, this.cF, metadata, 3);
                } else {
                    world.f(x, y, z2, this.cF, metadata, 3);
                }
            } else if (isForestryFarmed) {
                if (isHuge) {
                    world.c(x + x1, y - 1, z2 + z1, aqz.J.cF);
                    world.c(x + x1 + 1, y - 1, z2 + z1, aqz.J.cF);
                    world.c(x + x1, y - 1, z2 + z1 + 1, aqz.J.cF);
                    world.c(x + x1 + 1, y - 1, z2 + z1 + 1, aqz.J.cF);
                } else {
                    world.c(x, y - 1, z2, aqz.J.cF);
                }
            }
        }
    }

    public boolean isSameSapling(abw world, int x, int y, int z2, int metadata) {
        return world.a(x, y, z2) == this.cF && BlockNewSapling.unmarkedMetadata(world.h(x, y, z2)) == metadata;
    }

    public void a(abw world, int x, int y, int z2, Random rand) {
        if (!world.I) {
            super.a(world, x, y, z2, rand);
            this.attemptGrowTree(world, x, y, z2, rand);
        }
    }

    public static int getSaplingLifespan() {
        return saplingLifespan;
    }

    public static void setSaplingLifespan(int life) {
        saplingLifespan = life > 0 ? life : 0;
    }

    @ForgeSubscribe
    public void itemExpiring(ItemExpireEvent event) {
        if (event.entityItem.d().d == this.saplingID) {
            int count = event.entityItem.d().b;
            for (int i = 0; i < count; ++i) {
                double ratio;
                int metadata = BlockNewSapling.unmarkedMetadata(event.entityItem.d().k());
                int posX = (int)Math.floor(event.entityItem.U);
                int posY = (int)Math.floor(event.entityItem.V);
                int posZ = (int)Math.floor(event.entityItem.W);
                double chance = event.entityItem.q.s.nextDouble() * 100.0;
                boolean replant = false;
                if (!this.g_(event.entityItem.q.a(posX, posY - 1, posZ))) continue;
                double d = ratio = !GeneralSettings.bigTreeSaplingDropModifier ? 1.0 : 4.0;
                if (metadata == BlockType.BALD_CYPRESS.metadata() && chance <= SaplingSettings.BALD_CYPRESS.chance() * ratio) {
                    this.plant2x2Sapling(posX, posY, posZ, event.entityItem.q, event.entityItem.d());
                    continue;
                }
                if (metadata == BlockType.RAINBOW_EUCALYPTUS.metadata() && chance <= SaplingSettings.RAINBOW_EUCALYPTUS.chance() * ratio) {
                    this.plant2x2Sapling(posX, posY, posZ, event.entityItem.q, event.entityItem.d());
                    continue;
                }
                if (event.entityItem.q.c(posX, posY, posZ) && metadata == BlockType.JAPANESE_MAPLE.metadata() && chance <= SaplingSettings.JAPANESE_MAPLE.chance()) {
                    event.entityItem.q.f(posX, posY, posZ, this.saplingID, metadata, 2);
                    continue;
                }
                if (event.entityItem.q.c(posX, posY, posZ) && metadata == BlockType.JAPANESE_MAPLE_SHRUB.metadata() && chance <= SaplingSettings.JAPANESE_MAPLE_SHRUB.chance()) {
                    event.entityItem.q.f(posX, posY, posZ, this.saplingID, metadata, 2);
                    continue;
                }
                if (!event.entityItem.q.c(posX, posY, posZ) || metadata != BlockType.SAKURA_BLOSSOM.metadata || !(chance <= SaplingSettings.SAKURA_BLOSSOM.chance())) continue;
                event.entityItem.q.f(posX, posY, posZ, this.saplingID, metadata, 2);
            }
        }
    }

    private void plant2x2Sapling(int x, int y, int z2, abw world, ye sapling) {
        int metadata = sapling.k();
        if ((world.c(x, y, z2) || this.isSameSaplingBlock(x, y, z2, world, sapling)) && (world.c(x + 1, y, z2) || this.isSameSaplingBlock(x + 1, y, z2, world, sapling)) && (world.c(x + 1, y, z2 + 1) || this.isSameSaplingBlock(x + 1, y, z2 + 1, world, sapling)) && (world.c(x, y, z2 + 1) || this.isSameSaplingBlock(x, y, z2 + 1, world, sapling)) && world.c(x, y, z2) && this.g_(world.a(x, y - 1, z2)) && this.g_(world.a(x + 1, y - 1, z2)) && this.g_(world.a(x + 1, y - 1, z2 + 1)) && this.g_(world.a(x, y - 1, z2 + 1))) {
            world.f(x, y, z2, this.saplingID, metadata, 2);
            world.f(x + 1, y, z2, this.saplingID, metadata, 2);
            world.f(x + 1, y, z2 + 1, this.saplingID, metadata, 2);
            world.f(x, y, z2 + 1, this.saplingID, metadata, 2);
            return;
        }
        if ((world.c(x, y, z2) || this.isSameSaplingBlock(x, y, z2, world, sapling)) && (world.c(x, y, z2 + 1) || this.isSameSaplingBlock(x, y, z2 + 1, world, sapling)) && (world.c(x - 1, y, z2 + 1) || this.isSameSaplingBlock(x - 1, y, z2 + 1, world, sapling)) && (world.c(x - 1, y, z2) || this.isSameSaplingBlock(x - 1, y, z2, world, sapling)) && world.c(x, y, z2) && this.g_(world.a(x, y - 1, z2)) && this.g_(world.a(x, y - 1, z2 + 1)) && this.g_(world.a(x - 1, y - 1, z2 + 1)) && this.g_(world.a(x - 1, y - 1, z2))) {
            world.f(x, y, z2, this.saplingID, metadata, 2);
            world.f(x, y, z2 + 1, this.saplingID, metadata, 2);
            world.f(x - 1, y, z2 + 1, this.saplingID, metadata, 2);
            world.f(x - 1, y, z2, this.saplingID, metadata, 2);
            return;
        }
        if ((world.c(x, y, z2) || this.isSameSaplingBlock(x, y, z2, world, sapling)) && (world.c(x - 1, y, z2) || this.isSameSaplingBlock(x - 1, y, z2, world, sapling)) && (world.c(x - 1, y, z2 - 1) || this.isSameSaplingBlock(x - 1, y, z2 - 1, world, sapling)) && (world.c(x, y, z2 - 1) || this.isSameSaplingBlock(x, y, z2 - 1, world, sapling)) && world.c(x, y, z2) && this.g_(world.a(x, y - 1, z2)) && this.g_(world.a(x - 1, y - 1, z2)) && this.g_(world.a(x - 1, y - 1, z2 - 1)) && this.g_(world.a(x, y - 1, z2 - 1))) {
            world.f(x, y, z2, this.saplingID, metadata, 2);
            world.f(x - 1, y, z2, this.saplingID, metadata, 2);
            world.f(x - 1, y, z2 - 1, this.saplingID, metadata, 2);
            world.f(x, y, z2 - 1, this.saplingID, metadata, 2);
            return;
        }
        if ((world.c(x, y, z2) || this.isSameSaplingBlock(x, y, z2, world, sapling)) && (world.c(x, y, z2 - 1) || this.isSameSaplingBlock(x, y, z2 - 1, world, sapling)) && (world.c(x + 1, y, z2 - 1) || this.isSameSaplingBlock(x + 1, y, z2 - 1, world, sapling)) && (world.c(x + 1, y, z2) || this.isSameSaplingBlock(x + 1, y, z2, world, sapling)) && world.c(x, y, z2) && this.g_(world.a(x, y - 1, z2)) && this.g_(world.a(x, y - 1, z2 - 1)) && this.g_(world.a(x + 1, y - 1, z2 - 1)) && this.g_(world.a(x + 1, y - 1, z2))) {
            world.f(x, y, z2, this.saplingID, metadata, 2);
            world.f(x, y, z2 - 1, this.saplingID, metadata, 2);
            world.f(x + 1, y, z2 - 1, this.saplingID, metadata, 2);
            world.f(x + 1, y, z2, this.saplingID, metadata, 2);
            return;
        }
    }

    private boolean isSameSaplingBlock(int x, int y, int z2, abw world, ye sapling) {
        int id = world.a(x, y, z2);
        int metadata = world.h(x, y, z2);
        return id != 0 && aqz.s[id] != null && sapling.d == id && sapling.k() == metadata;
    }

    @ForgeSubscribe
    public void itemEntering(EntityJoinWorldEvent event) {
        if (event.entity instanceof ss && !event.world.I && ((ss)event.entity).d().d == this.saplingID) {
            ((ss)event.entity).lifespan = saplingLifespan;
        }
    }

    public static enum BlockType {
        BALD_CYPRESS(0),
        JAPANESE_MAPLE(1),
        JAPANESE_MAPLE_SHRUB(2),
        RAINBOW_EUCALYPTUS(3),
        SAKURA_BLOSSOM(4);

        private final int metadata;

        private BlockType(int metadata) {
            this.metadata = metadata;
        }

        public int metadata() {
            return this.metadata;
        }
    }
}

