/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.helpers;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import extrabiomes.Extrabiomes;
import extrabiomes.api.Api;
import extrabiomes.api.DiscoverWorldTypesEvent;
import extrabiomes.lib.BiomeSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.Event;

public abstract class BiomeHelper {
    private static final Set<acg> worldTypes = new HashSet<acg>();
    private static Optional<? extends ArrayList<acq>> activeBiomes = Optional.absent();

    public static void addTerrainBlockstoBiome(BiomeSettings biome, int topBlockID, int fillerBlockID) {
        if (!biome.getBiome().isPresent()) {
            return;
        }
        acq baseBiome = (acq)biome.getBiome().get();
        baseBiome.A = (byte)topBlockID;
        baseBiome.B = (byte)fillerBlockID;
    }

    public static void createBiome(BiomeSettings setting) throws Exception {
        if (acq.a[setting.getID()] != null) {
            throw new IllegalArgumentException(String.format("Biome id %d is already in use by %s when adding %s. Please review the configuration file.", setting.getID(), acq.a[setting.getID()].y, setting.toString()));
        }
        setting.createBiome();
    }

    public static Set<acg> discoverWorldTypes() {
        if (worldTypes.isEmpty()) {
            worldTypes.add(acg.b);
            worldTypes.add(acg.d);
            DiscoverWorldTypesEvent event = new DiscoverWorldTypesEvent(worldTypes);
            Api.getExtrabiomesXLEventBus().post((Event)event);
        }
        return ImmutableSet.copyOf(worldTypes);
    }

    public static void enableBiome(Set<acg> worldTypes, acq biome) {
        Extrabiomes.proxy.addBiome(worldTypes, biome);
        BiomeManager.addSpawnBiome((acq)biome);
        BiomeManager.addStrongholdBiome((acq)biome);
    }

    public static Collection<acq> getActiveBiomes() {
        if (!activeBiomes.isPresent()) {
            activeBiomes = Optional.of(new ArrayList(BiomeSettings.values().length));
            for (BiomeSettings setting : BiomeSettings.values()) {
                if (!setting.getBiome().isPresent() || setting.isVanilla()) continue;
                ((ArrayList)activeBiomes.get()).add(setting.getBiome().get());
            }
            ((ArrayList)activeBiomes.get()).trimToSize();
        }
        return ImmutableSet.copyOf((Collection)((Collection)activeBiomes.get()));
    }

    public static acq settingToBiomeGenBase(BiomeSettings setting) {
        switch (setting) {
            case DESERT: {
                return acq.d;
            }
            case EXTREMEHILLS: {
                return acq.e;
            }
            case FOREST: {
                return acq.f;
            }
            case JUNGLE: {
                return acq.w;
            }
            case SWAMPLAND: {
                return acq.h;
            }
            case TAIGA: {
                return acq.g;
            }
            case PLAINS: {
                return acq.c;
            }
        }
        return (acq)setting.getBiome().get();
    }

    public static void addWeightedGrassGen(Optional<? extends acq> biome, afe grassGen, int weight) {
        if (!biome.isPresent()) {
            return;
        }
        extrabiomes.api.BiomeManager.addWeightedGrassGenForBiome((acq)biome.get(), grassGen, weight);
    }
}

